/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.JsTestDriverServerImpl;
import com.google.jstestdriver.ObservableAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.NullPathPrefix;
import com.google.jstestdriver.model.RunData;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStartupAction
implements ObservableAction {
    private static final Logger logger = LoggerFactory.getLogger(ServerStartupAction.class);
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache preloadedFilesCache;
    private JsTestDriverServerImpl server;
    private List<Observer> observerList = new LinkedList<Observer>();
    private final long browserTimeout;
    private final boolean preloadFiles;
    private final FileLoader fileLoader;
    private final HandlerPathPrefix handlerPrefix;

    @Deprecated
    public ServerStartupAction(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, URLTranslator urlTranslator, URLRewriter urlRewriter) {
        this(port, capturedBrowsers, preloadedFilesCache, 30000L, false, null, new NullPathPrefix());
    }

    public ServerStartupAction(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, long browserTimeout, boolean preloadFiles, FileLoader fileLoader, HandlerPathPrefix handlerPrefix) {
        this.port = port;
        this.capturedBrowsers = capturedBrowsers;
        this.preloadedFilesCache = preloadedFilesCache;
        this.browserTimeout = browserTimeout;
        this.preloadFiles = preloadFiles;
        this.fileLoader = fileLoader;
        this.handlerPrefix = handlerPrefix;
    }

    public JsTestDriverServer getServer() {
        return this.server;
    }

    @Override
    public RunData run(RunData runData) {
        logger.info("Starting server on {}", this.port);
        if (this.preloadFiles) {
            logger.debug("Preloading files...", this.port);
            for (FileInfo fileInfo : this.fileLoader.loadFiles(runData.getFileSet(), false)) {
                this.preloadedFilesCache.addFile(fileInfo);
            }
        }
        this.server = new JsTestDriverServerImpl(this.port, this.capturedBrowsers, this.preloadedFilesCache, this.browserTimeout, this.handlerPrefix);
        for (Observer o : this.observerList) {
            this.server.addObserver(o);
        }
        try {
            this.server.start();
            for (int i = 1; i < 31; ++i) {
                if (this.server.isHealthy()) {
                    return runData;
                }
                Thread.sleep(1000L);
                if (i % 6 != 0) continue;
                logger.warn("Stopping unhealthy server and trying again.");
                this.server.stop();
                this.server.start();
            }
            throw new ServerStartupException("Server never healthy on " + this.port);
        }
        catch (Exception e) {
            throw new ServerStartupException("Error starting the server on " + this.port, e);
        }
    }

    @Override
    public void addObservers(List<Observer> observers) {
        this.observerList.addAll(observers);
    }

    public static class ServerStartupException
    extends RuntimeException {
        public ServerStartupException(String msg) {
            super(msg);
        }

        public ServerStartupException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

