/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.ProxyConfiguration;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfigurationHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProxyConfigurationHandler.class);
    private final HttpMethod method;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final PrintWriter responseWriter;
    private final JsonParser parser;
    private final ProxyConfiguration proxyConfiguration;

    @Inject
    public ProxyConfigurationHandler(HttpMethod method, HttpServletRequest request, HttpServletResponse response, @ResponseWriter PrintWriter responseWriter, JsonParser parser, ProxyConfiguration proxyConfiguration) {
        this.method = method;
        this.request = request;
        this.response = response;
        this.responseWriter = responseWriter;
        this.parser = parser;
        this.proxyConfiguration = proxyConfiguration;
    }

    public void handleIt() throws IOException {
        if (this.method.equals((Object)HttpMethod.GET)) {
            this.response.getWriter().println(this.proxyConfiguration.getProxyConfig());
        } else {
            try {
                this.proxyConfiguration.updateConfiguration(this.parser.parse(this.request.getReader()).getAsJsonArray());
            }
            catch (ServletException e) {
                logger.error("Error configuring proxy {}", e);
            }
        }
    }
}

