/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterParser {
    private final HttpServletRequest request;

    @Inject
    public ParameterParser(HttpServletRequest request) {
        this.request = request;
    }

    public Map<String, String> getParameterMap(Map<String, Integer> parameters, Set<String> blacklist) {
        HashMap<String, String> parsedParameterMap = Maps.newHashMap();
        Map requestParameterMap = this.request.getParameterMap();
        for (String key : Sets.intersection(requestParameterMap.keySet(), parameters.keySet())) {
            parsedParameterMap.put(key, this.safeArrayValue(0, (String[])requestParameterMap.get(key)));
        }
        String path = this.request.getPathInfo();
        if (path == null) {
            return parsedParameterMap;
        }
        String[] components = path.split("/");
        for (int i = 0; i < components.length; ++i) {
            String component = components[i].toLowerCase();
            if (parameters.containsKey(component)) {
                parsedParameterMap.put(component, this.safeArrayValue(i += parameters.get(component).intValue(), components));
                continue;
            }
            if (blacklist.contains(component) || component.isEmpty()) continue;
            throw new RuntimeException("Unknown argument: " + component + " in " + path);
        }
        return parsedParameterMap;
    }

    String safeArrayValue(int index, String[] values) {
        return index < values.length ? values[index] : null;
    }
}

