/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.LoadedFileInfo;
import com.google.jstestdriver.coverage.ClassFileLoader;
import com.google.jstestdriver.coverage.CoverageNameMapper;
import com.google.jstestdriver.hooks.ResourcePreProcessor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageJsAdder
implements ResourcePreProcessor {
    public static final String LCOV_JS = "com/google/jstestdriver/coverage/javascript/LCOV.js";
    private final ClassFileLoader fileLoader;
    private final CoverageNameMapper mapper;

    @Inject
    public CoverageJsAdder(ClassFileLoader fileLoader, CoverageNameMapper mapper) {
        this.fileLoader = fileLoader;
        this.mapper = mapper;
    }

    public List<FileInfo> processPlugins(List<FileInfo> files) {
        LinkedList<FileInfo> processed = new LinkedList<FileInfo>();
        processed.add(0, (FileInfo)new LoadedFileInfo(LCOV_JS, -1L, false, false, this.fileLoader.load("/com/google/jstestdriver/coverage/javascript/LCOV.js")));
        processed.addAll(files);
        return processed;
    }

    public List<FileInfo> processDependencies(List<FileInfo> files) {
        for (FileInfo fileInfo : files) {
            this.mapper.map(fileInfo.getFilePath());
        }
        return files;
    }

    public List<FileInfo> processTests(List<FileInfo> files) {
        for (FileInfo fileInfo : files) {
            this.mapper.map(fileInfo.getFilePath());
        }
        return files;
    }
}

