/* doc2.c was originally generated by the autoSql program, which also 
 * generated doc2.h and doc2.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "output/doc2.h"


struct point *pointLoad(char **row)
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */
{
struct point *ret;

AllocVar(ret);
ret->x = sqlFloat(row[0]);
ret->y = sqlFloat(row[1]);
ret->z = sqlFloat(row[2]);
return ret;
}

struct point *pointLoadAll(char *fileName) 
/* Load all point from a whitespace-separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointLoadAllByChar(char *fileName, char chopper) 
/* Load all point from a chopper separated file.
 * Dispose of this with pointFreeList(). */
{
struct point *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = pointLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct point *pointCommaIn(char **pS, struct point *ret)
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->x = sqlFloatComma(&s);
ret->y = sqlFloatComma(&s);
ret->z = sqlFloatComma(&s);
*pS = s;
return ret;
}

void pointOutput(struct point *el, FILE *f, char sep, char lastSep) 
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%g", el->x);
fputc(sep,f);
fprintf(f, "%g", el->y);
fputc(sep,f);
fprintf(f, "%g", el->z);
fputc(lastSep,f);
}

void pointJsonOutput(struct point *el, FILE *f) 
/* Print out point in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"x");
fputc('"',f);
fputc(':',f);
fprintf(f, "%g", el->x);
fputc(',',f);
fputc('"',f);
fprintf(f,"y");
fputc('"',f);
fputc(':',f);
fprintf(f, "%g", el->y);
fputc(',',f);
fputc('"',f);
fprintf(f,"z");
fputc('"',f);
fputc(':',f);
fprintf(f, "%g", el->z);
fputc('}',f);
}

struct color *colorLoad(char **row)
/* Load a color from row fetched with select * from color
 * from database.  Dispose of this with colorFree(). */
{
struct color *ret;

AllocVar(ret);
ret->red = sqlUnsigned(row[0]);
ret->green = sqlUnsigned(row[1]);
ret->blue = sqlUnsigned(row[2]);
return ret;
}

struct color *colorLoadAll(char *fileName) 
/* Load all color from a whitespace-separated file.
 * Dispose of this with colorFreeList(). */
{
struct color *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = colorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct color *colorLoadAllByChar(char *fileName, char chopper) 
/* Load all color from a chopper separated file.
 * Dispose of this with colorFreeList(). */
{
struct color *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = colorLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct color *colorCommaIn(char **pS, struct color *ret)
/* Create a color out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new color */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->red = sqlUnsignedComma(&s);
ret->green = sqlUnsignedComma(&s);
ret->blue = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void colorOutput(struct color *el, FILE *f, char sep, char lastSep) 
/* Print out color.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->red);
fputc(sep,f);
fprintf(f, "%u", el->green);
fputc(sep,f);
fprintf(f, "%u", el->blue);
fputc(lastSep,f);
}

void colorJsonOutput(struct color *el, FILE *f) 
/* Print out color in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"red");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->red);
fputc(',',f);
fputc('"',f);
fprintf(f,"green");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->green);
fputc(',',f);
fputc('"',f);
fprintf(f,"blue");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->blue);
fputc('}',f);
}

struct face *faceLoad(char **row)
/* Load a face from row fetched with select * from face
 * from database.  Dispose of this with faceFree(). */
{
struct face *ret;

AllocVar(ret);
ret->pointCount = sqlSigned(row[1]);
{
char *s = row[0];
if(s != NULL && differentString(s, ""))
   colorCommaIn(&s, &ret->color);
}
{
int sizeOne;
sqlUnsignedDynamicArray(row[2], &ret->points, &sizeOne);
assert(sizeOne == ret->pointCount);
}
return ret;
}

struct face *faceLoadAll(char *fileName) 
/* Load all face from a whitespace-separated file.
 * Dispose of this with faceFreeList(). */
{
struct face *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = faceLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct face *faceLoadAllByChar(char *fileName, char chopper) 
/* Load all face from a chopper separated file.
 * Dispose of this with faceFreeList(). */
{
struct face *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = faceLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct face *faceCommaIn(char **pS, struct face *ret)
/* Create a face out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new face */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
s = sqlEatChar(s, '{');
if(s[0] != '}')    colorCommaIn(&s, &ret->color);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->pointCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->points, ret->pointCount);
for (i=0; i<ret->pointCount; ++i)
    {
    ret->points[i] = sqlUnsignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void faceFree(struct face **pEl)
/* Free a single dynamically allocated face such as created
 * with faceLoad(). */
{
struct face *el;

if ((el = *pEl) == NULL) return;
freeMem(el->points);
freez(pEl);
}

void faceFreeList(struct face **pList)
/* Free a list of dynamically allocated face's */
{
struct face *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    faceFree(&el);
    }
*pList = NULL;
}

void faceOutput(struct face *el, FILE *f, char sep, char lastSep) 
/* Print out face.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('{',f);
colorCommaOut(&el->color,f);
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%d", el->pointCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->pointCount; ++i)
    {
    fprintf(f, "%u", el->points[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

void faceJsonOutput(struct face *el, FILE *f) 
/* Print out face in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"color");
fputc('"',f);
fputc(':',f);
colorJsonOutput(&el->color,f);
fputc(',',f);
fputc('"',f);
fprintf(f,"pointCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%d", el->pointCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"points");
fputc('"',f);
fputc(':',f);
{
int i;
fputc('[',f);
for (i=0; i<el->pointCount; ++i)
    {
    fprintf(f, "%u", el->points[i]);
    if (i<(el->pointCount)-1)
    fputc(',',f);
    }
fputc(']',f);
}
fputc('}',f);
}

struct polyhedron *polyhedronLoad(char **row)
/* Load a polyhedron from row fetched with select * from polyhedron
 * from database.  Dispose of this with polyhedronFree(). */
{
struct polyhedron *ret;

AllocVar(ret);
ret->faceCount = sqlSigned(row[0]);
ret->pointCount = sqlSigned(row[2]);
{
int i;
char *s = row[1];
for (i=0; i<ret->faceCount; ++i)
    {
    s = sqlEatChar(s, '{');
    slSafeAddHead(&ret->faces, faceCommaIn(&s, NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->faces);
}
{
int i;
char *s = row[3];
AllocArray(ret->points, ret->pointCount);
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    pointCommaIn(&s, &ret->points[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
}
return ret;
}

struct polyhedron *polyhedronLoadAll(char *fileName) 
/* Load all polyhedron from a whitespace-separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronLoadAllByChar(char *fileName, char chopper) 
/* Load all polyhedron from a chopper separated file.
 * Dispose of this with polyhedronFreeList(). */
{
struct polyhedron *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = polyhedronLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct polyhedron *polyhedronCommaIn(char **pS, struct polyhedron *ret)
/* Create a polyhedron out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polyhedron */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->faceCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->faceCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->faces, faceCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->faces);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->pointCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->points, ret->pointCount);
for (i=0; i<ret->pointCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        pointCommaIn(&s, &ret->points[i]);
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void polyhedronFree(struct polyhedron **pEl)
/* Free a single dynamically allocated polyhedron such as created
 * with polyhedronLoad(). */
{
struct polyhedron *el;

if ((el = *pEl) == NULL) return;
faceFreeList(&el->faces);
freeMem(el->points);
freez(pEl);
}

void polyhedronFreeList(struct polyhedron **pList)
/* Free a list of dynamically allocated polyhedron's */
{
struct polyhedron *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    polyhedronFree(&el);
    }
*pList = NULL;
}

void polyhedronOutput(struct polyhedron *el, FILE *f, char sep, char lastSep) 
/* Print out polyhedron.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->faceCount);
fputc(sep,f);
{
int i;
/* Loading face list. */
    {
    struct face *it = el->faces;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->faceCount; ++i)
        {
        fputc('{',f);
        faceCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(sep,f);
fprintf(f, "%d", el->pointCount);
fputc(sep,f);
{
int i;
/* Loading point list. */
    {
    struct point *it = el->points;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->pointCount; ++i)
        {
        fputc('{',f);
        pointCommaOut(&it[i],f);
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}

void polyhedronJsonOutput(struct polyhedron *el, FILE *f) 
/* Print out polyhedron in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"faceCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%d", el->faceCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"faces");
fputc('"',f);
fputc(':',f);
{
int i;
/* Loading face list. */
    {
    struct face *it = el->faces;
    fputc('[',f);
    for (i=0; i<el->faceCount; ++i)
        {
        faceJsonOutput(it,f);
        it = it->next;
        if (i<(el->faceCount)-1)
            fputc(',',f);
        }
    fputc(']',f);
    }
}
fputc(',',f);
fputc('"',f);
fprintf(f,"pointCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%d", el->pointCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"points");
fputc('"',f);
fputc(':',f);
{
int i;
/* Loading point list. */
    {
    struct point *it = el->points;
    fputc('[',f);
    for (i=0; i<el->pointCount; ++i)
        {
        pointJsonOutput(&it[i],f);
        if (i<(el->pointCount)-1)
            fputc(',',f);
        }
    fputc(']',f);
    }
}
fputc('}',f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

