/* agpFrag.h was originally generated by the autoSql program, which also 
 * generated agpFrag.c and agpFrag.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef AGPFRAG_H
#define AGPFRAG_H

struct agpFrag
/* How to get through chromosome based on fragments */
    {
    struct agpFrag *next;  /* Next in singly linked list. */
    char *chrom;	/* which chromosome */
    unsigned chromStart;	/* start position in chromosome */
    unsigned chromEnd;	/* end position in chromosome */
    int ix;	/* ix of this fragment (useless) */
    char type[2];	/* (P)redraft, (D)raft, (F)inished or (O)ther */
    char *frag;	/* which fragment */
    unsigned fragStart;	/* start position in frag */
    unsigned fragEnd;	/* end position in frag */
    char strand[2];	/* + or - (orientation of fragment) */
    };

void agpFragStaticLoad(char **row, struct agpFrag *ret);
/* Load a row from agpFrag table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct agpFrag *agpFragLoad(char **row);
/* Load a agpFrag from row fetched with select * from agpFrag
 * from database.  Dispose of this with agpFragFree(). */

struct agpFrag *agpFragCommaIn(char **pS, struct agpFrag *ret);
/* Create a agpFrag out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new agpFrag */

void agpFragFree(struct agpFrag **pEl);
/* Free a single dynamically allocated agpFrag such as created
 * with agpFragLoad(). */

void agpFragFreeList(struct agpFrag **pList);
/* Free a list of dynamically allocated agpFrag's */

void agpFragOutput(struct agpFrag *el, FILE *f, char sep, char lastSep);
/* Print out agpFrag.  Separate fields with sep. Follow last field with lastSep. */

#define agpFragTabOut(el,f) agpFragOutput(el,f,'\t','\n');
/* Print out agpFrag as a line in a tab-separated file. */

#define agpFragCommaOut(el,f) agpFragOutput(el,f,',',',');
/* Print out agpFrag as a comma separated list including final comma. */

struct agpFrag *agpFragLoadAll(char *fileName); 
/* Load all agpFrag from a tab-separated file.
 * Dispose of this with agpFragFreeList(). */

/* ---------------------- End autoSql generated code. ---------------------- */

struct agpFrag *agpFragLoadAllNotGaps(char *fileName) ;
/* Load all agpFrag that aren't gaps from a tab-separated file.
 * Dispose of this with agpFragFreeList(). */

#endif /* AGPFRAG_H */

