/* cgapSageLib.h was originally generated by the autoSql program, which also 
 * generated cgapSageLib.c and cgapSageLib.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CGAPSAGELIB_H
#define CGAPSAGELIB_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define CGAPSAGELIB_NUM_COLS 21

enum cgapSageLibSex
    {
    cgapSageLibMale = 0x0001,
    cgapSageLibFemale = 0x0002,
    };
struct cgapSageLib
/* CGAP SAGE libraries info */
    {
    struct cgapSageLib *next;  /* Next in singly linked list. */
    unsigned libId;	/* Numeric library ID */
    char *oldLibName;	/* Old library name */
    char *newLibName;	/* New library name */
    unsigned totalTags;	/* Total tags including linker */
    unsigned totalTagsNoLinker;	/* Total tags after eliminating linker */
    unsigned uniqueTags;	/* Unique tags */
    unsigned quality;	/* Library quality */
    char *tissue;	/* Organ/tissue */
    char *tissuePrep;	/* Tissue preparation */
    char *cellType;	/* Cell type */
    char *keywords;	/* Keywords */
    char *age;	/* Patient age */
    unsigned sex;	/* Patient sex */
    char *mutations;	/* Mutations */
    char *otherInfo;	/* Other information */
    char *tagEnzyme;	/* Tagging enzyme */
    char *anchorEnzyme;	/* Anchoring enzyme */
    char *cellSupplier;	/* Tissue or cell line supplier */
    char *libProducer;	/* Library producer */
    char *laboratory;	/* Laboratory */
    char *refs;	/* References */
    };

void cgapSageLibStaticLoad(char **row, struct cgapSageLib *ret);
/* Load a row from cgapSageLib table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cgapSageLib *cgapSageLibLoad(char **row);
/* Load a cgapSageLib from row fetched with select * from cgapSageLib
 * from database.  Dispose of this with cgapSageLibFree(). */

struct cgapSageLib *cgapSageLibLoadAll(char *fileName);
/* Load all cgapSageLib from whitespace-separated file.
 * Dispose of this with cgapSageLibFreeList(). */

struct cgapSageLib *cgapSageLibLoadAllByChar(char *fileName, char chopper);
/* Load all cgapSageLib from chopper separated file.
 * Dispose of this with cgapSageLibFreeList(). */

#define cgapSageLibLoadAllByTab(a) cgapSageLibLoadAllByChar(a, '\t');
/* Load all cgapSageLib from tab separated file.
 * Dispose of this with cgapSageLibFreeList(). */

struct cgapSageLib *cgapSageLibLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cgapSageLib from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cgapSageLibFreeList(). */

struct cgapSageLib *cgapSageLibCommaIn(char **pS, struct cgapSageLib *ret);
/* Create a cgapSageLib out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cgapSageLib */

void cgapSageLibFree(struct cgapSageLib **pEl);
/* Free a single dynamically allocated cgapSageLib such as created
 * with cgapSageLibLoad(). */

void cgapSageLibFreeList(struct cgapSageLib **pList);
/* Free a list of dynamically allocated cgapSageLib's */

void cgapSageLibOutput(struct cgapSageLib *el, FILE *f, char sep, char lastSep);
/* Print out cgapSageLib.  Separate fields with sep. Follow last field with lastSep. */

#define cgapSageLibTabOut(el,f) cgapSageLibOutput(el,f,'\t','\n');
/* Print out cgapSageLib as a line in a tab-separated file. */

#define cgapSageLibCommaOut(el,f) cgapSageLibOutput(el,f,',',',');
/* Print out cgapSageLib as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct hash *getTotTagsHash(struct cgapSageLib *libs);
/* Read in the library file and hash up the total tags. */

struct hash *getTotTagsHashFromFile(char *libFile);
/* Load a file then call getTotTagsHash. */

#endif /* CGAPSAGELIB_H */

