/* fishClones.h was originally generated by the autoSql program, which also 
 * generated fishClones.c and fishClones.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef FISHCLONES_H
#define FISHCLONES_H

struct fishClones
/* Describes the positions of fishClones in the assembly */
    {
    struct fishClones *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome number */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of clone */
    unsigned score;	/* Always 1000 */
    unsigned placeCount;	/* Number of times FISH'd */
    char **bandStarts;	/* Start FISH band */
    char **bandEnds;	/* End FISH band */
    char **labs;	/* Lab where clone FISH'd */
    char *placeType;	/* How clone was placed on the sequence assembly */
    unsigned accCount;	/* Number of accessions associated with the clone */
    char **accNames;	/* Accession associated with clone */
    unsigned stsCount;	/* Number of STS markers associated with this clone */
    char **stsNames;	/* Names of STS  markers */
    unsigned beCount;	/* Number of BAC end sequences associated with this clone */
    char **beNames;	/* Accessions of BAC ends */
    };

struct fishClones *fishClonesLoad(char **row);
/* Load a fishClones from row fetched with select * from fishClones
 * from database.  Dispose of this with fishClonesFree(). */

struct fishClones *fishClonesLoadAll(char *fileName);
/* Load all fishClones from a tab-separated file.
 * Dispose of this with fishClonesFreeList(). */

struct fishClones *fishClonesCommaIn(char **pS, struct fishClones *ret);
/* Create a fishClones out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fishClones */

void fishClonesFree(struct fishClones **pEl);
/* Free a single dynamically allocated fishClones such as created
 * with fishClonesLoad(). */

void fishClonesFreeList(struct fishClones **pList);
/* Free a list of dynamically allocated fishClones's */

void fishClonesOutput(struct fishClones *el, FILE *f, char sep, char lastSep);
/* Print out fishClones.  Separate fields with sep. Follow last field with lastSep. */

#define fishClonesTabOut(el,f) fishClonesOutput(el,f,'\t','\n');
/* Print out fishClones as a line in a tab-separated file. */

#define fishClonesCommaOut(el,f) fishClonesOutput(el,f,',',',');
/* Print out fishClones as a comma separated list including final comma. */

#endif /* FISHCLONES_H */

