/* stsMarker.h was originally generated by the autoSql program, which also 
 * generated stsMarker.c and stsMarker.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef STSMARKER_H
#define STSMARKER_H

struct stsMarker
/* STS marker and its position on golden path and various maps */
    {
    struct stsMarker *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of STS marker */
    unsigned score;	/* Score of a marker - depends on how many contigs it hits */
    unsigned identNo;	/* Identification number of STS */
    char *ctgAcc;	/* Contig accession number */
    char *otherAcc;	/* Accession number of other contigs that the marker hits */
    char *genethonChrom;	/* Chromosome (no chr) from Genethon map or 0 if none */
    float genethonPos;	/* Position on Genethon map */
    char *marshfieldChrom;	/* Chromosome (no chr) from Marshfield map or 0 if none */
    float marshfieldPos;	/* Position on Marshfield map */
    char *gm99Gb4Chrom;	/* Chromosome (no chr) from gm99_bg4 map or 0 if none */
    float gm99Gb4Pos;	/* Position on gm99_bg4 map */
    char *shgcG3Chrom;	/* Chromosome (no chr) from shgc_g3 map or 0 if none */
    float shgcG3Pos;	/* Position on shgc_g3 map */
    char *wiYacChrom;	/* Chromosome (no chr) from wi_yac map or 0 if none */
    float wiYacPos;	/* Position on wi_yac map */
    char *shgcTngChrom;	/* Chromosome (no chr) from shgc_tng map or 0 if none */
    float shgcTngPos;	/* Position on shgc_tng map */
    char *fishChrom;	/* Chromosome (no chr) from FISH map or 0 if none */
    char *beginBand;	/* Beginning of range of bands on FISH map */
    char *endBand;	/* End of range of bands on FISH map */
    };

void stsMarkerStaticLoad(char **row, struct stsMarker *ret);
/* Load a row from stsMarker table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct stsMarker *stsMarkerLoad(char **row);
/* Load a stsMarker from row fetched with select * from stsMarker
 * from database.  Dispose of this with stsMarkerFree(). */

struct stsMarker *stsMarkerCommaIn(char **pS, struct stsMarker *ret);
/* Create a stsMarker out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsMarker */

void stsMarkerFree(struct stsMarker **pEl);
/* Free a single dynamically allocated stsMarker such as created
 * with stsMarkerLoad(). */

void stsMarkerFreeList(struct stsMarker **pList);
/* Free a list of dynamically allocated stsMarker's */

void stsMarkerOutput(struct stsMarker *el, FILE *f, char sep, char lastSep);
/* Print out stsMarker.  Separate fields with sep. Follow last field with lastSep. */

#define stsMarkerTabOut(el,f) stsMarkerOutput(el,f,'\t','\n');
/* Print out stsMarker as a line in a tab-separated file. */

#define stsMarkerCommaOut(el,f) stsMarkerOutput(el,f,',',',');
/* Print out stsMarker as a comma separated list including final comma. */

#endif /* STSMARKER_H */

