# tigrCmrGene.sql was originally generated by the autoSql program, which also 
# generated tigrCmrGene.c and tigrCmrGene.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#For TIGR CMR genes tracks
CREATE TABLE tigrCmrGene (
    bin smallint not null,	# Bin number for browser speedup
    chrom varchar(255) not null,	# Human chromosome or FPC contig
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# TIGR locus
    score int unsigned not null,	# Score from 900-1000.  1000 is best
    strand char(1) not null,	# Value should be + or -
    tigrCommon longblob not null,	# TIGR Common Name
    tigrGene varchar(255) not null,	# TIGR Gene Symbol
    tigrECN varchar(255) not null,	# TIGR Enzyme Commission Number
    primLocus varchar(255) not null,	# Primary Locus Name
    tigrLength int unsigned not null,	# TIGR sequence length
    tigrPepLength int unsigned not null,	# TIGR Protein length
    tigrMainRole longblob not null,	# TIGR Main Role
    tigrSubRole longblob not null,	# TIGR Sub Role
    swissProt varchar(255) not null,	# SwissProt TrEMBL Accession
    genbank varchar(255) not null,	# Genbank ID
    tigrMw float not null,	# Molecular Weight
    tigrPi float not null,	# Isoelectric point (I think)
    tigrGc float not null,	# GC content
    goTerm varchar(255) not null,	# GO term (gene ontology)
              #Indices
    INDEX(bin),
    INDEX(chromStart),
    PRIMARY KEY(name)
);
