table txEdgeOrtho
"A transcription edge with additional orthology information."
    (
    string chrom;	"Chromosome or contig name"
    int chromStart;	"Start position, zero-based"
    int chromEnd;	"End position, non-inclusive"
    string name;	"Name of txGraph in other organism"
    int score;		"Parts per thousand of edge that align"
    char[1] strand;	"Strand - either plus or minus"
    char[1] startType;	"[ or ( for hard or soft"
    enum(exon, intron) type; "edge type"
    char[1] endType;	"] or ) for hard or soft"
    string mappedChrom;	"Chromosome in other organism"
    int mappedStart;	"ChromStart mapped to other organism"
    int mappedEnd;	"ChromEnd mapped to other organism"
    string txGraph; "Transcription graph name in this organism"
    int overlapScore;  "Parts per thousand of mapped/ortho overlap"
    char[1] orthoStrand; "Strand of orthologous txGraph"
    char[1] orthoStartType; "Is orthologous start hard/soft?"
    char[1] orthoEndType; "Is orthologous end hard/soft?"
    int orthoStart;	"Start of orthologous edge (based on RNA in other species)"
    int orthoEnd;	"End of orthologous edge (based on RNA in other species)"
    )
