/* hugoMulti.h was originally generated by the autoSql program, which also 
 * generated hugoMulti.c and hugoMulti.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef HUGOMULTI_H
#define HUGOMULTI_H

struct hugoMulti
/* A multiple-ID table from HUGO.  (From file nomeids.txt) */
    {
    struct hugoMulti *next;  /* Next in singly linked list. */
    unsigned hgnc;	/* HUGO Numerical ID. */
    char *symbol;	/* HUGO symbol. */
    char *name;	/* Extended name. */
    char *map;	/* Chromosome band/range. */
    char *omimId;	/* OMIM ID if any. */
    unsigned pmId1;	/* ?? */
    unsigned pmId2;	/* ?? */
    char *refSeqAcc;	/* Accession of RefSeq mRNA. */
    char *aliases;	/* List of comma and space separated aliases. */
    unsigned locusLinkId;	/* Locus link ID or 0 if nonw. */
    char *gdbId;	/* NCBI GDB ID. */
    };

void hugoMultiStaticLoad(char **row, struct hugoMulti *ret);
/* Load a row from hugoMulti table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hugoMulti *hugoMultiLoad(char **row);
/* Load a hugoMulti from row fetched with select * from hugoMulti
 * from database.  Dispose of this with hugoMultiFree(). */

struct hugoMulti *hugoMultiCommaIn(char **pS, struct hugoMulti *ret);
/* Create a hugoMulti out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hugoMulti */

void hugoMultiFree(struct hugoMulti **pEl);
/* Free a single dynamically allocated hugoMulti such as created
 * with hugoMultiLoad(). */

void hugoMultiFreeList(struct hugoMulti **pList);
/* Free a list of dynamically allocated hugoMulti's */

void hugoMultiOutput(struct hugoMulti *el, FILE *f, char sep, char lastSep);
/* Print out hugoMulti.  Separate fields with sep. Follow last field with lastSep. */

#define hugoMultiTabOut(el,f) hugoMultiOutput(el,f,'\t','\n');
/* Print out hugoMulti as a line in a tab-separated file. */

#define hugoMultiCommaOut(el,f) hugoMultiOutput(el,f,',',',');
/* Print out hugoMulti as a comma separated list including final comma. */

#endif /* HUGOMULTI_H */

