/* jobResult.c was originally generated by the autoSql program, which also 
 * generated jobResult.h and jobResult.sql.  This module links the database and
 * the RAM representation of objects. */

#include "paraCommon.h"
#include "linefile.h"
#include "dystring.h"
#include "sqlNum.h"
#include "sqlList.h"
#include "jobResult.h"

void jobResultStaticLoad(char **row, struct jobResult *ret)
/* Load a row from jobResult table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->status = sqlSigned(row[0]);
ret->host = row[1];
ret->jobId = row[2];
ret->exe = row[3];
ret->usrTicks = sqlSigned(row[4]);
ret->sysTicks = sqlSigned(row[5]);
ret->submitTime = sqlUnsigned(row[6]);
ret->startTime = sqlUnsigned(row[7]);
ret->endTime = sqlUnsigned(row[8]);
ret->user = row[9];
ret->errFile = row[10];
}

struct jobResult *jobResultLoad(char **row)
/* Load a jobResult from row fetched with select * from jobResult
 * from database.  Dispose of this with jobResultFree(). */
{
struct jobResult *ret;

AllocVar(ret);
ret->status = sqlSigned(row[0]);
ret->host = cloneString(row[1]);
ret->jobId = cloneString(row[2]);
ret->exe = cloneString(row[3]);
ret->usrTicks = sqlSigned(row[4]);
ret->sysTicks = sqlSigned(row[5]);
ret->submitTime = sqlUnsigned(row[6]);
ret->startTime = sqlUnsigned(row[7]);
ret->endTime = sqlUnsigned(row[8]);
ret->user = cloneString(row[9]);
ret->errFile = cloneString(row[10]);
return ret;
}

struct jobResult *jobResultLoadAll(char *fileName, off_t *resultBookMark, off_t resultsSize) 
/* Load all jobResult from a tab-separated file, starting from bookMark, ending at resultsSize.
 * Dispose of this with jobResultFreeList(). */
{
struct jobResult *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, FALSE);
int lineSize, wordCount;
char *row[11], *line;
off_t bookMark = *resultBookMark;
lineFileSeek(lf, bookMark, SEEK_SET);
if (bookMark > resultsSize)
    errAbort("bookMark (%llu) > resultsSize (%llu)", 
      (unsigned long long) bookMark,
      (unsigned long long) resultsSize);
if (bookMark == resultsSize)
    return list;
while (lineFileNext(lf, &line, &lineSize))
    {
    bookMark = lineFileTell(lf);
    if (bookMark >= resultsSize)
	break;
    char lastChar = line[lineSize-1];
    if (lastChar != '\n')
    	{
	// warn("Skipping incomplete last line of %s", fileName);
	break;
	}
    line[lineSize-1] = 0;
    wordCount = chopLine(line, row);
    lineFileExpectWords(lf, ArraySize(row), wordCount);
    el = jobResultLoad(row);
    slAddHead(&list, el);
    }
bookMark = lineFileTell(lf);
lineFileClose(&lf);
slReverse(&list);
*resultBookMark = bookMark;
return list;
}

#ifdef USING_SQL
struct jobResult *jobResultLoadWhere(struct sqlConnection *conn, char *table, char *where)
/* Load all jobResult from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with jobResultFreeList(). */
{
struct jobResult *list = NULL, *el;
struct dyString *query = dyStringNew(256);
struct sqlResult *sr;
char **row;

dyStringPrintf(query, "select * from %s", table);
if (where != NULL)
    dyStringPrintf(query, " where %s", where);
sr = sqlGetResult(conn, query->string);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = jobResultLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
dyStringFree(&query);
return list;
}
#endif /* USEING_SQL */

struct jobResult *jobResultCommaIn(char **pS, struct jobResult *ret)
/* Create a jobResult out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jobResult */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->status = sqlSignedComma(&s);
ret->host = sqlStringComma(&s);
ret->jobId = sqlStringComma(&s);
ret->exe = sqlStringComma(&s);
ret->usrTicks = sqlSignedComma(&s);
ret->sysTicks = sqlSignedComma(&s);
ret->submitTime = sqlUnsignedComma(&s);
ret->startTime = sqlUnsignedComma(&s);
ret->endTime = sqlUnsignedComma(&s);
ret->user = sqlStringComma(&s);
ret->errFile = sqlStringComma(&s);
*pS = s;
return ret;
}

void jobResultFree(struct jobResult **pEl)
/* Free a single dynamically allocated jobResult such as created
 * with jobResultLoad(). */
{
struct jobResult *el;

if ((el = *pEl) == NULL) return;
freeMem(el->host);
freeMem(el->jobId);
freeMem(el->exe);
freeMem(el->user);
freeMem(el->errFile);
freez(pEl);
}

void jobResultFreeList(struct jobResult **pList)
/* Free a list of dynamically allocated jobResult's */
{
struct jobResult *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jobResultFree(&el);
    }
*pList = NULL;
}

void jobResultOutput(struct jobResult *el, FILE *f, char sep, char lastSep) 
/* Print out jobResult.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->status);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->host);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->jobId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->exe);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->usrTicks);
fputc(sep,f);
fprintf(f, "%d", el->sysTicks);
fputc(sep,f);
fprintf(f, "%u", el->submitTime);
fputc(sep,f);
fprintf(f, "%u", el->startTime);
fputc(sep,f);
fprintf(f, "%u", el->endTime);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->user);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errFile);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

