/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import java.util.Calendar;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.datepicker.ArrowFigure;
import org.xmind.ui.datepicker.BaseFigure;
import org.xmind.ui.datepicker.CalendarAnimation;
import org.xmind.ui.datepicker.ConstraintStackLayout;
import org.xmind.ui.datepicker.DateLabelProvider;
import org.xmind.ui.datepicker.DatePanelLayout;
import org.xmind.ui.datepicker.DateSelection;
import org.xmind.ui.datepicker.DayFigure;
import org.xmind.ui.datepicker.HorizontalLine;
import org.xmind.ui.datepicker.HourFigure;
import org.xmind.ui.datepicker.IAnimationAdvisor;
import org.xmind.ui.datepicker.LastMonthAnimation;
import org.xmind.ui.datepicker.LastYearAnimation;
import org.xmind.ui.datepicker.Messages;
import org.xmind.ui.datepicker.MinutesFigure;
import org.xmind.ui.datepicker.MonthFigure;
import org.xmind.ui.datepicker.NextMonthAnimation;
import org.xmind.ui.datepicker.NextYearAnimation;
import org.xmind.ui.datepicker.TextLayer;
import org.xmind.ui.datepicker.YearFigure;
import org.xmind.ui.dialogs.PopupDialog;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.MButton;
import org.xmind.ui.viewers.SWTUtils;

public class DatePicker
extends Viewer {
    public static final String[] MONTHS = new String[]{Messages.January, Messages.Feburary, Messages.March, Messages.April, Messages.May, Messages.June, Messages.July, Messages.August, Messages.September, Messages.October, Messages.November, Messages.December};
    public static final String[] WEEK_SYMBOLS = new String[]{Messages.Sunday, Messages.Monday, Messages.Tuesday, Messages.Wednesday, Messages.Thursday, Messages.Friday, Messages.Saturday};
    public static final int TIME_12 = 12;
    public static final int TIME_24 = 24;
    public static final int CORNER = 8;
    public static final int LOAD_TIMEPICKER = 8;
    private static final int FUTURE_YEARS = 7;
    private static final int PASSED_YEARS = 3;
    private static final String TEXT = "#000000";
    private static final String WEEKEND = "#EE0000";
    private static final String SEPARATOR = "#C0C0C0";
    private static final String TODAY = "#ff9900";
    private static final String WEEK_SYMBOL = "#808080";
    private static final String ARROW_BORDER = "#808080";
    private static final String ARROW_FILL = "#C0C0C0";
    private static final String CANCEL = "#D80000";
    private static final String TIME = "#5D5D5D";
    protected static final int NORMAL_ALPHA = 255;
    protected static final int SIBLING_MONTH_ALPHA = 32;
    private static final int DURATION = 200;
    protected static final int TOTAL_DAYS = 42;
    private int style;
    private int type = 12;
    private Control control;
    private FigureCanvas datePicker;
    private BaseFigure timePicker;
    private HourFigure hourFigure;
    private MinutesFigure minutesFigure;
    private BaseFigure timeLabel;
    private ArrowFigure beforeTime;
    private ArrowFigure afterTime;
    private MButton placeholder;
    private ILabelProvider dateLabelProvider;
    private DropdownDatePicker dropdownDatePicker;
    private Calendar today;
    private int currentMonth;
    private int currentYear;
    private int currentHour;
    private int currentMinutes;
    private Calendar selection;
    private IFigure dateLayer;
    private IFigure datePanel;
    private MonthFigure monthFigure;
    private YearFigure yearFigure;
    private BaseFigure todayFigure;
    private BaseFigure cancelFigure;
    private EventHandler eventHandler;
    private MenuManager monthMenu;
    private MonthAction[] monthActions;
    private MenuManager yearMenu;
    private YearAction[] yearActions;
    private ArrowFigure lastYear;
    private ArrowFigure nextYear;
    private ArrowFigure lastMonth;
    private ArrowFigure nextMonth;
    private boolean firingSelectionChange = false;
    private boolean animating = false;
    private IAnimationAdvisor animationAdvisor = new AnimationAdvisor();
    private boolean isPopupEditing = false;

    public DatePicker(Composite parent, int style) {
        this(parent, style, Calendar.getInstance());
    }

    public DatePicker(Composite parent, int style, Calendar today) {
        today.set(11, 0);
        today.set(12, 0);
        this.today = today;
        this.currentMonth = today.get(2);
        this.currentYear = today.get(1);
        this.currentHour = today.get(11);
        this.currentMinutes = today.get(12);
        this.style = style;
        if ((style & 4) != 0) {
            this.createPlaceholder(parent);
            this.control = this.placeholder.getControl();
            this.initPlaceholder();
        } else {
            this.createDatePicker(parent);
            this.control = this.datePicker;
            this.initDatePicker();
        }
        this.update();
    }

    private void createPlaceholder(Composite parent) {
        this.placeholder = new MButton(parent, 0);
    }

    private void createDatePicker(Composite parent) {
        this.datePicker = new FigureCanvas(parent);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.dateLabelProvider = labelProvider;
        this.update();
    }

    public ILabelProvider getLabelProvider() {
        if (this.dateLabelProvider == null) {
            this.dateLabelProvider = new DateLabelProvider();
        }
        return this.dateLabelProvider;
    }

    public Control getControl() {
        return this.control;
    }

    public FigureCanvas getDatePicker() {
        return this.datePicker;
    }

    public boolean isPopupEditing() {
        return this.isPopupEditing;
    }

    public void setBackground(Color color) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBackground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.placeholder != null) {
            this.placeholder.setEnabled(enabled);
        }
    }

    public MButton getPlaceholder() {
        return this.placeholder;
    }

    public ISelection getSelection() {
        return new DateSelection(this.selection);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        Object sel;
        if (selection instanceof DateSelection) {
            this.setDateSelection(((DateSelection)selection).getDate(), reveal);
        } else if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof Calendar) {
            this.setDateSelection((Calendar)sel, reveal);
        }
    }

    public void setDateSelection(Calendar date, boolean reveal) {
        this.changeDate(date);
        if (reveal && date != null) {
            this.changeCalendar(date.get(1), date.get(2), date.get(11), date.get(12));
        }
        this.update();
    }

    private void initPlaceholder() {
        this.placeholder.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (DatePicker.this.dropdownDatePicker == null || DatePicker.this.dropdownDatePicker.getShell() == null || DatePicker.this.dropdownDatePicker.getShell().isDisposed() || !DatePicker.this.dropdownDatePicker.isClosing()) {
                    DatePicker.this.showDropdown();
                }
            }
        });
    }

    private void showDropdown() {
        this.placeholder.setForceFocus(true);
        this.createDropdownDatePicker();
        this.dropdownDatePicker.open();
        Shell shell = this.dropdownDatePicker.getShell();
        int x = this.placeholder.getControl().getBounds().width;
        x = x < 230 ? 230 : x;
        x = x > 250 ? 250 : x;
        shell.setSize(x, x + 30);
        if (shell != null && !shell.isDisposed()) {
            shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (DatePicker.this.placeholder != null && !DatePicker.this.placeholder.getControl().isDisposed()) {
                        DatePicker.this.placeholder.setForceFocus(false);
                        DatePicker.this.updateSelection();
                        DatePicker.this.closeDatePicker();
                    }
                }
            });
        } else {
            this.placeholder.setForceFocus(false);
        }
    }

    private void closeDatePicker() {
        if (this.firingSelectionChange) {
            return;
        }
        this.firingSelectionChange = true;
        if (this.dropdownDatePicker != null) {
            this.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DatePicker.this.dropdownDatePicker.close();
                }
            });
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firingSelectionChange = false;
    }

    public void open() {
        this.showDropdown();
    }

    public void close() {
        if (this.dropdownDatePicker != null) {
            this.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DatePicker.this.dropdownDatePicker.close();
                }
            });
        }
    }

    private void createDropdownDatePicker() {
        if (this.dropdownDatePicker != null) {
            return;
        }
        this.dropdownDatePicker = new DropdownDatePicker(this.control.getShell());
    }

    private void initDatePicker() {
        this.datePicker.setScrollBarVisibility(FigureCanvas.NEVER);
        this.eventHandler = new EventHandler();
        this.eventHandler.install((Control)this.datePicker);
        this.datePicker.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DatePicker.this.eventHandler.uninstall((Control)DatePicker.this.datePicker);
            }
        });
        Viewport viewport = new Viewport(true);
        viewport.setContentsTracksHeight(true);
        viewport.setContentsTracksWidth(true);
        this.datePicker.setViewport(viewport);
        Layer container = new Layer();
        this.datePicker.setContents((IFigure)container);
        GridLayout containerLayout = new GridLayout(1, true);
        containerLayout.horizontalSpacing = 3;
        containerLayout.verticalSpacing = 3;
        containerLayout.marginHeight = 3;
        containerLayout.marginWidth = 3;
        container.setLayoutManager((LayoutManager)containerLayout);
        this.createTopPanel((IFigure)container);
        this.createSeparator((IFigure)container);
        this.createWeekPanel((IFigure)container);
        this.createDaysPanel((IFigure)container);
        this.createSeparator((IFigure)container);
        this.createBottomPanel((IFigure)container);
    }

    private void createTopPanel(IFigure parent) {
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        GridLayout panelLayout = new GridLayout(12, true);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 0;
        panelLayout.marginWidth = 0;
        panel.setLayoutManager((LayoutManager)panelLayout);
        this.lastMonth = this.createArrowFigure((IFigure)panel, 8);
        this.monthFigure = this.createMonthFigure((IFigure)panel);
        this.nextMonth = this.createArrowFigure((IFigure)panel, 32);
        this.lastYear = this.createArrowFigure((IFigure)panel, 1);
        this.yearFigure = this.createYearFigure((IFigure)panel);
        this.nextYear = this.createArrowFigure((IFigure)panel, 4);
    }

    private MonthFigure createMonthFigure(IFigure parent) {
        MonthFigure figure = new MonthFigure();
        figure.setTextCandidates(MONTHS);
        GridData constraint = new GridData(4, 4, true, true);
        constraint.horizontalSpan = 5;
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private YearFigure createYearFigure(IFigure parent) {
        YearFigure figure = new YearFigure();
        figure.setTextCandidates(new String[]{"0000"});
        GridData constraint = new GridData(4, 4, true, true);
        constraint.horizontalSpan = 3;
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private ArrowFigure createArrowFigure(IFigure parent, int orientation) {
        ArrowFigure arrow = new ArrowFigure();
        arrow.setOrientation(orientation);
        arrow.setForegroundColor(ColorUtils.getColor((String)"#808080"));
        arrow.setBackgroundColor(ColorUtils.getColor((String)"#C0C0C0"));
        arrow.getContent().setVisible(false);
        GridData constraint = new GridData(4, 4, true, true);
        parent.add((IFigure)arrow, (Object)constraint);
        this.eventHandler.attach((IFigure)arrow);
        return arrow;
    }

    private void createSeparator(IFigure parent) {
        HorizontalLine line = new HorizontalLine();
        line.setMargin(3);
        line.setForegroundColor(ColorUtils.getColor((String)"#C0C0C0"));
        GridData constraint = new GridData(4, 4, true, false);
        constraint.heightHint = 3;
        parent.add((IFigure)line, (Object)constraint);
    }

    private void createWeekPanel(IFigure parent) {
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        GridLayout panelLayout = new GridLayout(7, true);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 0;
        panelLayout.marginWidth = 0;
        panel.setLayoutManager((LayoutManager)panelLayout);
        Font symbolFont = FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2);
        int i = 0;
        while (i < 7) {
            TextLayer symbol = new TextLayer();
            symbol.setFont(symbolFont);
            symbol.setText(WEEK_SYMBOLS[i]);
            if (i == 0 || i == 6) {
                symbol.setForegroundColor(ColorUtils.getColor((String)WEEKEND));
            } else {
                symbol.setForegroundColor(ColorUtils.getColor((String)"#808080"));
            }
            GridData symbolConstraint = new GridData(4, 4, true, true);
            panel.add((IFigure)symbol, (Object)symbolConstraint);
            ++i;
        }
    }

    private void createDaysPanel(IFigure parent) {
        this.dateLayer = new Layer();
        GridData layerConstraint = new GridData(4, 4, true, true);
        parent.add(this.dateLayer, (Object)layerConstraint);
        this.dateLayer.setLayoutManager((LayoutManager)new ConstraintStackLayout());
        this.datePanel = new Layer();
        this.dateLayer.add(this.datePanel, null);
        this.datePanel.setLayoutManager((LayoutManager)new DatePanelLayout());
        int i = 0;
        while (i < 42) {
            DayFigure dayFigure = new DayFigure();
            this.eventHandler.attach((IFigure)dayFigure);
            this.datePanel.add((IFigure)dayFigure);
            ++i;
        }
    }

    private void createBottomPanel(IFigure parent) {
        boolean hasCancel = (this.style & 0x100) != 0;
        boolean hasTimePicker = (this.style & 8) != 0;
        Layer panel = new Layer();
        GridData panelConstraint = new GridData(4, 4, true, false);
        parent.add((IFigure)panel, (Object)panelConstraint);
        int cols = 0;
        cols = hasCancel ? 2 : 1;
        cols = hasTimePicker ? cols + 2 : cols;
        GridLayout panelLayout = new GridLayout(cols, false);
        panelLayout.horizontalSpacing = 0;
        panelLayout.verticalSpacing = 0;
        panelLayout.marginHeight = 10;
        panelLayout.marginWidth = 5;
        panel.setLayoutManager((LayoutManager)panelLayout);
        this.todayFigure = this.createTodayFigure((IFigure)panel);
        if (hasTimePicker) {
            this.timePicker = this.createTimeFigure((IFigure)panel);
            this.timeLabel = this.createLabelOfTime((IFigure)panel);
        }
        if (hasCancel) {
            this.cancelFigure = this.createCancelFigure((IFigure)panel);
        }
    }

    private BaseFigure createTodayFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0));
        figure.setForegroundColor(ColorUtils.getColor((String)TEXT));
        GridData constraint = new GridData(0x1000000, 0x1000000, true, true);
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private BaseFigure createCancelFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setText(" X ");
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        figure.setForegroundColor(ColorUtils.getColor((String)CANCEL));
        GridData constraint = new GridData(4, 4, false, true);
        parent.add((IFigure)figure, (Object)constraint);
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private BaseFigure createTimeFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        figure.setForegroundColor(ColorConstants.white);
        figure.setBackgroundColor(ColorConstants.white);
        figure.setOpaque(true);
        GridData constraint = new GridData(4, 4, false, false);
        figure.setLayoutManager((LayoutManager)new XYLayout());
        parent.add((IFigure)figure, (Object)constraint);
        Layer panel = new Layer();
        figure.add((IFigure)panel, new Rectangle(0, 2, 60, 20));
        panel.setBorder((Border)new LineBorder(ColorConstants.lightGray, 1));
        panel.setForegroundColor(ColorConstants.white);
        XYLayout layout = new XYLayout();
        panel.setLayoutManager((LayoutManager)layout);
        this.hourFigure = this.createHourFigure((IFigure)panel);
        BaseFigure point = this.createPointFigure((IFigure)panel);
        this.minutesFigure = this.createMinutesFigure((IFigure)panel);
        panel.add((IFigure)this.hourFigure, (Object)new Rectangle(0, 0, 25, 18));
        panel.add((IFigure)point, (Object)new Rectangle(26, 0, 3, 18));
        panel.add((IFigure)this.minutesFigure, (Object)new Rectangle(31, 0, 25, 18));
        return figure;
    }

    private BaseFigure createPointFigure(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setSize(3, 18);
        figure.setText(" : ");
        figure.setForegroundColor(ColorUtils.getColor((String)TIME));
        parent.add((IFigure)figure);
        return figure;
    }

    private HourFigure createHourFigure(IFigure parent) {
        HourFigure figure = new HourFigure();
        figure.setHour(this.currentHour, this.type);
        figure.setTextCandidates(new String[]{" 00 "});
        figure.setForegroundColor(ColorUtils.getColor((String)TIME));
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private MinutesFigure createMinutesFigure(IFigure parent) {
        MinutesFigure figure = new MinutesFigure();
        figure.setMinutes(this.currentMinutes);
        figure.setTextCandidates(new String[]{" 00 "});
        figure.setForegroundColor(ColorUtils.getColor((String)TIME));
        this.eventHandler.attach((IFigure)figure);
        return figure;
    }

    private BaseFigure createLabelOfTime(IFigure parent) {
        BaseFigure figure = new BaseFigure();
        figure.setText(this.getTimeLabel());
        figure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        figure.setForegroundColor(ColorUtils.getColor((String)TEXT));
        figure.setCursor(Cursors.ARROW);
        GridData constraint = new GridData(4, 4, false, true);
        parent.add((IFigure)figure, (Object)constraint);
        return figure;
    }

    private String getTimeLabel() {
        if (this.currentHour >= 0 && this.currentHour < 12) {
            return Messages.DatePicker_Time_AM_text;
        }
        if (this.currentHour >= 12 && this.currentHour < 24) {
            return Messages.DatePicker_Time_PM_text;
        }
        return "";
    }

    private Calendar getSelectedDate() {
        return this.selection;
    }

    private static boolean isSameDay(Calendar date1, Calendar date2) {
        if (date1 == null) {
            return date2 == null;
        }
        if (date2 == null) {
            return false;
        }
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    protected void changeCalendar(int newYear, int newMonth, int newHour, int newMinutes) {
        this.changeCalendar(newYear, newMonth, newHour, newMinutes, false);
    }

    protected void changeCalendar(int newYear, int newMonth, int hours, int minutes, boolean smooth) {
        boolean calendarChanged;
        boolean bl = calendarChanged = newMonth != this.currentMonth || newYear != this.currentYear || this.currentHour != hours || this.currentMinutes != minutes;
        if (!calendarChanged) {
            return;
        }
        if (smooth) {
            if (this.datePicker != null) {
                int months = (newYear - this.currentYear) * 12 + newMonth - this.currentMonth;
                this.animationAdvisor.addYearsToRoll(months / 12);
                this.animationAdvisor.addMonthsToRoll(months % 12);
                this.performRollCalendarAnimation(this.currentYear, this.currentMonth);
            }
            this.currentYear = newYear;
            this.currentMonth = newMonth;
            this.currentHour = hours;
            this.currentMinutes = minutes;
        } else {
            this.currentYear = newYear;
            this.currentMonth = newMonth;
            this.currentHour = hours;
            this.currentMinutes = minutes;
            if (this.datePicker != null) {
                this.updateCalendar();
            }
            this.updateSelection();
        }
    }

    private void updateCalendar() {
        this.today = Calendar.getInstance();
        this.today.set(11, 0);
        this.today.set(12, 0);
        this.updateDayFigures(this.datePanel.getChildren(), this.currentYear, this.currentMonth);
        this.monthFigure.setMonth(this.currentMonth);
        this.yearFigure.setYear(this.currentYear);
        this.hourFigure.setHour(this.currentHour, this.type);
        this.minutesFigure.setMinutes(this.currentMinutes);
        this.todayFigure.setText(Messages.TodayPattern);
    }

    private void updateDayFigures(List dayFigures, int year, int month) {
        Calendar date = DatePicker.getCalendarStart(this.today, year, month);
        int i = 0;
        while (i < dayFigures.size()) {
            DayFigure dayFigure = (DayFigure)((Object)dayFigures.get(i));
            date = (Calendar)date.clone();
            if (i > 0) {
                date.add(5, 1);
            }
            dayFigure.setDate(date);
            this.updateDayFigure(dayFigure, year, month);
            ++i;
        }
    }

    void updateDayFigure(DayFigure figure, int year, int month) {
        figure.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        Calendar date = figure.getDate();
        if (DatePicker.isSameDay(date, this.today)) {
            figure.setForegroundColor(ColorUtils.getColor((String)TODAY));
        } else if (DatePicker.isWeekend(date)) {
            figure.setForegroundColor(ColorUtils.getColor((String)WEEKEND));
        } else {
            figure.setForegroundColor(ColorUtils.getColor((String)TEXT));
        }
        if (date.get(2) == month && date.get(1) == year) {
            figure.setTextAlpha(255);
        } else {
            figure.setTextAlpha(32);
        }
    }

    private void updateSelection() {
        if (this.datePicker != null) {
            for (Object figure : this.datePanel.getChildren()) {
                DayFigure dayFigure = (DayFigure)((Object)figure);
                dayFigure.setSelected(DatePicker.isSameDay(dayFigure.getDate(), this.getSelectedDate()));
            }
        }
        if (this.hourFigure != null && this.selection != null) {
            this.selection.set(11, this.hourFigure.getHour());
        }
        if (this.minutesFigure != null && this.selection != null) {
            this.selection.set(12, this.minutesFigure.getMinutes());
        }
        if (this.placeholder != null) {
            String text = this.getLabelProvider().getText((Object)this.selection);
            this.placeholder.setText(text);
        }
    }

    protected void update() {
        if (this.datePicker != null) {
            this.updateCalendar();
        }
        this.updateSelection();
    }

    private void performRollCalendarAnimation(int oldYear, int oldMonth) {
        CalendarAnimation animation;
        int newMonth;
        int newYear;
        if (this.animating) {
            return;
        }
        this.animating = true;
        if (this.animationAdvisor.getYearsToRoll() != 0) {
            if (this.animationAdvisor.getYearsToRoll() < 0) {
                newYear = oldYear - 1;
                newMonth = oldMonth;
                animation = new LastYearAnimation(this.animationAdvisor);
            } else {
                newYear = oldYear + 1;
                newMonth = oldMonth;
                animation = new NextYearAnimation(this.animationAdvisor);
            }
        } else if (this.animationAdvisor.getMonthsToRoll() != 0) {
            if (this.animationAdvisor.getMonthsToRoll() < 0) {
                newYear = oldMonth <= 0 ? oldYear - 1 : oldYear;
                newMonth = oldMonth <= 0 ? 11 : oldMonth - 1;
                animation = new LastMonthAnimation(this.animationAdvisor);
            } else {
                newYear = oldMonth >= 11 ? oldYear + 1 : oldYear;
                newMonth = oldMonth >= 11 ? 0 : oldMonth + 1;
                animation = new NextMonthAnimation(this.animationAdvisor);
            }
        } else {
            newYear = oldYear;
            newMonth = oldMonth;
            animation = null;
        }
        this.monthFigure.setMonth(newMonth);
        this.yearFigure.setYear(newYear);
        if (animation != null) {
            this.animationAdvisor.setStartMonth(oldYear, oldMonth);
            this.animationAdvisor.setEndMonth(newYear, newMonth);
            animation.callback(new Runnable(){

                @Override
                public void run() {
                    DatePicker.this.datePanel = animation.getNewPanel();
                    if (DatePicker.this.animationAdvisor.isDone()) {
                        DatePicker.this.animating = false;
                    } else {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DatePicker.this.animating = false;
                                DatePicker.this.performRollCalendarAnimation(newYear, newMonth);
                            }
                        });
                    }
                }
            }).start();
        }
    }

    static int calc(int start, int end, int current, int total) {
        return start + (end - start) * current / total;
    }

    protected void selected(BaseFigure target, BaseFigure pretarget) {
        if (target instanceof MonthFigure) {
            target.setSelected(true);
            this.showMonthPopup();
        } else if (target instanceof YearFigure) {
            target.setSelected(true);
            this.showYearPopup();
        } else if (target == this.todayFigure) {
            this.todaySelected();
        } else if (target == this.lastMonth) {
            this.lastMonthSelected(true);
        } else if (target == this.nextMonth) {
            this.nextMonthSelected(true);
        } else if (target == this.lastYear) {
            this.lastYearSelected(true);
        } else if (target == this.nextYear) {
            this.nextYearSelected(true);
        } else if (target == this.cancelFigure) {
            this.cancelSelected();
        } else if (target != this.beforeTime && target != this.afterTime) {
            if (target instanceof HourFigure) {
                if (this.minutesFigure != null) {
                    this.minutesFigure.setSelected(false);
                }
                this.hourSelected((HourFigure)target);
            } else if (target instanceof MinutesFigure) {
                if (this.hourFigure != null) {
                    this.hourFigure.setSelected(false);
                }
                this.minuteSelected((MinutesFigure)target);
            }
        }
    }

    protected void showMonthPopup() {
        this.createMonthMenu();
        int month = 0;
        while (month < this.monthActions.length) {
            MonthAction action = this.monthActions[month];
            action.setChecked(month == this.currentMonth);
            ++month;
        }
        Rectangle b = this.monthFigure.getBounds();
        Point loc = this.control.toDisplay(b.x, b.y + b.height);
        Menu menu = this.monthMenu.createContextMenu(this.control);
        menu.setLocation(loc.x + 10, loc.y + 1);
        menu.setVisible(true);
    }

    protected void createMonthMenu() {
        if (this.monthMenu != null) {
            return;
        }
        this.monthMenu = new MenuManager();
        this.monthMenu.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
            }

            public void menuAboutToHide(IMenuManager manager) {
                DatePicker.this.monthFigure.setSelected(false);
            }
        });
        this.monthActions = new MonthAction[12];
        int month = 0;
        while (month < 12) {
            MonthAction action = new MonthAction(month);
            this.monthMenu.add((IAction)action);
            this.monthActions[month] = action;
            ++month;
        }
    }

    protected void showYearPopup() {
        this.createYearMenu();
        int start = this.currentYear - 3;
        int year = 0;
        while (year < this.yearActions.length) {
            YearAction action = this.yearActions[year];
            action.setYear(start + year);
            action.setChecked(action.getYear() == this.currentYear);
            ++year;
        }
        Rectangle b = this.yearFigure.getBounds();
        Point loc = this.control.toDisplay(b.x, b.y + b.height);
        Menu menu = this.yearMenu.createContextMenu(this.control);
        menu.setLocation(loc.x, loc.y + 1);
        menu.setVisible(true);
    }

    protected void createYearMenu() {
        if (this.yearMenu != null) {
            return;
        }
        this.yearMenu = new MenuManager();
        this.yearMenu.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
            }

            public void menuAboutToHide(IMenuManager manager) {
                DatePicker.this.yearFigure.setSelected(false);
            }
        });
        this.yearActions = new YearAction[11];
        int year = 0;
        while (year < this.yearActions.length) {
            YearAction action = new YearAction();
            this.yearMenu.add((IAction)action);
            this.yearActions[year] = action;
            ++year;
        }
    }

    protected void monthSelected(int month) {
        this.changeCalendar(this.currentYear, month, this.currentHour, this.currentMinutes);
    }

    protected void yearSelected(int year) {
        this.changeCalendar(year, this.currentMonth, this.currentHour, this.currentMinutes);
    }

    protected void daySelected(DayFigure day) {
        Calendar date = day.getDate();
        if (date != null && date.get(2) != this.currentMonth) {
            this.changeCalendar(date.get(1), date.get(2), date.get(11), date.get(12), true);
        }
        if (date != null && date.get(11) != this.currentHour) {
            this.changeHourOrMinutes(true, date.get(11), date.get(12));
        }
        this.selection = date;
        this.changeDate(date);
    }

    protected void hourSelected(HourFigure hour) {
        hour.setSelected(true);
    }

    protected void minuteSelected(MinutesFigure minute) {
        minute.setSelected(true);
    }

    protected void todaySelected() {
        this.changeDate(this.today);
        this.changeCalendar(this.today.get(1), this.today.get(2), this.today.get(11), this.today.get(12));
        this.freshTimePicker(this.today.get(11), this.currentMinutes);
    }

    protected void lastMonthSelected(boolean smooth) {
        if (this.currentMonth <= 0) {
            this.changeCalendar(this.currentYear - 1, 11, this.currentHour, this.currentMinutes, smooth);
        } else {
            this.changeCalendar(this.currentYear, this.currentMonth - 1, this.currentHour, this.currentMinutes, smooth);
        }
    }

    protected void nextMonthSelected(boolean smooth) {
        if (this.currentMonth >= 11) {
            this.changeCalendar(this.currentYear + 1, 0, this.currentHour, this.currentMinutes, smooth);
        } else {
            this.changeCalendar(this.currentYear, this.currentMonth + 1, this.currentHour, this.currentMinutes, smooth);
        }
    }

    protected void lastYearSelected(boolean smooth) {
        this.changeCalendar(this.currentYear - 1, this.currentMonth, this.currentHour, this.currentMinutes, smooth);
    }

    protected void nextYearSelected(boolean smooth) {
        this.changeCalendar(this.currentYear + 1, this.currentMonth, this.currentHour, this.currentMinutes, smooth);
    }

    protected void cancelSelected() {
        this.changeDate(null);
    }

    protected void changeHourOrMinutes(boolean smooth, int newHour, int newMinutes) {
        this.freshTimePicker(newHour, newMinutes);
        if (this.selection != null) {
            this.selection.set(11, newHour);
            this.selection.set(12, newMinutes);
            this.changeDate(this.selection);
        }
        this.update();
    }

    private void freshTimePicker(int newHour, int newMinutes) {
        boolean minuteChanged = newMinutes != this.currentMinutes;
        newHour = this.resetHour(newHour);
        newMinutes = this.resetMinutes(newMinutes);
        if (this.timePicker != null) {
            if (this.hourFigure != null) {
                if (!this.validateHour(newHour)) {
                    return;
                }
                if (newHour >= 12) {
                    this.timeLabel.setText(Messages.DatePicker_Time_PM_text);
                } else if (newHour < 12) {
                    this.timeLabel.setText(Messages.DatePicker_Time_AM_text);
                }
                this.currentHour = newHour;
                this.hourFigure.setHour(newHour, this.type);
            }
            if (this.minutesFigure != null && minuteChanged) {
                if (!this.validateMinutes(newMinutes)) {
                    return;
                }
                this.currentMinutes = newMinutes;
                this.minutesFigure.setMinutes(newMinutes);
            }
        }
    }

    private int resetHour(int hour) {
        if (hour > 23) {
            return 0;
        }
        if (hour < 0 && this.type == 24) {
            hour = 23;
        } else if (hour < 0 && this.type == 12) {
            hour = 11;
        }
        return hour;
    }

    private int resetMinutes(int minutes) {
        if (minutes > 59) {
            minutes = 0;
        } else if (minutes < 0) {
            minutes = 59;
        }
        return minutes;
    }

    private boolean validateHour(int hour) {
        return hour >= 0 && hour <= 23;
    }

    private boolean validateMinutes(int minutes) {
        return minutes >= 0 && minutes < 60;
    }

    protected void rollMonth(int count) {
        Calendar temp = (Calendar)this.today.clone();
        temp.set(1, this.currentYear);
        temp.set(2, this.currentMonth);
        temp.add(2, count);
        this.changeCalendar(temp.get(1), temp.get(2), temp.get(11), temp.get(12), true);
    }

    protected void changeDate(Calendar date) {
        this.selection = date;
        this.updateSelection();
        if (this.firingSelectionChange) {
            return;
        }
        this.firingSelectionChange = true;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        this.firingSelectionChange = false;
    }

    public Object getInput() {
        return this.today;
    }

    public void refresh() {
        this.update();
    }

    public void setInput(Object input) {
        if (input instanceof Calendar) {
            Calendar oldInput = this.today;
            this.today = (Calendar)input;
            this.inputChanged(input, oldInput);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.update();
    }

    private static boolean isWeekend(Calendar date) {
        int dow = date.get(7);
        return dow == 1 || dow == 7;
    }

    static Calendar getCalendarStart(Calendar date, int year, int month) {
        date = (Calendar)date.clone();
        date.set(year, month, 1);
        while (date.get(7) != 1) {
            date.add(5, -1);
        }
        return date;
    }

    private class AnimationAdvisor
    implements IAnimationAdvisor {
        private int monthsToRoll = 0;
        private int yearsToRoll = 0;
        private int duration = -1;
        private int oldYear;
        private int oldMonth;
        private int newYear;
        private int newMonth;

        private AnimationAdvisor() {
        }

        @Override
        public void addMonthsToRoll(int count) {
            this.monthsToRoll += count;
            this.duration = -1;
        }

        @Override
        public void addYearsToRoll(int count) {
            this.yearsToRoll += count;
            this.duration = -1;
        }

        @Override
        public int getDuration() {
            if (this.duration < 0) {
                int steps = Math.abs(this.monthsToRoll) + Math.abs(this.yearsToRoll);
                this.duration = steps == 0 ? 0 : 200 / steps;
            }
            return this.duration;
        }

        @Override
        public IFigure getLayer() {
            return DatePicker.this.dateLayer;
        }

        @Override
        public int getMonthsToRoll() {
            return this.monthsToRoll;
        }

        @Override
        public int getNewMonth() {
            return this.newMonth;
        }

        @Override
        public int getNewYear() {
            return this.newYear;
        }

        @Override
        public int getOldMonth() {
            return this.oldMonth;
        }

        @Override
        public int getOldYear() {
            return this.oldYear;
        }

        @Override
        public IFigure getPanel() {
            return DatePicker.this.datePanel;
        }

        @Override
        public int getYearsToRoll() {
            return this.yearsToRoll;
        }

        @Override
        public void initNewDay(DayFigure figure) {
            DatePicker.this.updateDayFigure(figure, this.oldYear, this.oldMonth);
        }

        @Override
        public void initOldDay(DayFigure figure) {
            figure.setPreselected(false);
            figure.setSelected(DatePicker.isSameDay(figure.getDate(), DatePicker.this.getSelectedDate()));
            DatePicker.this.eventHandler.detach((IFigure)figure);
        }

        @Override
        public boolean isDone() {
            return this.monthsToRoll == 0 && this.yearsToRoll == 0;
        }

        @Override
        public void setEndMonth(int newYear, int newMonth) {
            this.newYear = newYear;
            this.newMonth = newMonth;
        }

        @Override
        public void setStartMonth(int oldYear, int oldMonth) {
            this.oldYear = oldYear;
            this.oldMonth = oldMonth;
        }

        @Override
        public void updateNewDay(DayFigure figure) {
            figure.setPreselected(false);
            figure.setSelected(DatePicker.isSameDay(figure.getDate(), DatePicker.this.getSelectedDate()));
            DatePicker.this.eventHandler.attach((IFigure)figure);
            DatePicker.this.updateDayFigure(figure, this.newYear, this.newMonth);
        }
    }

    private class DropdownDatePicker
    extends PopupDialog {
        public DropdownDatePicker(Shell parent) {
            super(parent, 8, true, false, false, false, false, null, null);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            DatePicker.this.createDatePicker(composite);
            DatePicker.this.datePicker.setLayoutData((Object)new org.eclipse.swt.layout.GridData(4, 4, true, true));
            DatePicker.this.initDatePicker();
            DatePicker.this.update();
            return composite;
        }

        public int open() {
            DatePicker.this.isPopupEditing = true;
            return super.open();
        }

        public boolean close() {
            DatePicker.this.isPopupEditing = false;
            boolean closed = super.close();
            if (closed) {
                DatePicker.this.datePicker = null;
            }
            return closed;
        }

        protected Point getInitialLocation(Point initialSize) {
            Control c = DatePicker.this.getControl();
            org.eclipse.swt.graphics.Rectangle r = c.getBounds();
            return c.toDisplay(0, r.height + 1);
        }
    }

    protected class EventHandler
    implements MouseListener,
    MouseMotionListener,
    Listener {
        private boolean dayPressed = false;
        private BaseFigure pretarget = null;
        private FigureCanvas canvas;
        private BaseFigure target = null;

        protected EventHandler() {
        }

        public void attach(IFigure figure) {
            figure.addMouseListener((MouseListener)this);
            figure.addMouseMotionListener((MouseMotionListener)this);
        }

        public void detach(IFigure figure) {
            figure.removeMouseListener((MouseListener)this);
            figure.removeMouseMotionListener((MouseMotionListener)this);
        }

        public void install(Control control) {
            control.addListener(4, (Listener)this);
            control.addListener(37, (Listener)this);
            control.addListener(1, (Listener)this);
        }

        public void uninstall(Control control) {
            control.removeListener(4, (Listener)this);
            control.removeListener(37, (Listener)this);
            control.removeListener(1, (Listener)this);
        }

        public void handleEvent(Event event) {
            if (event.type == 4) {
                this.dayPressed = false;
                if (this.target != null) {
                    BaseFigure eventTarget = this.target;
                    BaseFigure eventPreTarget = this.pretarget;
                    this.target.setPressed(false);
                    this.target = null;
                    DatePicker.this.selected(eventTarget, eventPreTarget);
                }
            } else if (event.type == 37) {
                if (event.count == 0) {
                    return;
                }
                DatePicker.this.rollMonth(event.count > 0 ? -1 : 1);
            } else if (event.type == 1) {
                this.handleKeyPress(event.keyCode, event.stateMask);
            }
        }

        private void handleKeyPress(int key, int mask) {
            if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000001)) {
                DatePicker.this.lastMonthSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000002)) {
                DatePicker.this.nextMonthSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000003)) {
                DatePicker.this.lastYearSelected(true);
            } else if (SWTUtils.matchKey((int)mask, (int)key, (int)0, (int)0x1000004)) {
                DatePicker.this.nextYearSelected(true);
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
            BaseFigure source = (BaseFigure)((Object)me.getSource());
            if (source instanceof HourFigure || source instanceof MinutesFigure) {
                this.startEditing(source);
            }
        }

        private void startEditing(final BaseFigure source) {
            this.canvas = DatePicker.this.getDatePicker();
            final Text editor = new Text((Composite)DatePicker.this.getDatePicker(), 2052);
            editor.setFont(source.getFont());
            editor.setText(source.getText());
            Rectangle bounds = source.getBounds();
            Viewport viewport = this.canvas.getViewport();
            int x = bounds.x - viewport.getClientArea().x;
            int y = bounds.y - viewport.getClientArea().y;
            Point size = editor.computeSize(-1, -1);
            editor.setBounds(x, y + (bounds.height - size.y) / 2, bounds.width, size.y);
            this.canvas.layout();
            editor.selectAll();
            editor.setFocus();
            final Listener mouseDownFilter = new Listener(){

                public void handleEvent(Event event) {
                    if (event.widget != editor) {
                        EventHandler.this.finishEditingTime(editor, source);
                    }
                }
            };
            editor.getDisplay().addFilter(3, mouseDownFilter);
            editor.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    editor.getDisplay().removeFilter(3, mouseDownFilter);
                }
            });
            editor.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13) {
                        EventHandler.this.finishEditingTime(editor, source);
                    }
                }
            });
            editor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        e.doit = false;
                        EventHandler.this.cancelEditingTime(editor);
                    }
                }
            });
        }

        private void cancelEditingTime(Text editor) {
            editor.dispose();
            this.canvas.layout();
        }

        private void finishEditingTime(Text editor, BaseFigure source) {
            String newValue = editor.getText().trim();
            String oldValue = source.getText().trim();
            if ("".equals(newValue) || newValue == null || newValue.equals(oldValue)) {
                this.disposeEditor(editor, source);
                if (!"12".equals(newValue)) {
                    return;
                }
            }
            int value = -1;
            try {
                value = Integer.parseInt(newValue);
                if (source instanceof HourFigure) {
                    DatePicker.this.changeHourOrMinutes(false, value, DatePicker.this.currentMinutes);
                }
                if (source instanceof MinutesFigure) {
                    DatePicker.this.changeHourOrMinutes(false, DatePicker.this.currentHour, value);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this.disposeEditor(editor, source);
        }

        private void disposeEditor(Text editor, BaseFigure source) {
            DatePicker.this.updateSelection();
            source.setBorder(null);
            editor.dispose();
            this.canvas.layout();
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            if (this.target == null) {
                BaseFigure source = (BaseFigure)((Object)me.getSource());
                if (source instanceof DayFigure && this.dayPressed) {
                    source.setPressed(true);
                    source.setPreselected(false);
                } else {
                    if (source == DatePicker.this.monthFigure || source == DatePicker.this.lastMonth || source == DatePicker.this.nextMonth) {
                        DatePicker.this.monthFigure.setPreselected(true);
                        DatePicker.this.lastMonth.getContent().setVisible(true);
                        DatePicker.this.nextMonth.getContent().setVisible(true);
                    } else if (source == DatePicker.this.yearFigure || source == DatePicker.this.lastYear || source == DatePicker.this.nextYear) {
                        DatePicker.this.yearFigure.setPreselected(true);
                        DatePicker.this.lastYear.getContent().setVisible(true);
                        DatePicker.this.nextYear.getContent().setVisible(true);
                    } else if (source == DatePicker.this.todayFigure) {
                        DatePicker.this.todayFigure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0));
                        DatePicker.this.todayFigure.setForegroundColor(ColorUtils.getColor((String)DatePicker.CANCEL));
                        return;
                    }
                    source.setPreselected(true);
                }
            }
        }

        public void mouseExited(MouseEvent me) {
            if (this.target == null) {
                BaseFigure source = (BaseFigure)((Object)me.getSource());
                if (source instanceof DayFigure) {
                    source.setPreselected(false);
                    if (this.dayPressed) {
                        source.setPressed(false);
                    }
                } else {
                    if (source == DatePicker.this.monthFigure || source == DatePicker.this.lastMonth || source == DatePicker.this.nextMonth) {
                        DatePicker.this.monthFigure.setPreselected(false);
                        DatePicker.this.lastMonth.getContent().setVisible(false);
                        DatePicker.this.nextMonth.getContent().setVisible(false);
                    } else if (source == DatePicker.this.yearFigure || source == DatePicker.this.lastYear || source == DatePicker.this.nextYear) {
                        DatePicker.this.yearFigure.setPreselected(false);
                        DatePicker.this.lastYear.getContent().setVisible(false);
                        DatePicker.this.nextYear.getContent().setVisible(false);
                    } else if (source == DatePicker.this.todayFigure) {
                        DatePicker.this.todayFigure.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0));
                        DatePicker.this.todayFigure.setForegroundColor(ColorUtils.getColor((String)DatePicker.TEXT));
                        return;
                    }
                    source.setPreselected(false);
                }
            }
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            BaseFigure source = (BaseFigure)((Object)me.getSource());
            if (source != DatePicker.this.todayFigure) {
                source.setPressed(true);
                source.setPreselected(false);
            }
            if (source instanceof DayFigure) {
                this.dayPressed = true;
            } else {
                this.target = source;
            }
            if (source instanceof HourFigure || source instanceof MinutesFigure) {
                this.startEditing(source);
            }
        }

        public void mouseReleased(MouseEvent me) {
            BaseFigure source = (BaseFigure)((Object)me.getSource());
            source.setPressed(false);
            if (source instanceof DayFigure) {
                if (this.dayPressed) {
                    DatePicker.this.daySelected((DayFigure)((Object)me.getSource()));
                }
                source.setPreselected(true);
            } else if (source instanceof HourFigure || source instanceof MinutesFigure) {
                this.pretarget = source;
            } else if (!source.isSelected() && source != DatePicker.this.todayFigure) {
                source.setPreselected(true);
            }
        }
    }

    private class MonthAction
    extends Action {
        private int month;

        public MonthAction(int month) {
            super(MONTHS[month]);
            this.month = month;
        }

        public void run() {
            DatePicker.this.monthSelected(this.month);
        }
    }

    private class YearAction
    extends Action {
        private int year;

        private YearAction() {
        }

        public void setYear(int year) {
            this.year = year;
            this.setText("" + year);
        }

        public int getYear() {
            return this.year;
        }

        public void run() {
            DatePicker.this.yearSelected(this.year);
        }
    }
}

