/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.mindmap.filtering.FilterSection;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.IFilterViewerContainer;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;
import org.xmind.ui.internal.mindmap.filtering.Messages;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;

public class FilterViewer
implements IPropertyFilterListener {
    private static final int PAGE_NO_CONTENT = 0;
    private static final int PAGE_CONTENT = 1;
    private IGraphicalViewer contributingViewer;
    private WidgetFactory factory;
    private PageBook pageBook;
    private Composite emptyPage;
    private Composite contentPage;
    private Control showAllControl;
    private ScrolledForm contentForm;
    private boolean showToolBar;
    private List<FilterSection> sections;
    private IFilterViewerContainer container;
    private FilterService filterService;
    private boolean schedulingReflow = false;

    public FilterViewer(boolean showToolBar) {
        this.showToolBar = showToolBar;
    }

    public IFilterViewerContainer getContainer() {
        return this.container;
    }

    public void setContainer(IFilterViewerContainer container) {
        this.container = container;
    }

    public void addSection(FilterSection section) {
        if (this.sections == null) {
            this.sections = new ArrayList<FilterSection>();
        }
        this.sections.add(section);
        section.setContainer(this);
    }

    public void createControl(Composite parent) {
        this.factory = new WidgetFactory(parent.getDisplay());
        this.factory.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.pageBook = new PageBook(parent, 0);
        this.pageBook.setBackground(parent.getDisplay().getSystemColor(25));
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.pageBook.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilterViewer.this.handleDispose();
            }
        });
        this.createEmptyPage((Composite)this.pageBook);
        this.pageBook.showPage((Control)this.emptyPage);
    }

    private void createEmptyPage(Composite parent) {
        this.emptyPage = new Composite(parent, 0);
        this.emptyPage.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.emptyPage.setLayout((Layout)layout);
        Label text = new Label(this.emptyPage, 64);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.setBackground(this.emptyPage.getBackground());
        text.setText(Messages.NoContent_message);
        final Color color = new Color((Device)parent.getDisplay(), 64, 64, 64);
        text.setForeground(color);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                color.dispose();
            }
        });
    }

    private void createContentPage(Composite parent) {
        this.contentPage = this.factory.createComposite(parent, 524288);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.contentPage.setLayout((Layout)layout);
        if (this.showToolBar) {
            this.createToolBar(this.contentPage);
        }
        this.contentForm = this.factory.createScrolledForm(this.contentPage);
        this.contentForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite contentBody = this.contentForm.getBody();
        TableWrapLayout contentLayout = new TableWrapLayout();
        contentLayout.verticalSpacing = 15;
        contentBody.setLayout((Layout)contentLayout);
        if (this.sections != null) {
            for (FilterSection section : this.sections) {
                section.createSectionControl(contentBody, this.factory, this.contentForm);
                section.getControl().setLayoutData((Object)new TableWrapData(256, 16));
            }
        }
        this.updateControls();
    }

    private Control createToolBar(Composite parent) {
        Composite bar = this.factory.createComposite(parent, 524288);
        TableWrapLayout layout = new TableWrapLayout();
        layout.horizontalSpacing = 10;
        layout.numColumns = 1;
        bar.setLayout((Layout)layout);
        this.showAllControl = this.createShowAllControl(bar);
        this.showAllControl.setLayoutData((Object)new TableWrapData());
        return bar;
    }

    protected Control createShowAllControl(Composite parent) {
        String text = Messages.ShowAll_text;
        Hyperlink showAllHyperlink = this.factory.createHyperlink(parent, text, 0);
        showAllHyperlink.setToolTipText(Messages.ShowAll_toolTip);
        showAllHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterViewer.this.handleShowAll();
            }
        });
        return showAllHyperlink;
    }

    public void handleShowAll() {
        if (this.sections == null) {
            return;
        }
        for (FilterSection section : this.sections) {
            section.removeFilter();
        }
    }

    protected void handleDispose() {
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.pageBook = null;
    }

    public Control getControl() {
        return this.pageBook;
    }

    public IGraphicalViewer getContributingViewer() {
        return this.contributingViewer;
    }

    public void setContributingViewer(IGraphicalViewer contributedViewer) {
        IGraphicalViewer oldViewer = this.contributingViewer;
        this.contributingViewer = contributedViewer;
        this.contributingViewerChanged(oldViewer, contributedViewer);
    }

    private void contributingViewerChanged(IGraphicalViewer oldViewer, IGraphicalViewer newViewer) {
        if (this.sections != null) {
            for (FilterSection section : this.sections) {
                section.setContributingViewer(newViewer);
            }
        }
        this.showPage(newViewer != null ? 1 : 0);
        if (this.schedulingReflow) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                FilterViewer.this.setFilterService(FilterViewer.this.findFilterService(FilterViewer.this.getContributingViewer()));
                if (FilterViewer.this.contentPage != null && !FilterViewer.this.contentPage.isDisposed()) {
                    FilterViewer.this.contentPage.layout();
                }
                if (FilterViewer.this.pageBook != null && FilterViewer.this.pageBook.isDisposed()) {
                    FilterViewer.this.reflow();
                }
                FilterViewer.this.schedulingReflow = false;
            }
        });
        this.schedulingReflow = true;
    }

    private void setFilterService(FilterService filterService) {
        if (this.filterService != null) {
            this.filterService.removeFilterListener(this);
        }
        this.filterService = filterService;
        if (this.filterService != null) {
            this.filterService.addFilterListener(this);
        }
        this.updateControls();
    }

    private FilterService findFilterService(IGraphicalViewer viewer) {
        if (viewer == null) {
            return null;
        }
        return (FilterService)viewer.getService(FilterService.class);
    }

    private void updateControls() {
        boolean hasFilters = this.hasFilter();
        if (this.showAllControl != null && !this.showAllControl.isDisposed() && this.showAllControl != null) {
            this.showAllControl.setEnabled(hasFilters);
            Display display = this.showAllControl.getDisplay();
            this.showAllControl.setForeground(hasFilters ? display.getSystemColor(24) : display.getSystemColor(15));
        }
        if (this.container != null) {
            this.container.updateActions(hasFilters);
        }
    }

    public void reflow() {
        if (this.contentForm != null && !this.contentForm.isDisposed()) {
            this.contentForm.reflow(true);
        }
    }

    private boolean hasFilter() {
        if (this.sections != null && !this.sections.isEmpty()) {
            for (FilterSection section : this.sections) {
                if (!section.hasFilter()) continue;
                return true;
            }
        }
        return false;
    }

    private void showPage(int pageId) {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        if (pageId == 1) {
            if (this.contentPage == null) {
                this.createContentPage((Composite)this.pageBook);
                if (this.sections != null) {
                    for (FilterSection section : this.sections) {
                        section.refresh();
                    }
                }
            }
            this.pageBook.showPage((Control)this.contentPage);
        } else if (pageId == 0) {
            this.pageBook.showPage((Control)this.emptyPage);
        }
    }

    public void filterChanged(PropertyFilter filter) {
        this.updateControls();
    }
}

