/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.util.FileUtils;

public class WorkspaceSession {
    private File tempRoot;
    private File stampFile;
    private RandomAccessFile stampFileWrapper;
    private FileLock stampFileLock;

    public WorkspaceSession(File tempRoot, File stampFile, RandomAccessFile stampFileWrapper, FileLock stampFileLock) {
        this.tempRoot = tempRoot;
        this.stampFile = stampFile;
        this.stampFileWrapper = stampFileWrapper;
        this.stampFileLock = stampFileLock;
    }

    public static WorkspaceSession openSessionIn(File tempRoot) throws CoreException {
        RandomAccessFile stampFileWrapper;
        File stampFile;
        if (!tempRoot.isDirectory() && !tempRoot.mkdirs()) {
            throw new CoreException((IStatus)new Status(4, "org.xmind.core.runtime", "Failed to create temporary directory at " + tempRoot.getAbsolutePath()));
        }
        try {
            stampFile = File.createTempFile("xmind", ".core", tempRoot);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.xmind.core.runtime", "Failed to create workspace stamp file in " + tempRoot.getAbsolutePath(), (Throwable)e));
        }
        try {
            stampFileWrapper = new RandomAccessFile(stampFile, "rw");
        }
        catch (FileNotFoundException e) {
            stampFile.delete();
            throw new CoreException((IStatus)new Status(4, "org.xmind.core.runtime", "Failed to find created workspace stamp file at " + stampFile.getAbsolutePath(), (Throwable)e));
        }
        FileLock stampFileLock = null;
        try {
            int err = 0;
            while (err < 10) {
                try {
                    stampFileLock = stampFileWrapper.getChannel().tryLock();
                }
                catch (IOException iOException) {}
                if (stampFileLock == null) {
                    Thread.sleep(1L);
                    ++err;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (stampFileLock == null) {
            try {
                stampFileWrapper.close();
            }
            catch (IOException iOException) {}
            stampFile.delete();
            throw new CoreException((IStatus)new Status(4, "org.xmind.core.runtime", "Failed to lock workspace stamp file. Please make sure you have r/w permission at " + tempRoot.getAbsolutePath()));
        }
        return new WorkspaceSession(tempRoot, stampFile, stampFileWrapper, stampFileLock);
    }

    public void close() {
        this.deleteStampFile();
        if (!this.hasOtherSession()) {
            this.clearTempRoot();
        }
    }

    private void deleteStampFile() {
        if (this.stampFileLock != null) {
            try {
                this.stampFileLock.release();
            }
            catch (IOException iOException) {}
            this.stampFileLock = null;
        }
        if (this.stampFileWrapper != null) {
            try {
                this.stampFileWrapper.close();
            }
            catch (IOException iOException) {}
            this.stampFileWrapper = null;
        }
        if (this.stampFile != null) {
            this.stampFile.delete();
            this.stampFile = null;
        }
    }

    private boolean hasOtherSession() {
        if (!this.tempRoot.exists()) {
            return false;
        }
        String[] stampFileNames = this.tempRoot.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".core");
            }
        });
        if (stampFileNames != null && stampFileNames.length > 0) {
            int i = 0;
            while (i < stampFileNames.length) {
                File otherStampFile = new File(this.tempRoot, stampFileNames[i]);
                if (this.isLocked(otherStampFile)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLocked(File file) {
        try {
            RandomAccessFile s = new RandomAccessFile(file, "rw");
            try {
                FileLock l = s.getChannel().tryLock();
                if (l == null) {
                    return true;
                }
                try {
                    l.release();
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            finally {
                s.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void clearTempRoot() {
        FileUtils.delete((File)this.tempRoot);
    }
}

