/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.IComment;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.dom.CommentManagerImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentImpl
implements IComment,
ICoreEventSource {
    private final WorkbookImpl ownerWorkbook;
    private final Element implementation;
    private CommentManagerImpl ownedCommentManager;

    public CommentImpl(WorkbookImpl ownerWorkbook, CommentManagerImpl ownedCommentManager, Element implementation) {
        this.ownerWorkbook = ownerWorkbook;
        this.ownedCommentManager = ownedCommentManager;
        this.implementation = implementation;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.implementation);
        }
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.getCoreEventSupport());
        }
        return null;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public int compareTo(IComment that) {
        return (int)(that.getTime() - this.getTime());
    }

    @Override
    public String getObjectId() {
        return DOMUtils.getAttribute(this.implementation, "object-id");
    }

    @Override
    public String getAuthor() {
        return DOMUtils.getAttribute(this.implementation, "author");
    }

    @Override
    public long getTime() {
        return NumberUtils.safeParseLong(DOMUtils.getAttribute(this.implementation, "time"), 0L);
    }

    @Override
    public String getContent() {
        return DOMUtils.getTextContentByTag(this.implementation, "content");
    }

    @Override
    public void setContent(String content) {
        String oldContent = this.getContent();
        if (content == oldContent || content != null && content.equals(oldContent)) {
            return;
        }
        DOMUtils.setText(this.implementation, "content", content);
        this.getCoreEventSupport().dispatchValueChange(this, "commentContent", oldContent, content);
        this.updateModificationInfo();
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    protected void updateModificationInfo() {
        if (this.ownedCommentManager != null) {
            this.ownedCommentManager.updateModificationInfo();
        }
    }
}

