/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.meggy.Messages;
import org.xmind.ui.internal.meggy.ThemeDescriptor;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class ThemeExtractor {
    private static final int WEIGHT_BASE = 1;
    private static final int WEIGHT_USER = 2;
    private static int INDEX = 1;

    private ThemeExtractor() {
        throw new AssertionError();
    }

    public static IStyle extractThemeFrom(IMindMap mindmap) throws IOException {
        Assert.isLegal((mindmap != null ? 1 : 0) != 0);
        ThemeDescriptor themeDescriptor = new ThemeDescriptor();
        ThemeExtractor.extractThemeContents(themeDescriptor, mindmap);
        if (themeDescriptor.isEmpty()) {
            return null;
        }
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet userThemeSheet = resourceManager.getUserThemeSheet();
        IStyle newTheme = themeDescriptor.createTheme(userThemeSheet);
        if (newTheme != null) {
            newTheme.setName(NLS.bind((String)Messages.Theme_name, (Object)INDEX));
            ++INDEX;
        }
        return newTheme;
    }

    private static void extractThemeContents(ThemeDescriptor themeDescriptor, IMindMap mindmap) throws IOException {
        ThemeExtractor.recordStyle(themeDescriptor, (IStyled)mindmap.getSheet(), mindmap, 2);
        ThemeExtractor.recordTopic(themeDescriptor, mindmap.getCentralTopic(), mindmap);
        for (IRelationship r : mindmap.getSheet().getRelationships()) {
            ThemeExtractor.recordStyle(themeDescriptor, (IStyled)r, mindmap, 2);
        }
        ThemeExtractor.recordOldTheme(themeDescriptor, mindmap.getSheet().getTheme(), mindmap);
    }

    private static void recordStyle(ThemeDescriptor themeDescriptor, IStyled styleOwner, IMindMap mindmap, int weight) throws IOException {
        String family = MindMapUtils.getFamily((IStyled)styleOwner, (IMindMap)mindmap);
        IStyle sourceStyle = ThemeExtractor.getStyle(styleOwner);
        if (sourceStyle == null) {
            return;
        }
        String type = styleOwner.getStyleType();
        ThemeExtractor.recordStyle(themeDescriptor, sourceStyle, family, type, weight);
    }

    private static IStyle getStyle(IStyled styleOwner) {
        String styleId = styleOwner.getStyleId();
        if (styleId == null) {
            return null;
        }
        if (styleOwner instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)styleOwner).getOwnedWorkbook().getStyleSheet().findStyle(styleId);
        }
        return null;
    }

    private static void recordStyle(ThemeDescriptor themeDescriptor, IStyle sourceStyle, String family, String type, int weight) throws IOException {
        if (sourceStyle == null || family == null || type == null) {
            return;
        }
        themeDescriptor.add(sourceStyle, family, type, weight);
    }

    private static void recordTopic(ThemeDescriptor themeDescriptor, ITopic topic, IMindMap mindmap) throws IOException {
        ThemeExtractor.recordStyle(themeDescriptor, (IStyled)topic, mindmap, 2);
        for (ITopic child : topic.getAllChildren()) {
            ThemeExtractor.recordTopic(themeDescriptor, child, mindmap);
        }
        for (IBoundary b : topic.getBoundaries()) {
            ThemeExtractor.recordStyle(themeDescriptor, (IStyled)b, mindmap, 2);
        }
        for (ISummary s : topic.getSummaries()) {
            ThemeExtractor.recordStyle(themeDescriptor, (IStyled)s, mindmap, 2);
        }
    }

    private static void recordOldTheme(ThemeDescriptor themeDescriptor, IStyle oldTheme, IMindMap mindmap) throws IOException {
        if (oldTheme == null) {
            return;
        }
        IStyleSheet styleSheet = mindmap.getSheet().getOwnedWorkbook().getStyleSheet();
        Iterator dsIt = oldTheme.defaultStyles();
        while (dsIt.hasNext()) {
            IStyle style;
            Property ds = (Property)dsIt.next();
            String family = ds.key;
            String styleId = ds.value;
            if (styleId == null || (style = styleSheet.findStyle(styleId)) == null) continue;
            themeDescriptor.add(style, family, style.getType(), 1);
        }
    }
}

