/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.GEF;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.Messages;
import org.xmind.ui.internal.spreadsheet.ModifyColumnOrderCommand;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.ColumnInsertion;
import org.xmind.ui.internal.spreadsheet.structures.ColumnOrder;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.util.MindMapUtils;

public class ColumnMoveTool
extends DummyMoveTool {
    private IBranchPart branch = null;
    private ColumnHead sourceColHead = null;

    protected void start() {
        this.branch = (IBranchPart)super.getSource();
        this.sourceColHead = (ColumnHead)MindMapUtils.getCache((IPart)this.getSource(), (String)"org.xmind.ui.spreadsheet.cache.moveSourceColumnHead");
        Assert.isNotNull((Object)this.sourceColHead);
        super.start();
    }

    protected void end() {
        IInsertion insertion = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        if (insertion != null) {
            insertion.pullOut();
            MindMapUtils.flushCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        }
        MindMapUtils.flushCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.moveSourceColumnHead");
        super.end();
    }

    protected IFigure createDummy() {
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            RotatableWrapLabel fig = new RotatableWrapLabel(this.sourceColHead.toString(), 0);
            layer.add((IFigure)fig);
            fig.setFont(this.sourceColHead.getFont());
            fig.setSize(fig.getPreferredSize());
            fig.setLocation(this.getStartingPosition().getTranslated(fig.getSize().scale(0.5).negate()));
            return fig;
        }
        return null;
    }

    protected void onMoving(Point currentPos, MouseDragEvent me) {
        super.onMoving(currentPos, me);
        IStructure structure = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
        if (structure instanceof SpreadsheetStructure) {
            int index = ((SpreadsheetStructure)structure).calcColumnInsertionIndex(this.branch, currentPos);
            this.installInsertion(index);
        }
    }

    private void installInsertion(int index) {
        IInsertion oldInsertion = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        if (oldInsertion == null || oldInsertion.getIndex() != index) {
            if (oldInsertion != null) {
                oldInsertion.pullOut();
            }
            ColumnInsertion newInsertion = new ColumnInsertion(this.branch, index, this.sourceColHead.getPrefSize());
            newInsertion.pushIn();
        }
    }

    protected Request createRequest() {
        IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.branch, (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        if (ins != null) {
            int insIndex = ins.getIndex();
            IStructure structure = this.branch.getBranchPolicy().getStructure((IGraphicalPart)this.branch);
            if (structure instanceof SpreadsheetStructure) {
                Chart chart = ((SpreadsheetStructure)structure).getChart(this.branch);
                List<Column> columns = chart.getColumns();
                ColumnOrder newOrder = new ColumnOrder();
                int i = 0;
                while (i < columns.size()) {
                    Column col;
                    if (i == insIndex) {
                        newOrder.addColumnHead(this.sourceColHead);
                    }
                    if (!this.sourceColHead.equals((col = columns.get(i)).getHead())) {
                        newOrder.addColumnHead(col.getHead());
                    }
                    ++i;
                }
                ModifyColumnOrderCommand command = new ModifyColumnOrderCommand(chart.getTitle().getTopic(), newOrder);
                ICommandStack cs = this.getDomain().getCommandStack();
                if (cs != null) {
                    command.setLabel(Messages.Command_MoveColumn);
                    cs.execute((Command)command);
                }
            }
        }
        return null;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.HAND;
    }
}

