/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.xmind.core.IFileEntry;
import org.xmind.core.ISheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.gallery.FrameDecorator;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryPartFactory;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.ImageFormat;

public class WallpaperDialog
extends PopupDialog
implements IOpenListener {
    private static final String LOCAL_WALLPAPER_DIALOG_PATH = "org.xmind.ui.localWallpaperDialogPath";
    private static final Dimension FRAME_IMAGE_SIZE = new Dimension(64, 64);
    private static String WallpapersPath = null;
    private static String PatternPath = null;
    private Control initLocationControl;
    private static IGraphicalViewer mindMapViewer;
    private GalleryViewer patternViewer;
    private GalleryViewer paperViewer;
    private Map<Object, Image> wallpaperPreviewImages;
    private Job patternLoader;
    private Job imageLoader;
    private List<String> allPatternImageFiles;
    private List<String> loadedPatternImageFiles;
    private List<String> allImageFiles;
    private List<String> loadedImageFiles;
    private String selectedWallpaperPath;

    public WallpaperDialog(Shell parent, Control initLocationControl) {
        super(parent, 16, true, true, true, false, false, null, null);
        this.initLocationControl = initLocationControl;
        initLocationControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WallpaperDialog.this.releaseWallpaperPreviewImages();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createPatternArea(composite);
        this.createWallpaperArea(composite);
        return composite;
    }

    private void createPatternArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginLeft = 5;
        topLayout.marginRight = 0;
        topLayout.marginTop = 0;
        topLayout.marginBottom = 1;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(top, 0);
        label.setText(PropertyMessages.PatternCategory_title);
        this.patternViewer = new GalleryViewer();
        Properties properties = this.patternViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.FALSE);
        this.patternViewer.setPartFactory((IPartFactory)new WallpaperPartFactory());
        this.patternViewer.setLabelProvider((IBaseLabelProvider)new WallpaperLabelProvider());
        this.patternViewer.addOpenListener((IOpenListener)this);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        this.patternViewer.setEditDomain(editDomain);
        this.patternViewer.createControl(parent);
        GridData galleryData = new GridData(4, 4, true, true);
        galleryData.widthHint = 360;
        galleryData.heightHint = 300;
        this.patternViewer.getControl().setLayoutData((Object)galleryData);
        final Display display = parent.getDisplay();
        this.patternViewer.getControl().setBackground(display.getSystemColor(25));
        if (this.allPatternImageFiles != null && this.loadedPatternImageFiles != null && this.loadedPatternImageFiles.containsAll(this.allPatternImageFiles)) {
            this.patternViewer.setInput((Object)this.loadedPatternImageFiles.toArray());
        } else {
            this.patternViewer.setInput((Object)new Object[0]);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WallpaperDialog.this.patternViewer.getControl() != null && !WallpaperDialog.this.patternViewer.getControl().isDisposed()) {
                        WallpaperDialog.this.startLoadingPatternImages(display);
                    }
                }
            });
        }
        Composite bottom = new Composite(parent, 0);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.marginWidth = 0;
        bottomLayout.marginHeight = 0;
        bottomLayout.marginBottom = 10;
        bottom.setLayout((Layout)bottomLayout);
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createWallpaperArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginLeft = 5;
        topLayout.marginRight = 0;
        topLayout.marginTop = 0;
        topLayout.marginBottom = 1;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(top, 0);
        label.setText(PropertyMessages.WallpaperCategory_title);
        this.paperViewer = new GalleryViewer();
        Properties properties = this.paperViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.FALSE);
        this.paperViewer.setPartFactory((IPartFactory)new WallpaperPartFactory());
        this.paperViewer.setLabelProvider((IBaseLabelProvider)new WallpaperLabelProvider());
        this.paperViewer.addOpenListener((IOpenListener)this);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        this.paperViewer.setEditDomain(editDomain);
        this.paperViewer.createControl(parent);
        GridData galleryData = new GridData(4, 4, true, true);
        galleryData.widthHint = 360;
        galleryData.heightHint = 300;
        this.paperViewer.getControl().setLayoutData((Object)galleryData);
        final Display display = parent.getDisplay();
        this.paperViewer.getControl().setBackground(display.getSystemColor(25));
        if (this.allImageFiles != null && this.loadedImageFiles != null && this.loadedImageFiles.containsAll(this.allImageFiles)) {
            this.paperViewer.setInput((Object)this.loadedImageFiles.toArray());
        } else {
            this.paperViewer.setInput((Object)new Object[0]);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WallpaperDialog.this.paperViewer.getControl() != null && !WallpaperDialog.this.paperViewer.getControl().isDisposed()) {
                        WallpaperDialog.this.startLoadingImages(display);
                    }
                }
            });
        }
        Composite bottom = new Composite(parent, 0);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.marginWidth = 0;
        bottomLayout.marginHeight = 0;
        bottom.setLayout((Layout)bottomLayout);
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
        Button chooseFromLocalButton = new Button(bottom, 8);
        chooseFromLocalButton.setText(PropertyMessages.LocalImage_text);
        chooseFromLocalButton.setLayoutData((Object)new GridData(2, 2, true, false));
        chooseFromLocalButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WallpaperDialog.this.openLocalImageFileDialog();
                Shell shell = WallpaperDialog.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
                WallpaperDialog.this.close();
            }
        });
    }

    private void startLoadingImages(final Display display) {
        if (this.imageLoader != null) {
            this.imageLoader.cancel();
            this.imageLoader = null;
        }
        this.imageLoader = new Job(PropertyMessages.LoadWallpapers_jobName){
            private Runnable refreshJob;
            {
                super($anonymous0);
                this.refreshJob = null;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (WallpaperDialog.this.allImageFiles == null) {
                    this.collectImageFiles(WallpaperDialog.getWallpapersPath());
                    if (WallpaperDialog.this.allImageFiles == null) {
                        WallpaperDialog.this.allImageFiles = Collections.emptyList();
                    }
                }
                if (WallpaperDialog.this.allImageFiles.isEmpty()) {
                    if (WallpaperDialog.this.loadedImageFiles == null || !WallpaperDialog.this.loadedImageFiles.isEmpty()) {
                        WallpaperDialog.this.loadedImageFiles = Collections.emptyList();
                    }
                    this.refreshViewer(display);
                } else if (WallpaperDialog.this.loadedImageFiles != null && WallpaperDialog.this.loadedImageFiles.containsAll(WallpaperDialog.this.allImageFiles)) {
                    this.refreshViewer(display);
                } else {
                    monitor.beginTask(null, WallpaperDialog.this.allImageFiles.size());
                    if (WallpaperDialog.this.loadedImageFiles == null) {
                        WallpaperDialog.this.loadedImageFiles = new ArrayList(WallpaperDialog.this.allImageFiles.size());
                    }
                    long lastRefresh = System.currentTimeMillis();
                    Object[] objectArray = WallpaperDialog.this.allImageFiles.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (monitor.isCanceled()) break;
                        if (!WallpaperDialog.this.loadedImageFiles.contains(o)) {
                            String path = (String)o;
                            monitor.subTask(new File(path).getName());
                            Image image = WallpaperDialog.this.getWallpaperPreviewImage(display, path);
                            if (image != null) {
                                WallpaperDialog.this.loadedImageFiles.add(path);
                            } else {
                                WallpaperDialog.this.allImageFiles.remove(path);
                            }
                        }
                        monitor.worked(1);
                        if (System.currentTimeMillis() - lastRefresh > 50L) {
                            this.refreshViewer(display);
                            lastRefresh = System.currentTimeMillis();
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        ++n2;
                    }
                }
                if (!monitor.isCanceled()) {
                    monitor.done();
                }
                WallpaperDialog.this.imageLoader = null;
                this.refreshViewer(display);
                return new Status(0, "org.xmind.ui.mindmap", 0, "Wallpaper images loaded.", null);
            }

            private void refreshViewer(Display display2) {
                if (this.refreshJob != null) {
                    return;
                }
                this.refreshJob = new Runnable(){

                    @Override
                    public void run() {
                        if (WallpaperDialog.this.paperViewer != null && WallpaperDialog.this.paperViewer.getControl() != null && !WallpaperDialog.this.paperViewer.getControl().isDisposed() && WallpaperDialog.this.loadedImageFiles != null) {
                            WallpaperDialog.this.paperViewer.setInput((Object)WallpaperDialog.this.loadedImageFiles.toArray());
                            WallpaperDialog.this.paperViewer.getControl().getParent().layout();
                        }
                        refreshJob = null;
                    }
                };
                display2.asyncExec(this.refreshJob);
            }

            private void collectImageFiles(String path) {
                String ext;
                ImageFormat format;
                File file = new File(path);
                if (file.isDirectory() && path.equals(WallpaperDialog.getWallpapersPath())) {
                    String[] stringArray = file.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        this.collectImageFiles(new File(file, name).getAbsolutePath());
                        ++n2;
                    }
                } else if (file.isFile() && (format = ImageFormat.findByExtension((String)(ext = FileUtils.getExtension((String)path)), null)) != null) {
                    if (WallpaperDialog.this.allImageFiles == null) {
                        WallpaperDialog.this.allImageFiles = new ArrayList();
                    }
                    WallpaperDialog.this.allImageFiles.add(path);
                }
            }
        };
        this.imageLoader.schedule();
    }

    private void startLoadingPatternImages(final Display display) {
        if (this.patternLoader != null) {
            this.patternLoader.cancel();
            this.patternLoader = null;
        }
        this.patternLoader = new Job(PropertyMessages.LoadWallpapers_jobName){
            private Runnable refreshJob;
            {
                super($anonymous0);
                this.refreshJob = null;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (WallpaperDialog.this.allPatternImageFiles == null) {
                    this.collectImageFiles(WallpaperDialog.getPatternsPath());
                    if (WallpaperDialog.this.allPatternImageFiles == null) {
                        WallpaperDialog.this.allPatternImageFiles = Collections.emptyList();
                    }
                }
                if (WallpaperDialog.this.allPatternImageFiles.isEmpty()) {
                    if (WallpaperDialog.this.loadedPatternImageFiles == null || !WallpaperDialog.this.loadedPatternImageFiles.isEmpty()) {
                        WallpaperDialog.this.loadedPatternImageFiles = Collections.emptyList();
                    }
                    this.refreshViewer(display);
                } else if (WallpaperDialog.this.loadedPatternImageFiles != null && WallpaperDialog.this.loadedPatternImageFiles.containsAll(WallpaperDialog.this.allPatternImageFiles)) {
                    this.refreshViewer(display);
                } else {
                    monitor.beginTask(null, WallpaperDialog.this.allPatternImageFiles.size());
                    if (WallpaperDialog.this.loadedPatternImageFiles == null) {
                        WallpaperDialog.this.loadedPatternImageFiles = new ArrayList(WallpaperDialog.this.allPatternImageFiles.size());
                    }
                    long lastRefresh = System.currentTimeMillis();
                    Object[] objectArray = WallpaperDialog.this.allPatternImageFiles.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (monitor.isCanceled()) break;
                        if (!WallpaperDialog.this.loadedPatternImageFiles.contains(o)) {
                            String path = (String)o;
                            monitor.subTask(new File(path).getName());
                            Image image = WallpaperDialog.this.getWallpaperPreviewImage(display, path);
                            if (image != null) {
                                WallpaperDialog.this.loadedPatternImageFiles.add(path);
                            } else {
                                WallpaperDialog.this.allPatternImageFiles.remove(path);
                            }
                        }
                        monitor.worked(1);
                        if (System.currentTimeMillis() - lastRefresh > 50L) {
                            this.refreshViewer(display);
                            lastRefresh = System.currentTimeMillis();
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        ++n2;
                    }
                }
                if (!monitor.isCanceled()) {
                    monitor.done();
                }
                WallpaperDialog.this.patternLoader = null;
                this.refreshViewer(display);
                return new Status(0, "org.xmind.ui.mindmap", 0, "Wallpaper images loaded.", null);
            }

            private void refreshViewer(Display display2) {
                if (this.refreshJob != null) {
                    return;
                }
                this.refreshJob = new Runnable(){

                    @Override
                    public void run() {
                        if (WallpaperDialog.this.patternViewer != null && WallpaperDialog.this.patternViewer.getControl() != null && !WallpaperDialog.this.patternViewer.getControl().isDisposed() && WallpaperDialog.this.loadedPatternImageFiles != null) {
                            WallpaperDialog.this.patternViewer.setInput((Object)WallpaperDialog.this.loadedPatternImageFiles.toArray());
                            WallpaperDialog.this.patternViewer.getControl().getParent().layout();
                        }
                        refreshJob = null;
                    }
                };
                display2.asyncExec(this.refreshJob);
            }

            private void collectImageFiles(String path) {
                String ext;
                ImageFormat format;
                File file = new File(path);
                if (file.isDirectory() && path.equals(WallpaperDialog.getPatternsPath())) {
                    String[] stringArray = file.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        this.collectImageFiles(new File(file, name).getAbsolutePath());
                        ++n2;
                    }
                } else if (file.isFile() && (format = ImageFormat.findByExtension((String)(ext = FileUtils.getExtension((String)path)), null)) != null) {
                    if (WallpaperDialog.this.allPatternImageFiles == null) {
                        WallpaperDialog.this.allPatternImageFiles = new ArrayList();
                    }
                    WallpaperDialog.this.allPatternImageFiles.add(path);
                }
            }
        };
        this.patternLoader.schedule();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WallpaperDialog.this.close();
                    }
                });
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WallpaperDialog.this.imageLoader != null) {
                    WallpaperDialog.this.imageLoader.cancel();
                    WallpaperDialog.this.imageLoader = null;
                }
                if (WallpaperDialog.this.patternLoader != null) {
                    WallpaperDialog.this.patternLoader.cancel();
                    WallpaperDialog.this.patternLoader = null;
                }
            }
        });
    }

    public void setMindMapViewer(IGraphicalViewer viewer) {
        mindMapViewer = viewer;
    }

    protected List getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        if (this.paperViewer != null) {
            list.add(this.paperViewer.getControl());
        }
        if (this.patternViewer != null) {
            list.add(this.patternViewer.getControl());
        }
        return list;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.initLocationControl != null && !this.initLocationControl.isDisposed()) {
            Point loc = this.initLocationControl.toDisplay(this.initLocationControl.getLocation());
            return new Point(loc.x, loc.y + this.initLocationControl.getBounds().height);
        }
        if (mindMapViewer != null) {
            return new Point(50, 50);
        }
        return super.getInitialLocation(initialSize);
    }

    protected IDialogSettings getDialogSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
    }

    public void open(OpenEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof String) {
            String path;
            this.selectedWallpaperPath = path = (String)o;
            Shell shell = this.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.close();
            }
            this.close();
            this.changeWallpaper(path);
        }
    }

    public String getSelectedWallpaperPath() {
        return this.selectedWallpaperPath;
    }

    private Image getWallpaperPreviewImage(Object element) {
        return this.getWallpaperPreviewImage(Display.getCurrent(), element);
    }

    private Image getWallpaperPreviewImage(Display display, Object element) {
        Image image = null;
        if (this.wallpaperPreviewImages != null) {
            image = this.wallpaperPreviewImages.get(element);
        }
        if (image == null) {
            if (element instanceof String) {
                Image filled;
                String path = (String)element;
                try {
                    image = new Image((Device)display, path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (SWTException sWTException) {
                }
                catch (SWTError sWTError) {}
                if (image != null && (filled = WallpaperDialog.createFilledImage(display, image, FRAME_IMAGE_SIZE)) != null) {
                    image.dispose();
                    image = filled;
                }
            }
            if (image != null) {
                this.cacheWallpaperPreviewImage(element, image);
            }
        }
        return image;
    }

    private void cacheWallpaperPreviewImage(Object element, Image image) {
        if (this.wallpaperPreviewImages == null) {
            this.wallpaperPreviewImages = new HashMap<Object, Image>();
        }
        this.wallpaperPreviewImages.put(element, image);
    }

    private void releaseWallpaperPreviewImages() {
        if (this.wallpaperPreviewImages != null) {
            for (Image image : this.wallpaperPreviewImages.values()) {
                image.dispose();
            }
            this.wallpaperPreviewImages = null;
        }
    }

    private void openLocalImageFileDialog() {
        FileDialog dialog = new FileDialog(this.getParentShell(), 4100);
        DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
        dialog.setText(PropertyMessages.WallpaperDialog_title);
        IDialogSettings settings = MindMapUIPlugin.getDefault().getDialogSettings();
        String filterPath = settings.get(LOCAL_WALLPAPER_DIALOG_PATH);
        if (filterPath == null || "".equals(filterPath) || !new File(filterPath).exists()) {
            filterPath = WallpaperDialog.getWallpapersPath();
        }
        dialog.setFilterPath(filterPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        this.selectedWallpaperPath = path;
        filterPath = new File(path).getParent();
        settings.put(LOCAL_WALLPAPER_DIALOG_PATH, filterPath);
        this.changeWallpaper(path);
    }

    private void changeWallpaper(String path) {
        if (mindMapViewer == null) {
            return;
        }
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ChangeWallpaperCount");
        Request request = new Request("modify_style").setViewer((IViewer)mindMapViewer);
        request.setParameter("commandLabel", (Object)CommandMessages.Command_ModifySheetBackgroundColor);
        request.setParameter("styleProperty.background", (Object)path);
        int value = this.isPattern(path) ? 10 : 100;
        request.setParameter("styleProperty.svg:opacity", (Object)String.valueOf((double)value * 1.0 / 100.0));
        request.setTargets(this.fillParts());
        mindMapViewer.getEditDomain().handleRequest(request);
    }

    private boolean isPattern(String path) {
        int index = Util.isWin32() ? path.lastIndexOf(92) : path.lastIndexOf(47);
        if (index < 7) {
            return false;
        }
        String category = path.substring(index - 7, index);
        return "pattern".equals(category);
    }

    private List<IPart> fillParts() {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        Object input = mindMapViewer.getInput();
        if (input instanceof IMindMap) {
            ISheet sheet = ((IMindMap)input).getSheet();
            IPart part = mindMapViewer.findPart((Object)sheet);
            parts.add(part);
        }
        return parts;
    }

    private static String getWallpapersPath() {
        if (WallpapersPath == null) {
            WallpapersPath = WallpaperDialog.createWallpapersPath("wallpaper");
        }
        return WallpapersPath;
    }

    private static String getPatternsPath() {
        if (PatternPath == null) {
            PatternPath = WallpaperDialog.createWallpapersPath("pattern");
        }
        return PatternPath;
    }

    private static String createWallpapersPath(String category) {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui"), (IPath)new Path("wallpaper/" + category), null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        String path = url.getFile();
        if ("".equals(path)) {
            path = new File(System.getProperty("user.home"), "Pictures").getAbsolutePath();
        }
        return path;
    }

    private static Image createFilledImage(Display display, Image src, Dimension size) {
        int y;
        int x;
        int height = size.height;
        int width = size.width;
        ImageData srcData = src.getImageData();
        int srcWidth = srcData.width;
        int srcHeight = srcData.height;
        if (srcWidth == width && srcHeight == height) {
            return null;
        }
        ImageData destData = new ImageData(width, height, srcData.depth, srcData.palette);
        destData.type = srcData.type;
        destData.transparentPixel = srcData.transparentPixel;
        destData.alpha = srcData.alpha;
        if (srcData.transparentPixel != -1) {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setPixel(x, y, srcData.transparentPixel);
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setAlpha(x, y, 0);
                    ++y;
                }
                ++x;
            }
        }
        int[] pixels = new int[srcWidth];
        byte[] alphas = null;
        int startX = 0;
        while (startX < width) {
            int length = Math.min(srcWidth, width - startX);
            if (length > 0) {
                int startY = 0;
                while (startY < height) {
                    int y2 = 0;
                    while (y2 < srcHeight && startY + y2 < height) {
                        int i;
                        srcData.getPixels(0, y2, srcWidth, pixels, 0);
                        destData.setPixels(startX, startY + y2, length, pixels, 0);
                        if (srcData.alpha == -1 && srcData.alphaData != null) {
                            if (alphas == null) {
                                alphas = new byte[srcWidth];
                            }
                            srcData.getAlphas(0, y2, srcWidth, alphas, 0);
                        } else if (srcData.alpha != -1 && alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = (byte)srcData.alpha;
                                ++i;
                            }
                        } else if (alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = -1;
                                ++i;
                            }
                        }
                        destData.setAlphas(startX, startY + y2, length, alphas, 0);
                        ++y2;
                    }
                    startY += srcHeight;
                }
            }
            startX += srcWidth;
        }
        Image image = new Image((Device)display, destData);
        return image;
    }

    private static class WallpaperFrameDecorator
    extends FrameDecorator {
        public static final WallpaperFrameDecorator DEFAULT = new WallpaperFrameDecorator();

        private WallpaperFrameDecorator() {
        }

        public void decorate(IGraphicalPart part, IFigure figure) {
            FrameFigure frame = (FrameFigure)part.getFigure();
            ShadowedLayer layer = frame.getContentPane();
            if (this.checkWallpaper(part)) {
                layer.setBorderWidth(2);
                layer.setBorderAlpha(255);
                layer.setBorderColor(ColorUtils.getColor((String)"#e05236"));
            } else {
                layer.setBorderWidth(1);
                layer.setBorderAlpha(32);
                layer.setBorderColor(ColorUtils.getColor((String)"#cccccc"));
            }
            super.decorate(part, figure);
        }

        private boolean checkWallpaper(IGraphicalPart part) {
            String modeMD5 = this.getModelMD5(part);
            String currentMD5 = this.getCurrentWallpaperMD5();
            return currentMD5 != null && !"".equals(currentMD5) && currentMD5.equals(modeMD5);
        }

        private String getModelMD5(IGraphicalPart part) {
            Object model = part.getModel();
            if (model != null && model instanceof String) {
                try {
                    FileInputStream fis = new FileInputStream((String)model);
                    return this.getFileMD5(fis);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return "";
        }

        private String getCurrentWallpaperMD5() {
            IStyle style;
            if (mindMapViewer == null) {
                return "";
            }
            ISheet sheet = (ISheet)mindMapViewer.getAdapter(ISheet.class);
            if (sheet != null && (style = this.getStyle(sheet)) != null) {
                String url = style.getProperty("background");
                if (url == null) {
                    return "";
                }
                String path = HyperlinkUtils.toAttachmentPath((String)url);
                IFileEntry fe = sheet.getOwnedWorkbook().getManifest().getFileEntry(path);
                if (fe != null) {
                    InputStream is = fe.getInputStream();
                    return this.getFileMD5(is);
                }
            }
            return "";
        }

        private IStyle getStyle(ISheet sheet) {
            if (sheet != null) {
                String styleId = sheet.getStyleId();
                if (styleId == null) {
                    return null;
                }
                return sheet.getOwnedWorkbook().getStyleSheet().findStyle(styleId);
            }
            return null;
        }

        private String getFileMD5(InputStream input) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                byte[] bytes = new byte[2048];
                try {
                    int numBytes;
                    while ((numBytes = input.read(bytes)) != -1) {
                        md.update(bytes, 0, numBytes);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                byte[] digest = md.digest();
                return new String(Hex.encodeHex((byte[])digest));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    private static class WallpaperItemPart
    extends FramePart {
        public WallpaperItemPart(Object model) {
            super(model);
            this.setDecorator((IDecorator)WallpaperFrameDecorator.DEFAULT);
        }
    }

    private class WallpaperLabelProvider
    extends LabelProvider {
        private WallpaperLabelProvider() {
        }

        public Image getImage(Object element) {
            return WallpaperDialog.this.getWallpaperPreviewImage(element);
        }
    }

    private static class WallpaperPartFactory
    extends GalleryPartFactory {
        private WallpaperPartFactory() {
        }

        protected IPart createFramePart(IPart parent, Object model) {
            return new WallpaperItemPart(model);
        }
    }
}

