/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IMemento;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.CloneHandler;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.URIParser;
import org.xmind.ui.mindmap.IWorkbookRef;

public class ClonedWorkbookRef
extends AbstractWorkbookRef {
    protected static final String URI_PATH = "/clone";
    private static final String PARAM_SOURCE_URI = "sourceURI";
    private String name;

    private ClonedWorkbookRef(URI uri, IMemento state) {
        this(uri, state, null);
    }

    private ClonedWorkbookRef(URI uri, IMemento state, String name) {
        super(uri, state);
        this.name = name;
    }

    public URI getSourceWorkbookURI() {
        return ClonedWorkbookRef.getSourceWorkbookURI(this.getURI());
    }

    private static URI getSourceWorkbookURI(URI uri) {
        String sourceURIString = URIParser.getQueryParameter(uri, PARAM_SOURCE_URI);
        return URI.create(sourceURIString);
    }

    public String getName() {
        int nameIndex;
        if (this.name != null) {
            return this.name;
        }
        String path = this.getSourceWorkbookURI().getPath();
        int suffixIndex = path.lastIndexOf(".");
        if (suffixIndex > 0) {
            path = path.substring(0, suffixIndex);
        }
        if ((nameIndex = path.lastIndexOf("/")) > 0 && nameIndex < path.length() - 1) {
            path = path.substring(nameIndex + 1);
        }
        return path;
    }

    public String getDescription() {
        return this.getName();
    }

    @Override
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.newChild(5);
        URI sourceWorkbookURI = ClonedWorkbookRef.getSourceWorkbookURI(uri);
        IWorkbookRef sourceWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(sourceWorkbookURI, null);
        Assert.isTrue((sourceWorkbookRef != null ? 1 : 0) != 0);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        sourceWorkbookRef.open((IProgressMonitor)subMonitor.newChild(20));
        try {
            IWorkbook sourceWorkbook = sourceWorkbookRef.getWorkbook();
            Assert.isTrue((sourceWorkbook != null ? 1 : 0) != 0);
            IWorkbook iWorkbook = this.doCloneWorkbook((IProgressMonitor)subMonitor.newChild(70), sourceWorkbook);
            return iWorkbook;
        }
        finally {
            subMonitor.setWorkRemaining(5);
            sourceWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
        }
    }

    private IWorkbook doCloneWorkbook(IProgressMonitor monitor, IWorkbook sourceWorkbook) throws InterruptedException, InvocationTargetException {
        try {
            IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook(this.getTempStorage());
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setWorkbookStorageAsOutputTarget();
            serializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            serializer.serialize(null);
            new CloneHandler().withWorkbooks(sourceWorkbook, workbook).copyWorkbookContents();
            return workbook;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static IWorkbookRef create(URI uri, IMemento state) {
        Assert.isNotNull((Object)uri);
        Assert.isLegal((boolean)"xmind-temp".equals(uri.getScheme()));
        Assert.isLegal((boolean)URI_PATH.equals(uri.getPath()));
        return new ClonedWorkbookRef(uri, state);
    }

    public static IWorkbookRef createFromSourceWorkbookURI(URI sourceWorkbookURI, String name) {
        Assert.isNotNull((Object)sourceWorkbookURI);
        URI uri = URI.create("xmind-temp:/clone");
        uri = URIParser.appendQueryParameter(uri, PARAM_SOURCE_URI, sourceWorkbookURI.toString());
        return new ClonedWorkbookRef(uri, null, name);
    }
}

