/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.services.IDisposable;
import org.xmind.ui.editor.EditorHistoryItem;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.editor.IEditorHistoryItem;
import org.xmind.ui.internal.editor.IEditorHistoryLoader;

public final class EditorHistoryImpl
implements IEditorHistory,
IDisposable {
    private final IEditorHistoryLoader loader;
    private final List<URI> unpinnedInputURIs;
    private final List<URI> pinnedInputURIs;
    private final Map<URI, URI> inputToThumbnail;
    private final Map<URI, IEditorHistoryItem> editorHistoryItems;
    private final ListenerList listeners;

    public EditorHistoryImpl(IEditorHistoryLoader loader) {
        this.loader = loader;
        this.unpinnedInputURIs = new ArrayList<URI>();
        this.pinnedInputURIs = new ArrayList<URI>();
        this.inputToThumbnail = new HashMap<URI, URI>();
        this.listeners = new ListenerList();
        this.editorHistoryItems = new HashMap<URI, IEditorHistoryItem>();
        this.init();
    }

    private void init() {
        this.loader.load(new IEditorHistoryLoader.IEditorHistoryLoaderCallback(){

            @Override
            public void thumbnailURILoaded(URI inputURI, URI thumbnailURI) {
                EditorHistoryImpl.this.inputToThumbnail.put(inputURI, thumbnailURI);
            }

            @Override
            public void pinnedInputURILoaded(URI inputURI) {
                EditorHistoryImpl.this.pinnedInputURIs.add(inputURI);
            }

            @Override
            public void inputURILoaded(URI inputURI) {
                EditorHistoryImpl.this.unpinnedInputURIs.add(inputURI);
            }

            @Override
            public void editorHistoryItemsLoaded(URI inputURI, IEditorHistoryItem item) {
                EditorHistoryImpl.this.editorHistoryItems.put(inputURI, item);
            }
        });
        while (this.unpinnedInputURIs.size() > 100) {
            this.unpinnedInputURIs.remove(this.unpinnedInputURIs.size() - 1);
        }
    }

    @Override
    public URI[] getRecentInputURIs(int unpinnedSize) {
        if (unpinnedSize < 0) {
            unpinnedSize = 100;
        }
        unpinnedSize = Math.max(0, Math.min(unpinnedSize, this.unpinnedInputURIs.size()));
        ArrayList<URI> recentInputURIs = new ArrayList<URI>();
        recentInputURIs.addAll(this.pinnedInputURIs);
        recentInputURIs.addAll(this.unpinnedInputURIs.subList(0, unpinnedSize));
        return recentInputURIs.toArray(new URI[recentInputURIs.size()]);
    }

    @Override
    public URI[] getAllInputURIs() {
        int unpinnedSize = Math.max(0, Math.min(100, this.unpinnedInputURIs.size()));
        ArrayList<URI> allInputURIs = new ArrayList<URI>();
        allInputURIs.addAll(this.pinnedInputURIs);
        allInputURIs.addAll(this.unpinnedInputURIs.subList(0, unpinnedSize));
        return allInputURIs.toArray(new URI[unpinnedSize]);
    }

    @Override
    public URI[] getPinnedInputURIs() {
        return this.pinnedInputURIs.toArray(new URI[this.pinnedInputURIs.size()]);
    }

    @Override
    public URI[] getUnpinnedInputURIs(int unpinnedSize) {
        if (unpinnedSize < 0) {
            unpinnedSize = 100;
        }
        unpinnedSize = Math.max(0, Math.min(unpinnedSize, this.unpinnedInputURIs.size()));
        return this.unpinnedInputURIs.subList(0, unpinnedSize).toArray(new URI[unpinnedSize]);
    }

    @Override
    public void add(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        this.add(inputURI, new EditorHistoryItem(inputURI.getScheme(), System.currentTimeMillis()));
        boolean pinned = this.pinnedInputURIs.contains(inputURI);
        this.remove(inputURI);
        if (pinned) {
            this.pinnedInputURIs.add(0, inputURI);
        } else {
            this.unpinnedInputURIs.add(0, inputURI);
            while (this.unpinnedInputURIs.size() > 100) {
                this.unpinnedInputURIs.remove(this.unpinnedInputURIs.size() - 1);
            }
        }
        this.fireChanged();
    }

    @Override
    public void remove(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        int oldPinnedSize = this.pinnedInputURIs.size();
        Iterator<URI> iter = this.pinnedInputURIs.iterator();
        while (iter.hasNext()) {
            URI oldURI = iter.next();
            if (!inputURI.equals(oldURI)) continue;
            iter.remove();
        }
        int oldUnpinnedSize = this.unpinnedInputURIs.size();
        Iterator<URI> unpinnedIterator = this.unpinnedInputURIs.iterator();
        while (unpinnedIterator.hasNext()) {
            URI oldURI = unpinnedIterator.next();
            if (!inputURI.equals(oldURI)) continue;
            unpinnedIterator.remove();
        }
        this.removeThumbnail(inputURI);
        this.removeEditorHistoryItem(inputURI);
        if (oldPinnedSize != this.pinnedInputURIs.size() || oldUnpinnedSize != this.unpinnedInputURIs.size()) {
            this.fireChanged();
        }
    }

    private void removeThumbnail(URI inputURI) {
        File existedThumbnailFile;
        URI thumbnailURI = this.inputToThumbnail.get(inputURI);
        if (thumbnailURI != null && (existedThumbnailFile = new File(thumbnailURI)).exists()) {
            existedThumbnailFile.delete();
        }
        this.inputToThumbnail.remove(inputURI);
    }

    @Override
    public void clear() {
        int oldSize = this.unpinnedInputURIs.size();
        for (URI unpinnedInputURI : this.unpinnedInputURIs) {
            this.removeThumbnail(unpinnedInputURI);
            this.removeEditorHistoryItem(unpinnedInputURI);
        }
        this.unpinnedInputURIs.clear();
        if (oldSize != this.unpinnedInputURIs.size()) {
            this.fireChanged();
        }
    }

    @Override
    public InputStream loadThumbnailData(URI inputURI) throws IOException {
        URI thumbnailURI = this.getThumbnail(inputURI);
        if (thumbnailURI == null) {
            return null;
        }
        return thumbnailURI.toURL().openStream();
    }

    @Override
    public void saveThumbnailData(URI inputURI, InputStream thumbnailData) throws IOException {
        this.removeThumbnail(inputURI);
        URI thumbnailURI = this.loader.saveThumbnail(thumbnailData);
        if (thumbnailURI == null) {
            return;
        }
        this.inputToThumbnail.put(inputURI, thumbnailURI);
        this.fireChanged();
    }

    public URI getThumbnail(URI inputURI) {
        return this.inputToThumbnail.get(inputURI);
    }

    @Override
    public void add(URI inputURI, IEditorHistoryItem item) {
        if (inputURI == null) {
            return;
        }
        boolean pinned = this.pinnedInputURIs.contains(inputURI);
        this.remove(inputURI);
        if (pinned) {
            this.pinnedInputURIs.add(0, inputURI);
        } else {
            this.unpinnedInputURIs.add(0, inputURI);
            while (this.unpinnedInputURIs.size() > 100) {
                this.unpinnedInputURIs.remove(this.unpinnedInputURIs.size() - 1);
            }
        }
        this.removeEditorHistoryItem(inputURI);
        this.editorHistoryItems.put(inputURI, item);
        this.fireChanged();
    }

    private void removeEditorHistoryItem(URI inputURI) {
        IEditorHistoryItem historyItemUri = this.editorHistoryItems.get(inputURI);
        if (historyItemUri != null) {
            historyItemUri = null;
        }
        this.editorHistoryItems.remove(inputURI);
    }

    @Override
    public IEditorHistoryItem getItem(URI inputURI) {
        return this.editorHistoryItems.get(inputURI);
    }

    @Override
    public void pin(URI inputURI) {
        this.unpinnedInputURIs.remove(inputURI);
        this.pinnedInputURIs.remove(inputURI);
        this.pinnedInputURIs.add(0, inputURI);
        this.fireChanged();
    }

    @Override
    public void unPin(URI inputURI) {
        this.pinnedInputURIs.remove(inputURI);
        this.unpinnedInputURIs.remove(inputURI);
        this.unpinnedInputURIs.add(0, inputURI);
        this.fireChanged();
    }

    @Override
    public boolean isPinned(URI inputURI) {
        return this.pinnedInputURIs.contains(inputURI);
    }

    @Override
    public void removeEditorHistoryListener(IEditorHistory.IEditorHistoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void addEditorHistoryListener(IEditorHistory.IEditorHistoryListener listener) {
        this.listeners.add((Object)listener);
    }

    private void fireChanged() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IEditorHistory.IEditorHistoryListener)listener).editorHistoryChanged();
                }
            });
            ++n2;
        }
    }

    public void dispose() {
        this.loader.dispose();
    }
}

