/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.ModifyStyleCommand;
import org.xmind.ui.commands.ModifyThemeCommand;
import org.xmind.ui.mindmap.MindMapUI;

public class ModifyThemeCommandBuilder
extends CommandBuilder {
    private static final String NULL = "$NULL$";
    private IStyle sourceTheme;
    private Map<IWorkbook, IStyle> appliedThemes = null;
    private List<IStyled> sources = new ArrayList<IStyled>();

    public ModifyThemeCommandBuilder(IViewer viewer, ICommandStack commandStack, IStyle theme) {
        super(viewer, commandStack);
        this.sourceTheme = theme;
    }

    public ModifyThemeCommandBuilder(IViewer viewer, CommandBuilder delegate, IStyle theme) {
        super(viewer, delegate);
        this.sourceTheme = theme;
    }

    public IStyle getTheme() {
        return this.sourceTheme;
    }

    public void removeStyle(IStyled source) {
        if (this.isSourceModified(source)) {
            return;
        }
        this.modifyStyle(source, null);
        this.sources.add(source);
    }

    public List<IStyled> getModifiedSources() {
        return this.sources;
    }

    public boolean isSourceModified(IStyled source) {
        return this.sources.contains(source);
    }

    private void modifyStyle(IStyled source, String newStyleId) {
        if (NULL.equals(newStyleId)) {
            newStyleId = null;
        }
        this.add((Command)new ModifyStyleCommand(source, newStyleId), true);
    }

    public void modify(ISheet sheet) {
        IStyle appliedTheme = this.getAppliedTheme(sheet);
        if (appliedTheme == null) {
            this.add((Command)new ModifyThemeCommand(sheet, null), true);
        } else {
            this.add((Command)new ModifyThemeCommand(sheet, appliedTheme.getId()), true);
        }
    }

    private IStyle getAppliedTheme(ISheet sheet) {
        if (this.sourceTheme == null || this.sourceTheme.isEmpty() || MindMapUI.getResourceManager().getBlankTheme().equals(this.sourceTheme)) {
            return null;
        }
        IWorkbook workbook = sheet.getOwnedWorkbook();
        if (workbook == null) {
            return this.sourceTheme;
        }
        if (this.appliedThemes == null) {
            this.appliedThemes = new HashMap<IWorkbook, IStyle>();
        }
        if (!this.appliedThemes.containsKey(workbook)) {
            IStyle appliedTheme = this.createAppliedTheme(workbook);
            this.appliedThemes.put(workbook, appliedTheme);
        }
        return this.appliedThemes.get(workbook);
    }

    private IStyle createAppliedTheme(IWorkbook workbook) {
        IStyleSheet ss = workbook.getStyleSheet();
        return ss.importStyle(this.sourceTheme);
    }
}

