/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.CloneHandler;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddSheetCommand;
import org.xmind.ui.dialogs.IDialogConstants;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IWorkbookRef;

public class ImportFromWorkbookHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        final IWorkbook targetWorkbook = (IWorkbook)editor.getAdapter(IWorkbook.class);
        if (targetWorkbook == null) {
            throw new ExecutionException("No workbook available in editor.");
        }
        final ICommandStack commandStack = (ICommandStack)editor.getAdapter(ICommandStack.class);
        FileDialog dialog = new FileDialog(editor.getSite().getShell(), 4096);
        dialog.setText(WizardMessages.ImportPage_FileDialog_text);
        dialog.setFilterExtensions(new String[]{"*.xmind"});
        dialog.setFilterNames(new String[]{NLS.bind((String)"{0} (*{1})", (Object)IDialogConstants.FILE_DIALOG_FILTER_WORKBOOK, (Object)".xmind")});
        final String sourcePath = dialog.open();
        if (sourcePath == null) {
            return null;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                URI uri = new File(sourcePath).toURI();
                IWorkbookRef sourceWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(uri, null);
                if (sourceWorkbookRef == null) {
                    return;
                }
                sourceWorkbookRef.open(null);
                try {
                    IWorkbook sourceWorkbook = sourceWorkbookRef.getWorkbook();
                    if (sourceWorkbook == null) {
                        return;
                    }
                    ArrayList<AddSheetCommand> commands = new ArrayList<AddSheetCommand>();
                    CloneHandler cloneHandler = new CloneHandler().withWorkbooks(sourceWorkbook, targetWorkbook);
                    for (ISheet sourceSheet : sourceWorkbook.getSheets()) {
                        ISheet targetSheet = (ISheet)cloneHandler.cloneObject((Object)sourceSheet);
                        if (targetSheet == null) continue;
                        commands.add(new AddSheetCommand(targetSheet, targetWorkbook));
                    }
                    CompoundCommand command = new CompoundCommand(commands);
                    if (commandStack != null) {
                        commandStack.execute((Command)command);
                    } else {
                        command.execute();
                    }
                }
                finally {
                    sourceWorkbookRef.close(null);
                }
            }
        });
        return null;
    }
}

