/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.Page;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.resources.ColorUtils;

public class SheetOverviewPage
extends Page
implements ISelectionChangedListener,
IInputChangedListener,
PropertyChangeListener,
IZoomListener,
Listener {
    private IGraphicalEditorPage sourcePage;
    private IGraphicalViewer sourceViewer;
    private RangeModel sourceHorizontalRangeModel;
    private RangeModel sourceVerticalRangeModel;
    private ZoomManager sourceZoomManager;
    private IFigure sourceContents;
    private FigureCanvas canvas;
    private IFigure contents;
    private IFigure feedback;
    private boolean updating = false;
    private ContentsLayoutListener contentsListener;
    private Point moveStart = null;
    private Point sourceStart = null;
    private double zoomScale = 1.0;

    public SheetOverviewPage(IGraphicalEditorPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public void createControl(Composite parent) {
        this.canvas = new FigureCanvas(parent);
        this.canvas.addListener(11, (Listener)this);
        this.canvas.addListener(3, (Listener)this);
        this.canvas.addListener(5, (Listener)this);
        this.canvas.addListener(4, (Listener)this);
        this.canvas.addListener(37, (Listener)this);
        this.contents = new ContentsFigure();
        this.contents.setCursor(Cursors.HAND);
        this.canvas.setContents(this.contents);
        this.feedback = this.createFeedback();
        this.contents.add(this.feedback);
        this.sourceViewer = this.sourcePage.getViewer();
        this.sourceZoomManager = this.sourceViewer.getZoomManager();
        this.sourceViewer.addInputChangedListener((IInputChangedListener)this);
        this.sourceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.sourceZoomManager.addZoomListener((IZoomListener)this);
        this.hookViewport();
        this.hookContents();
        this.update();
    }

    public void dispose() {
        this.unhookContents();
        this.unhookViewport();
        this.sourceZoomManager.removeZoomListener((IZoomListener)this);
        this.sourceViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.sourceViewer.removeInputChangedListener((IInputChangedListener)this);
        super.dispose();
    }

    public Control getControl() {
        return this.canvas;
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
        this.unhookContents();
        this.unhookViewport();
        this.hookViewport();
        this.hookContents();
        this.update();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.update();
    }

    public void handleEvent(Event event) {
        if (event.type == 3) {
            this.moveStarted(event.x, event.y);
        } else if (event.type == 5) {
            if (this.moveStart != null) {
                this.feedbackMoved(event.x, event.y);
            }
        } else if (event.type == 4) {
            this.moveEnded(event.x, event.y);
        } else if (event.type == 37) {
            this.changeZoom(event.count);
        } else if (event.type == 11) {
            this.update();
        }
    }

    private void moveStarted(int x, int y) {
        this.moveStart = new Point(x, y);
        this.sourceStart = new Point(this.sourceViewer.getScrollPosition());
    }

    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                SheetOverviewPage.this.doUpdate();
                SheetOverviewPage.this.updating = false;
            }
        });
    }

    private void doUpdate() {
        Rectangle feedbackBounds;
        Insets margins;
        Rectangle sourceBounds = this.sourceContents.getBounds();
        Dimension source = sourceBounds.getSize();
        Rectangle area = this.contents.getParent().getClientArea();
        if (area.width == 0 || area.height == 0 || source.width == 0 || source.height == 0) {
            this.zoomScale = -1.0;
            margins = IFigure.NO_INSETS;
            feedbackBounds = null;
        } else {
            int m;
            double wScale = (double)source.width * 1.0 / (double)area.width;
            double hScale = (double)source.height * 1.0 / (double)area.height;
            if (wScale > hScale) {
                this.zoomScale = 1.0 / wScale;
                m = (int)(((double)area.height - (double)source.height / wScale) / 2.0);
                margins = new Insets(m, 0, m, 0);
            } else {
                this.zoomScale = 1.0 / hScale;
                m = (int)(((double)area.width - (double)source.width / hScale) / 2.0);
                margins = new Insets(0, m, 0, m);
            }
            Viewport sourceViewport = this.sourceViewer.getCanvas().getViewport();
            PrecisionPoint loc = new PrecisionPoint(sourceViewport.getViewLocation());
            Dimension size = sourceViewport.getSize();
            double sourceScale = this.sourceZoomManager.getScale();
            feedbackBounds = new Rectangle(loc.scale(1.0 / sourceScale).translate(new PrecisionPoint(sourceBounds.getLocation()).negate()).scale(this.zoomScale).translate((double)margins.left, (double)margins.top).toDraw2DPoint(), size.scale(this.zoomScale / sourceScale));
        }
        this.contents.setBounds(area.getShrinked(margins));
        this.contents.repaint();
        if (feedbackBounds == null) {
            this.feedback.setBounds(new Rectangle(1, 1, 0, 0));
            this.feedback.setVisible(false);
        } else {
            this.feedback.setBounds(feedbackBounds);
            this.feedback.setVisible(true);
        }
    }

    private void hookViewport() {
        Viewport sourceViewport = this.sourceViewer.getCanvas().getViewport();
        this.sourceHorizontalRangeModel = sourceViewport.getHorizontalRangeModel();
        this.sourceHorizontalRangeModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.sourceVerticalRangeModel = sourceViewport.getVerticalRangeModel();
        this.sourceVerticalRangeModel.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void unhookViewport() {
        if (this.sourceHorizontalRangeModel != null) {
            this.sourceHorizontalRangeModel.removePropertyChangeListener((PropertyChangeListener)this);
            this.sourceHorizontalRangeModel = null;
        }
        if (this.sourceVerticalRangeModel != null) {
            this.sourceVerticalRangeModel.removePropertyChangeListener((PropertyChangeListener)this);
            this.sourceVerticalRangeModel = null;
        }
    }

    private void hookContents() {
        if (this.contentsListener == null) {
            this.contentsListener = new ContentsLayoutListener();
        }
        this.sourceContents = this.sourceViewer.getLayer(GEF.LAYER_CONTENTS);
        this.sourceContents.addLayoutListener((LayoutListener)this.contentsListener);
    }

    private void unhookContents() {
        if (this.contentsListener != null && this.sourceContents != null) {
            this.sourceContents.removeLayoutListener((LayoutListener)this.contentsListener);
        }
    }

    private IFigure createFeedback() {
        RectangleFigure figure = new RectangleFigure();
        figure.setForegroundColor(ColorConstants.red);
        figure.setLineWidth(2);
        figure.setFill(false);
        figure.setOutline(true);
        return figure;
    }

    private void moveEnded(int x, int y) {
        if (this.moveStart != null && this.moveStart.x == x && this.moveStart.y == y) {
            this.directMove(x, y);
        }
        this.moveStart = null;
        this.sourceStart = null;
    }

    private void directMove(int x, int y) {
        Point start = this.feedback.getBounds().getCenter();
        Dimension offset = new PrecisionDimension((double)(x - start.x), (double)(y - start.y)).scale(this.sourceZoomManager.getScale() / this.zoomScale).toDraw2DDimension();
        this.sourceViewer.scrollDelta(offset);
    }

    private void feedbackMoved(int x, int y) {
        int dx = x - this.moveStart.x;
        int dy = y - this.moveStart.y;
        Dimension offset = new PrecisionDimension((double)dx, (double)dy).scale(this.sourceZoomManager.getScale() / this.zoomScale).toDraw2DDimension();
        this.sourceViewer.scrollTo(this.sourceStart.getTranslated(offset));
    }

    private void changeZoom(int value) {
        if (value > 0) {
            this.sourceZoomManager.zoomIn();
        } else if (value < 0) {
            this.sourceZoomManager.zoomOut();
        }
    }

    private class ContentsFigure
    extends Figure {
        public ContentsFigure() {
            this.setBackgroundColor(ColorUtils.getColor((String)"#f3f4f9"));
            this.setOpaque(true);
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            if (SheetOverviewPage.this.sourceContents == null || SheetOverviewPage.this.zoomScale <= 0.0) {
                return;
            }
            graphics.setAntialias(1);
            graphics.pushState();
            try {
                Point offset = this.getBounds().getLocation();
                graphics.translate(offset);
                Graphics g = graphics;
                ScaledGraphics sg = null;
                if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
                    sg = new ScaledGraphics(graphics);
                    sg.scale(SheetOverviewPage.this.zoomScale);
                    g = sg;
                } else {
                    g.scale(SheetOverviewPage.this.zoomScale);
                }
                try {
                    this.paintDelegate(g, SheetOverviewPage.this.sourceContents);
                }
                finally {
                    if (sg != null) {
                        sg.dispose();
                    }
                }
            }
            finally {
                graphics.popState();
            }
            Rectangle area = this.getClientArea();
            graphics.setLineWidth(1);
            graphics.setLineStyle(1);
            graphics.setForegroundColor(ColorConstants.darkGray);
            graphics.drawRectangle(area.x, area.y, area.width - 1, area.height - 1);
        }

        private void paintDelegate(Graphics graphics, IFigure figure) {
            Point loc = figure.getBounds().getLocation();
            graphics.translate(-loc.x, -loc.y);
            try {
                figure.paint(graphics);
            }
            finally {
                graphics.translate(loc.x, loc.y);
            }
        }
    }

    private class ContentsLayoutListener
    extends LayoutListener.Stub {
        private ContentsLayoutListener() {
        }

        public void postLayout(IFigure container) {
            SheetOverviewPage.this.update();
        }
    }
}

