/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConfirmPageViewer2 {
    private Composite container;
    private List<Object> markerGroups = new ArrayList<Object>();
    private List<Object> clipArtGroups = new ArrayList<Object>();
    private Map<Image, String> templateMap = new HashMap<Image, String>();
    private Map<Image, String> themeMap = new HashMap<Image, String>();
    private ScrolledComposite sc;
    private Composite c;
    private ResourceGroupConfirmViewer markerViewer;
    private ResourceGroupConfirmViewer clipArtViewer;
    private ResourceConfirmViewer themeViewer;
    private ResourceConfirmViewer templateViewer;

    public ResourceConfirmPageViewer2(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        this.container = this.createViewerContainer(composite);
    }

    private void createViewers(Composite parent) {
        this.sc = new ScrolledComposite(parent, 768);
        this.sc.setLayout((Layout)new FillLayout(512));
        this.c = new Composite((Composite)this.sc, 0);
        this.c.setLayoutData((Object)new GridData(1808));
        this.c.setLayout((Layout)new GridLayout(1, false));
        this.c.setBackground(parent.getDisplay().getSystemColor(1));
        if (!this.markerGroups.isEmpty()) {
            this.markerViewer = new ResourceGroupConfirmViewer(this.c, Messages.ResourceConfirmPageViewer_Marker, "xmindresource/mar.png");
            this.markerViewer.setInput(this.markerGroups);
            this.markerGroups.clear();
        }
        if (!this.themeMap.isEmpty()) {
            this.themeViewer = new ResourceConfirmViewer(this.c, Messages.ResourceConfirmPageViewer_Theme, "xmindresource/theme.png");
            this.themeViewer.setInput(this.themeMap);
            this.themeMap.clear();
        }
        if (!this.templateMap.isEmpty()) {
            this.templateViewer = new ResourceConfirmViewer(this.c, Messages.ResourceConfirmPageViewer_Template, "xmindresource/template.png");
            this.templateViewer.setInput(this.templateMap);
            this.templateMap.clear();
        }
        if (!this.clipArtGroups.isEmpty()) {
            this.clipArtViewer = new ResourceGroupConfirmViewer(this.c, Messages.ResourceConfirmPageViewer_Clip_Art, "xmindresource/clipart.png");
            this.clipArtViewer.setInput(this.clipArtGroups);
            this.clipArtGroups.clear();
        }
        this.sc.setContent((Control)this.c);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ResourceConfirmPageViewer2.this.sc.getClientArea();
                ResourceConfirmPageViewer2.this.sc.setMinSize(ResourceConfirmPageViewer2.this.c.computeSize(r.width, -1));
            }
        });
        parent.layout();
    }

    private Composite createViewerContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new FillLayout());
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        return container;
    }

    public Composite getContainer() {
        return this.container;
    }

    public void setNeedConfirmSelectionMap(Map<Object, Image> confirmMap) {
        if (confirmMap != null) {
            Set<Object> elements = confirmMap.keySet();
            for (Object element : elements) {
                if (element instanceof IStyle) {
                    this.themeMap.put(confirmMap.get(element), ((IStyle)element).getName());
                    continue;
                }
                if (element instanceof ITemplate) {
                    this.templateMap.put(confirmMap.get(element), ((ITemplate)element).getName());
                    continue;
                }
                if (element instanceof IGalleryGroup) {
                    this.clipArtGroups.add(element);
                    continue;
                }
                if (!(element instanceof IMarkerGroup)) continue;
                this.markerGroups.add(element);
            }
        }
        if (this.c != null) {
            this.c.dispose();
            this.c = null;
        }
        if (this.sc != null) {
            this.sc.dispose();
            this.sc = null;
        }
        if (this.container != null) {
            this.createViewers(this.container);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceConfirmViewer {
        private Composite control;

        public ResourceConfirmViewer(Composite parent, String title, String path) {
            Composite composite = new Composite(parent, 2048);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            composite.setBackground(parent.getBackground());
            this.control = composite;
            this.createTitleArea(composite, title, path);
        }

        private void createTitleArea(Composite parent, String title, String path) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            composite.setBackground(parent.getBackground());
            Label iconLabel = new Label(composite, 0);
            iconLabel.setImage(XMindResourcePlugin.imageFrom(path).createImage(false, (Device)Display.getCurrent()));
            Label label = new Label(composite, 0);
            label.setText(title);
        }

        public void setInput(Map<Image, String> itemMap) {
            this.createGroup(this.control, itemMap);
        }

        private void createGroup(Composite parent, Map<Image, String> itemMap) {
            final Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setBackground(Display.getCurrent().getSystemColor(1));
            final Composite groupContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(3, false);
            groupContainer.setLayout((Layout)layout);
            groupContainer.setBackground(composite.getBackground());
            for (Image image : itemMap.keySet()) {
                Composite itemContainer = new Composite(groupContainer, 0);
                itemContainer.setBackground(groupContainer.getBackground());
                itemContainer.setLayout((Layout)gridLayout);
                itemContainer.setLayoutData((Object)new GridData(1808));
                Composite imageContainer = new Composite(itemContainer, 2048);
                imageContainer.setLayout((Layout)gridLayout);
                imageContainer.setLayoutData((Object)new GridData(1808));
                imageContainer.setBackground(itemContainer.getBackground());
                Label imageLabel = new Label(imageContainer, 0);
                imageLabel.setImage(this.fitImage(image));
                imageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
                Label title = new Label(itemContainer, 0);
                title.setText(itemMap.get(image));
                title.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = composite.getClientArea();
                    groupContainer.setLayout((Layout)new GridLayout(r.width / 143, false));
                    composite.layout();
                }
            });
        }

        private Image fitImage(Image image) {
            ImageData imageData = image.getImageData();
            if (imageData.width > 128) {
                return new Image(null, imageData.scaledTo(128, imageData.height * 128 / imageData.width));
            }
            return image;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceGroupConfirmViewer {
        private Composite control;
        private LocalResourceManager resources;

        public ResourceGroupConfirmViewer(Composite parent, String title, String path) {
            Composite composite = new Composite(parent, 2048);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            composite.setBackground(parent.getBackground());
            this.control = composite;
            this.createTitleArea(composite, title, path);
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }

        private void createTitleArea(Composite parent, String title, String path) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            composite.setBackground(parent.getBackground());
            Label iconLabel = new Label(composite, 0);
            iconLabel.setImage(XMindResourcePlugin.imageFrom(path).createImage(false, (Device)Display.getCurrent()));
            Label label = new Label(composite, 0);
            label.setText(title);
        }

        public void setInput(List<Object> groups) {
            if (groups != null) {
                for (Object group : groups) {
                    this.createGroup(this.control, group);
                }
            }
        }

        private void createGroup(Composite parent, Object group) {
            Composite composite = new Composite(parent, 2048);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setBackground(Display.getCurrent().getSystemColor(1));
            Label groupControl = new Label(composite, 0);
            String name = "";
            if (group instanceof IMarkerGroup) {
                name = ((IMarkerGroup)group).getName();
                this.fillWithMarker((IMarkerGroup)group, composite);
            } else if (group instanceof IGalleryGroup) {
                name = ((IGalleryGroup)group).getName();
                this.fillWithClipArt((IGalleryGroup)group, composite);
            }
            groupControl.setText(name);
        }

        private void fillWithClipArt(IGalleryGroup group, final Composite composite) {
            List items = group.getItems();
            final Composite groupContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(6, false);
            groupContainer.setLayout((Layout)layout);
            groupContainer.setBackground(composite.getBackground());
            for (IGalleryItem item : items) {
                Label galleryLable = new Label(groupContainer, 0);
                Image image = this.getImage(item);
                galleryLable.setImage(image);
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = composite.getClientArea();
                    groupContainer.setLayout((Layout)new GridLayout(r.width / 85, false));
                    composite.layout();
                }
            });
        }

        private Image getImage(IGalleryItem item) {
            Image image = this.createImage(item);
            ImageData imageData = image.getImageData();
            if (imageData.width > 80) {
                return new Image(null, imageData.scaledTo(80, imageData.height * 80 / imageData.width));
            }
            return image;
        }

        private Image createImage(IGalleryItem item) {
            URL url = item.getURL();
            if (url != null) {
                return (Image)this.resources.get((DeviceResourceDescriptor)ImageDescriptor.createFromURL((URL)url));
            }
            return null;
        }

        private void fillWithMarker(IMarkerGroup group, final Composite composite) {
            List markers = group.getMarkers();
            final Composite groupContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(23, false);
            groupContainer.setLayout((Layout)layout);
            groupContainer.setBackground(composite.getBackground());
            for (IMarker marker : markers) {
                Label markerLabel = new Label(groupContainer, 0);
                markerLabel.setImage(MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)16, (int)16).createImage());
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = composite.getClientArea();
                    groupContainer.setLayout((Layout)new GridLayout(r.width / 21 - 1, false));
                    composite.layout();
                }
            });
        }
    }
}

