/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.thrift;

import com.evernote.thrift.TBase;
import com.evernote.thrift.TException;
import com.evernote.thrift.TFieldIdEnum;
import com.evernote.thrift.TReflectionBase;
import com.evernote.thrift.protocol.TField;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.protocol.TProtocolException;
import com.evernote.thrift.protocol.TStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TUnion<T extends TUnion, F extends TFieldIdEnum>
implements TReflectionBase<T, F> {
    protected Object value_;
    protected F setField_;

    protected TUnion() {
        this.setField_ = null;
        this.value_ = null;
    }

    protected TUnion(F setField, Object value) {
        this.setFieldValue(setField, value);
    }

    protected TUnion(TUnion<T, F> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TUnion.deepCopyObject(other.value_);
    }

    private static Object deepCopyObject(Object o) {
        if (o instanceof TBase) {
            return ((TBase)o).deepCopy();
        }
        if (o instanceof byte[]) {
            byte[] other_val = (byte[])o;
            byte[] this_val = new byte[other_val.length];
            System.arraycopy(other_val, 0, this_val, 0, other_val.length);
            return this_val;
        }
        if (o instanceof List) {
            return TUnion.deepCopyList((List)o);
        }
        if (o instanceof Set) {
            return TUnion.deepCopySet((Set)o);
        }
        if (o instanceof Map) {
            return TUnion.deepCopyMap((Map)o);
        }
        return o;
    }

    private static Map deepCopyMap(Map<Object, Object> map) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            copy.put(TUnion.deepCopyObject(entry.getKey()), TUnion.deepCopyObject(entry.getValue()));
        }
        return copy;
    }

    private static Set deepCopySet(Set set) {
        HashSet<Object> copy = new HashSet<Object>();
        for (Object o : set) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    private static List deepCopyList(List list) {
        ArrayList<Object> copy = new ArrayList<Object>(list.size());
        for (Object o : list) {
            copy.add(TUnion.deepCopyObject(o));
        }
        return copy;
    }

    public F getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    @Override
    public Object getFieldValue(F fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    @Override
    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(this.enumForId((short)fieldId));
    }

    public boolean isSet() {
        return this.setField_ != null;
    }

    @Override
    public boolean isSet(F fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public boolean isSet(int fieldId) {
        return this.isSet(this.enumForId((short)fieldId));
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = null;
        this.value_ = null;
        iprot.readStructBegin();
        TField field = iprot.readFieldBegin();
        this.value_ = this.readValue(iprot, field);
        if (this.value_ != null) {
            this.setField_ = this.enumForId(field.id);
        }
        iprot.readFieldEnd();
        iprot.readFieldBegin();
        iprot.readStructEnd();
    }

    @Override
    public void setFieldValue(F fieldId, Object value) {
        this.checkType(fieldId, value);
        this.setField_ = fieldId;
        this.value_ = value;
    }

    @Override
    public void setFieldValue(int fieldId, Object value) {
        this.setFieldValue(this.enumForId((short)fieldId), value);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        if (this.getSetField() == null || this.getFieldValue() == null) {
            throw new TProtocolException("Cannot write a TUnion with no set value!");
        }
        oprot.writeStructBegin(this.getStructDesc());
        oprot.writeFieldBegin(this.getFieldDesc(this.setField_));
        this.writeValue(oprot);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    protected abstract void checkType(F var1, Object var2) throws ClassCastException;

    protected abstract Object readValue(TProtocol var1, TField var2) throws TException;

    protected abstract void writeValue(TProtocol var1) throws TException;

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(F var1);

    protected abstract F enumForId(short var1);

    public String toString() {
        String result = "<" + this.getClass().getSimpleName() + " ";
        if (this.getSetField() != null) {
            Object v = this.getFieldValue();
            String vStr = null;
            vStr = v instanceof byte[] ? TUnion.bytesToStr((byte[])v) : v.toString();
            result = String.valueOf(result) + this.getFieldDesc(this.getSetField()).name + ":" + vStr;
        }
        return String.valueOf(result) + ">";
    }

    private static String bytesToStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int size = Math.min(bytes.length, 128);
        int i = 0;
        while (i < size) {
            String digit;
            if (i != 0) {
                sb.append(" ");
            }
            sb.append((digit = Integer.toHexString(bytes[i] & 0xFF)).length() > 1 ? digit : "0" + digit);
            ++i;
        }
        if (bytes.length > 128) {
            sb.append(" ...");
        }
        return sb.toString();
    }

    @Override
    public final void clear() {
        this.setField_ = null;
        this.value_ = null;
    }
}

