/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.gantt2.gefext.IBoundingPathProvider;
import org.xmind.ui.gantt2.gefext.IPathShape;
import org.xmind.ui.gantt2.gefext.PathDescriptor;
import org.xmind.ui.gantt2.gefext.PathShapeHandle;

public class DependencyArrowDecoration
extends PathShapeHandle
implements PropertyChangeListener,
IBoundingPathProvider {
    private static final double WING_WIDTH = 2.0;
    private static final double LENGTH = 6.0;

    public DependencyArrowDecoration() {
        this.setOpaque(false);
        this.setFill(true);
        this.setOutline(false);
        this.setLineWidthFloat(1.0f);
    }

    protected void hookHost(IFigure host) {
        super.hookHost(host);
        host.addPropertyChangeListener("outline path", (PropertyChangeListener)this);
    }

    protected void unhookHost(IFigure host) {
        host.removePropertyChangeListener("outline path", (PropertyChangeListener)this);
        super.unhookHost(host);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.resetPaths();
    }

    protected void resetPaths() {
        PathDescriptor connectionPath = ((IPathShape)this.getHost()).getOutlinePath();
        Iterator<PrecisionPoint> points = connectionPath.reversePoints();
        PrecisionPoint end = points.next();
        PrecisionPoint start = points.next();
        if (end == null || start == null) {
            this.setFillPath(null);
            this.setOutlinePath(null);
            return;
        }
        PathDescriptor path = new PathDescriptor();
        boolean right = start.x < end.x;
        double halfLineWidth = (double)this.getLineWidthFloat() * 0.5;
        double x1 = right ? end.x + 2.0 : end.x - 2.0;
        double y1 = end.y + 0.5;
        double x2 = right ? end.x - 6.0 - halfLineWidth : end.x + 6.0 + halfLineWidth;
        double y3 = end.y - 2.0 - halfLineWidth;
        double y4 = end.y + 2.0 + halfLineWidth + 1.0;
        path.moveTo(x1, y1);
        path.lineTo(x2, y3);
        path.lineTo(x2, y4);
        path.lineTo(x1, y1);
        path.close();
        this.setFillPath(path);
        this.setOutlinePath(path);
    }

    private void updateProperties() {
        if (this.getHost() != null) {
            this.setBackgroundColor(this.getHost().getForegroundColor());
            if (this.getHost() instanceof Shape) {
                Shape shape = (Shape)this.getHost();
                this.setAlpha(shape.getAlpha());
                this.setAntialias(shape.getAntialias());
                this.setEnabled(shape.isEnabled());
                this.setLineAttributes(shape.getLineAttributes());
            }
        }
    }

    public void ancestorAdded(IFigure ancestor) {
        this.updateProperties();
        super.ancestorAdded(ancestor);
    }

    public void ancestorMoved(IFigure ancestor) {
        this.updateProperties();
        super.ancestorMoved(ancestor);
    }

    public PathDescriptor getBoundingPath() {
        return this.getOutlinePath();
    }
}

