/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.viewers.MComboViewer;

public class TimelineController
implements PropertyChangeListener,
ISelectionChangedListener {
    private TimelineModel model = null;
    private Control control;
    private MComboViewer combo;
    private boolean updating = false;

    public TimelineController(Composite parent) {
        this.control = this.createControl(parent);
        this.update();
    }

    private Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.marginLeft = 5;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(GanttMessages.TimelineView_Timeline);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.combo = new MComboViewer(composite, 0);
        this.combo.getControl().setLayoutData((Object)new GridData(4, 128, true, false));
        this.combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.combo.setLabelProvider((IBaseLabelProvider)new TimelineViewLabelProvider());
        this.combo.addSelectionChangedListener((ISelectionChangedListener)this);
        this.combo.setInput((Object)TimelineView.values());
        this.combo.setHandleVerticalPaddings(0, 0);
        return composite;
    }

    public void setBackground(Color color) {
        this.setBackground(this.control, color);
    }

    private void setBackground(Control control, Color color) {
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setBackground(c, color);
                ++n2;
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public TimelineModel getModel() {
        return this.model;
    }

    public void setModel(TimelineModel model) {
        if (model == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        this.model = model;
        if (model != null) {
            model.getPropertyChangeSupport().addPropertyChangeListener(this);
        }
        this.update();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    public void update() {
        TimelineView view;
        if (this.model != null && !this.getControl().isDisposed() && (view = TimelineView.findView(this.model.getPrecision())) != null) {
            this.updating = true;
            this.combo.setSelection((ISelection)new StructuredSelection((Object)view), true);
            this.updating = false;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.updating || this.model == null || event.getSelection().isEmpty()) {
            return;
        }
        Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
        this.model.setPrecision(((TimelineView)((Object)element)).getValue());
        this.control.getParent().layout();
        VerifyUI20141031.getUsageDataCollector().increase("GanttTimeLineChangeCount");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TimelineView {
        Hours(144.0, GanttMessages.TimelineView_Hours),
        Days(3456.0, GanttMessages.TimelineView_Days),
        DaysOfWeek(3323.0, GanttMessages.TimelineView_DaysOfWeek),
        Weeks(15120.0, GanttMessages.TimelineView_Weeks),
        Months(64800.0, GanttMessages.TimelineView_Months);

        private double value;
        private String name;

        private TimelineView(double value, String name) {
            this.value = value;
            this.name = name;
        }

        public double getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static TimelineView findView(double value) {
            TimelineView[] timelineViewArray = TimelineView.values();
            int n = timelineViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimelineView view = timelineViewArray[n2];
                if (value == view.getValue()) {
                    return view;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class TimelineViewLabelProvider
    extends LabelProvider {
        private TimelineViewLabelProvider() {
        }

        public String getText(Object element) {
            return ((TimelineView)((Object)element)).getName();
        }
    }
}

