/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline;

import java.util.Arrays;
import java.util.List;
import org.xmind.ui.internal.exports.outline.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExportFormat {
    PDF(Messages.Pdf_Name, "pdf", "pdf file", 0, ".pdf"),
    TEXT(Messages.Text_Name, "text", "text file", 1, ".txt"),
    WORD(Messages.Word_Name, "word", "document file", 2, ".doc", ".docx");

    private String name;
    private String mediaType;
    private String description;
    private int formatType;
    private List<String> fileExtendions;

    private ExportFormat(String name, String mediaType, String description, int formatType, String ... fileExtensions) {
        this.name = name;
        this.mediaType = mediaType;
        this.description = description;
        this.formatType = formatType;
        this.fileExtendions = Arrays.asList(fileExtensions);
    }

    public String getName() {
        return this.name;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFormat() {
        return this.formatType;
    }

    public List<String> getFileExtendions() {
        return this.fileExtendions;
    }

    public static ExportFormat findByExtension(String ext, ExportFormat defaultFormat) {
        ExportFormat[] exportFormatArray = ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportFormat format = exportFormatArray[n2];
            if (format.fileExtendions.contains(ext.toLowerCase())) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }

    public static ExportFormat findByMediaType(String mediaType, ExportFormat defaultFormat) {
        ExportFormat[] exportFormatArray = ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportFormat format = exportFormatArray[n2];
            if (format.mediaType.equals(mediaType)) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }

    public static ExportFormat findByFormatType(int formatType, ExportFormat defaultFormat) {
        ExportFormat[] exportFormatArray = ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportFormat format = exportFormatArray[n2];
            if (format.formatType == formatType) {
                return format;
            }
            ++n2;
        }
        return defaultFormat;
    }
}

