/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.forms;

import java.util.Arrays;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.ui.forms.BellowsData;

public class BellowsLayout
extends Layout {
    public int alignment = 1;
    public int direction = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int marginLeft = 0;
    public int marginRight = 0;
    public int marginTop = 0;
    public int marginBottom = 0;
    public int spacing = 0;
    private int cachedWHint = -1;
    private int cachedHHint = -1;
    private Point cachedSize = null;
    private static final IAdjust EXPAND = new IAdjust(){

        @Override
        public int adjust(int width, int adjustment) {
            return width + adjustment;
        }
    };
    private static final IAdjust SHRINK = new IAdjust(){

        @Override
        public int adjust(int width, int adjustment) {
            return width - adjustment;
        }
    };

    public BellowsLayout() {
    }

    public BellowsLayout(int direction) {
        this.direction = direction;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint < 0 || hHint < 0) {
            if (flushCache || this.cachedSize == null || wHint != this.cachedWHint || hHint != this.cachedHHint) {
                this.layout(composite, this.getWidth(wHint, hHint), this.getHeight(wHint, hHint), null, flushCache);
            }
            return new Point(this.cachedSize.x, this.cachedSize.y);
        }
        return new Point(wHint, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle bounds = composite.getClientArea();
        int wHint = this.getWidth(bounds);
        int hHint = this.getHeight(bounds);
        this.layout(composite, wHint, hHint, bounds, flushCache);
    }

    /*
     * WARNING - void declaration
     */
    private void layout(Composite composite, int wHint, int hHint, Rectangle bounds, boolean flushCache) {
        SortedSet<Adjustable> adjustableSet;
        Object adjustPriority;
        int controlIndex;
        BellowsData data;
        Control control;
        Control[] allControls = composite.getChildren();
        int count = 0;
        Control[] controls = new Control[allControls.length];
        int[] prefWidths = new int[allControls.length];
        int[] prefHeights = new int[allControls.length];
        int[] cellWidths = new int[allControls.length];
        HashMap softShrinkables = new HashMap(allControls.length);
        TreeSet<Adjustable> hardShrinkables = new TreeSet<Adjustable>();
        HashMap<Integer, TreeSet<Adjustable>> softExpandables = new HashMap<Integer, TreeSet<Adjustable>>(allControls.length);
        TreeSet<Adjustable> hardExpandables = new TreeSet<Adjustable>();
        int childHeightHint = hHint < 0 ? hHint : Math.max(0, hHint - this.getHeight(this.marginWidth, this.marginHeight) * 2 - this.getHeight(this.marginLeft, this.marginTop) - this.getHeight(this.marginRight, this.marginBottom));
        int actualHeight = 0;
        int actualWidth = 0;
        int total = allControls.length;
        int i = 0;
        while (i < total) {
            control = allControls[i];
            data = this.getLayoutData(control);
            if (!data.exclude) {
                int adjustableWidth;
                controlIndex = count++;
                controls[controlIndex] = control;
                Point size = data.computeSize(control, data.minorAlignment == 4 ? this.getWidth(-1, childHeightHint) : -1, data.minorAlignment == 4 ? this.getHeight(-1, childHeightHint) : -1, flushCache);
                prefHeights[controlIndex] = this.getHeight(size);
                prefWidths[controlIndex] = cellWidths[controlIndex] = this.getWidth(size);
                actualHeight = Math.max(actualHeight, prefHeights[controlIndex]);
                actualWidth += cellWidths[controlIndex];
                if (data.expandable) {
                    int n = adjustableWidth = data.hardMaximum == 0 ? Integer.MAX_VALUE : data.hardMaximum - Math.max(prefWidths[controlIndex], data.softMaximum);
                    if (adjustableWidth > 0) {
                        hardExpandables.add(new Adjustable(controlIndex, adjustableWidth));
                    }
                    int n2 = adjustableWidth = data.softMaximum == 0 ? Integer.MAX_VALUE : data.softMaximum - prefWidths[controlIndex];
                    if (adjustableWidth > 0) {
                        adjustPriority = data.expandPriority;
                        adjustableSet = (TreeSet<Adjustable>)softExpandables.get(adjustPriority);
                        if (adjustableSet == null) {
                            adjustableSet = new TreeSet<Adjustable>();
                            softExpandables.put((Integer)adjustPriority, (TreeSet<Adjustable>)adjustableSet);
                        }
                        adjustableSet.add(new Adjustable(controlIndex, adjustableWidth));
                    }
                }
                if (data.shrinkable) {
                    adjustableWidth = Math.min(prefWidths[controlIndex], data.softMinimum) - Math.max(0, data.hardMinimum);
                    if (adjustableWidth > 0) {
                        hardShrinkables.add(new Adjustable(controlIndex, adjustableWidth));
                    }
                    if ((adjustableWidth = prefWidths[controlIndex] - Math.max(0, data.softMinimum)) > 0) {
                        adjustPriority = data.shrinkPriority;
                        adjustableSet = (SortedSet)softShrinkables.get(adjustPriority);
                        if (adjustableSet == null) {
                            adjustableSet = new TreeSet();
                            softShrinkables.put(adjustPriority, adjustableSet);
                        }
                        adjustableSet.add(new Adjustable(controlIndex, adjustableWidth));
                    }
                }
            }
            ++i;
        }
        actualHeight += this.getHeight(this.marginWidth, this.marginHeight) * 2 + this.getHeight(this.marginLeft, this.marginTop) + this.getHeight(this.marginRight, this.marginBottom);
        if (wHint >= 0 && wHint != (actualWidth += this.getWidth(this.marginWidth, this.marginHeight) * 2 + this.getWidth(this.marginLeft, this.marginTop) + this.getWidth(this.marginRight, this.marginBottom) + this.spacing * (count - 1)) && count > 0) {
            int singleAdjustment;
            int adjustables;
            TreeSet<Adjustable> hardAdjustables;
            HashMap softAdjustables;
            IAdjust adjust;
            int adjustment;
            if (wHint < actualWidth) {
                adjustment = actualWidth - wHint;
                adjust = SHRINK;
                softAdjustables = softShrinkables;
                hardAdjustables = hardShrinkables;
            } else {
                adjustment = wHint - actualWidth;
                adjust = EXPAND;
                softAdjustables = softExpandables;
                hardAdjustables = hardExpandables;
            }
            Object[] adjustPriorities = softAdjustables.keySet().toArray(new Integer[softAdjustables.size()]);
            Arrays.sort(adjustPriorities);
            int i2 = adjustPriorities.length - 1;
            while (i2 >= 0) {
                adjustPriority = adjustPriorities[i2];
                adjustableSet = (SortedSet)softAdjustables.get(adjustPriority);
                if (!adjustableSet.isEmpty()) {
                    adjustables = adjustableSet.size();
                    for (Adjustable adjustable : adjustableSet) {
                        singleAdjustment = Math.min(adjustment / adjustables, adjustable.adjustableWidth);
                        actualWidth = adjust.adjust(actualWidth, singleAdjustment);
                        cellWidths[adjustable.controlIndex] = adjust.adjust(cellWidths[adjustable.controlIndex], singleAdjustment);
                        --adjustables;
                        if ((adjustment -= singleAdjustment) <= 0) break;
                    }
                    if (adjustment <= 0) break;
                }
                --i2;
            }
            if (adjustment > 0) {
                adjustables = hardAdjustables.size();
                for (Adjustable adjustable : hardAdjustables) {
                    singleAdjustment = Math.min(adjustment / adjustables, adjustable.adjustableWidth);
                    actualWidth = adjust.adjust(actualWidth, singleAdjustment);
                    cellWidths[adjustable.controlIndex] = adjust.adjust(cellWidths[adjustable.controlIndex], singleAdjustment);
                    --adjustables;
                    if ((adjustment -= singleAdjustment) <= 0) break;
                }
            }
        }
        if (bounds == null) {
            this.cachedSize = this.direction == 256 ? new Point(actualWidth, actualHeight) : new Point(actualHeight, actualWidth);
        } else {
            void var35_45;
            int gap;
            total = count;
            int x = this.getX(bounds) + this.getWidth(this.marginWidth, this.marginHeight) + this.getWidth(this.marginLeft, this.marginTop);
            int y = this.getY(bounds) + this.getHeight(this.marginWidth, this.marginHeight) + this.getHeight(this.marginLeft, this.marginTop);
            switch (this.alignment) {
                case 1024: 
                case 131072: 
                case 0x1000008: {
                    x += wHint - actualWidth;
                    gap = 0;
                    break;
                }
                case 0x1000000: {
                    x += (wHint - actualWidth) / 2;
                    gap = 0;
                    break;
                }
                case 4: {
                    gap = wHint - actualWidth;
                    break;
                }
                default: {
                    gap = 0;
                }
            }
            boolean bl = false;
            while (var35_45 < total) {
                int controlY;
                int controlHeight;
                int controlX;
                int controlWidth;
                controlIndex = var35_45;
                control = controls[controlIndex];
                data = this.getLayoutData(control);
                switch (data.majorAlignment) {
                    case 1: 
                    case 128: 
                    case 16384: {
                        controlWidth = prefWidths[controlIndex];
                        controlX = x;
                        break;
                    }
                    case 1024: 
                    case 131072: 
                    case 0x1000008: {
                        controlWidth = prefWidths[controlIndex];
                        controlX = x + cellWidths[controlIndex] - controlWidth;
                        break;
                    }
                    case 0x1000000: {
                        controlWidth = prefWidths[controlIndex];
                        controlX = x + (cellWidths[controlIndex] - controlWidth) / 2;
                        break;
                    }
                    default: {
                        controlWidth = cellWidths[controlIndex];
                        controlX = x;
                    }
                }
                switch (data.minorAlignment) {
                    case 1: 
                    case 128: 
                    case 16384: {
                        controlHeight = prefHeights[controlIndex];
                        controlY = y;
                        break;
                    }
                    case 1024: 
                    case 131072: 
                    case 0x1000008: {
                        controlHeight = prefHeights[controlIndex];
                        controlY = y + childHeightHint - controlHeight;
                        break;
                    }
                    case 0x1000000: {
                        controlHeight = prefHeights[controlIndex];
                        controlY = y + (childHeightHint - controlHeight) / 2;
                        break;
                    }
                    default: {
                        controlHeight = childHeightHint;
                        controlY = y;
                    }
                }
                if (this.direction == 256) {
                    control.setBounds(controlX, controlY, controlWidth, controlHeight);
                } else {
                    control.setBounds(controlY, controlX, controlHeight, controlWidth);
                }
                x += cellWidths[controlIndex] + this.spacing;
                if (gap != 0) {
                    int singleGap = gap / (total - var35_45);
                    gap -= singleGap;
                    x += singleGap;
                }
                ++var35_45;
            }
        }
    }

    private int getWidth(Point size) {
        return this.direction == 256 ? size.x : size.y;
    }

    private int getWidth(Rectangle rect) {
        return this.direction == 256 ? rect.width : rect.height;
    }

    private int getWidth(int width, int height) {
        return this.direction == 256 ? width : height;
    }

    private int getHeight(Point size) {
        return this.direction == 256 ? size.y : size.x;
    }

    private int getHeight(Rectangle rect) {
        return this.direction == 256 ? rect.height : rect.width;
    }

    private int getHeight(int width, int height) {
        return this.direction == 256 ? height : width;
    }

    private int getX(Rectangle rect) {
        return this.direction == 256 ? rect.x : rect.y;
    }

    private int getY(Rectangle rect) {
        return this.direction == 256 ? rect.y : rect.x;
    }

    private BellowsData getLayoutData(Control control) {
        Object data = control.getLayoutData();
        if (data == null && !(data instanceof BellowsData)) {
            data = new BellowsData();
            control.setLayoutData(data);
        }
        return (BellowsData)data;
    }

    protected boolean flushCache(Control control) {
        this.cachedSize = null;
        BellowsData data = this.getLayoutData(control);
        data.flushCache();
        return true;
    }

    private static class Adjustable
    implements Comparable<Adjustable> {
        final int controlIndex;
        final int adjustableWidth;

        public Adjustable(int controlIndex, int extraWidth) {
            this.controlIndex = controlIndex;
            this.adjustableWidth = extraWidth;
        }

        @Override
        public int compareTo(Adjustable that) {
            return this.adjustableWidth - that.adjustableWidth;
        }

        public int hashCode() {
            return this.controlIndex ^ this.adjustableWidth;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Adjustable)) {
                return false;
            }
            Adjustable that = (Adjustable)obj;
            return this.controlIndex == that.controlIndex;
        }

        public String toString() {
            return "{controlIndex=" + this.controlIndex + ",adjustableWidth=" + this.adjustableWidth + "}";
        }
    }

    private static interface IAdjust {
        public int adjust(int var1, int var2);
    }
}

