/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IPartListener;
import org.xmind.gef.part.IPartListener2;
import org.xmind.gef.part.IPartSite;
import org.xmind.gef.part.IPartStatus;
import org.xmind.gef.part.PartEvent;
import org.xmind.gef.part.PartRegistry;
import org.xmind.gef.part.PartSite;
import org.xmind.gef.part.PartStatus;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Part
implements IPart {
    private static final List<IPart> EMPTY_CHILDREN = Collections.emptyList();
    private Object model = null;
    private IPart parent = null;
    private List<IPart> children = null;
    private IPartSite site = null;
    private IPartStatus status = null;
    private List<IPartListener> partListeners = null;

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public IPart getParent() {
        return this.parent;
    }

    @Override
    public void setModel(Object model) {
        if (model == this.model) {
            return;
        }
        this.model = model;
    }

    @Override
    public void setParent(IPart parent) {
        if (parent == this) {
            throw new IllegalArgumentException("A part should NOT be set as its own parent.");
        }
        this.parent = parent;
    }

    @Override
    public List<IPart> getChildren() {
        if (this.children == null) {
            return EMPTY_CHILDREN;
        }
        return this.children;
    }

    @Override
    public void addNotify() {
        this.register();
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IPart)o).addNotify();
            ++n2;
        }
        this.refresh();
    }

    @Override
    public void removeNotify() {
        this.getStatus().dePreSelect();
        this.getStatus().deSelect();
        this.getStatus().lostFocus();
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IPart)o).removeNotify();
            ++n2;
        }
        this.unregister();
    }

    protected void addChild(IPart child, int index) {
        if (child == null) {
            return;
        }
        if (child == this) {
            throw new IllegalArgumentException("A part should NOT be added as its own child.");
        }
        this.fireAddingChild(child, index);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList<IPart>();
        }
        this.children.add(index, child);
        child.setParent(this);
        this.addChildView(child, index);
        child.addNotify();
        if (this.getStatus().isActive()) {
            child.getStatus().activate();
        }
        this.fireChildAdded(child, index);
    }

    protected void removeChild(IPart child) {
        if (child == null || child == this) {
            return;
        }
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return;
        }
        this.fireRemovingChild(child, index);
        if (this.getStatus().isActive()) {
            child.getStatus().deactivate();
        }
        child.removeNotify();
        this.removeChildView(child);
        child.setParent(null);
        if (this.children != null && !this.children.isEmpty()) {
            this.children.remove(child);
        }
        this.fireChildRemoved(child, index);
    }

    protected void addChildView(IPart child, int index) {
    }

    protected void removeChildView(IPart child) {
    }

    protected void register() {
    }

    protected void unregister() {
    }

    protected void unregisterModel(Object model) {
        PartRegistry partRegistry = this.getPartRegistry();
        if (partRegistry != null) {
            partRegistry.unregister(model, this);
        }
    }

    protected void registerModel(Object model) {
        PartRegistry partRegistry = this.getPartRegistry();
        if (partRegistry != null) {
            partRegistry.register(model, this);
        }
    }

    protected PartRegistry getPartRegistry() {
        return this.getSite().getPartRegistry();
    }

    @Override
    public void refresh() {
        this.updateView();
        this.refreshChildren();
        this.updateChildren();
    }

    @Override
    public void update() {
        this.updateView();
        this.updateChildren();
    }

    protected void updateView() {
    }

    protected void updateChildren() {
    }

    protected void refreshChildren() {
        IViewer viewer;
        HashMap<Object, IPart> modelToPart = new HashMap<Object, IPart>();
        List<IPart> currentChildren = this.getChildren();
        for (IPart p : currentChildren) {
            modelToPart.put(p.getModel(), p);
        }
        Object[] newModels = this.getModelChildren(this.getModel());
        if (newModels.length > 0 && (viewer = this.getSite().getViewer()) != null) {
            newModels = this.getFilteredModelChildren(viewer, this.getModel(), newModels);
            newModels = this.getSortedModelChildren(viewer, this.getModel(), newModels);
        }
        IPartFactory factory = this.getSite().getPartFactory();
        int i = 0;
        while (i < newModels.length) {
            Object m;
            Object model = newModels[i];
            if (i >= currentChildren.size() || model != (m = currentChildren.get(i).getModel()) && !model.equals(m)) {
                IPart p = (IPart)modelToPart.get(model);
                if (p != null) {
                    this.reorderChild(p, i);
                } else {
                    p = this.createChild(model, factory);
                    this.addChild(p, i);
                }
            }
            ++i;
        }
        Object[] toTrim = currentChildren.toArray();
        while (i < toTrim.length) {
            this.removeChild((IPart)toTrim[i]);
            ++i;
        }
    }

    protected void reorderChild(IPart child, int index) {
        if (this.children == null) {
            return;
        }
        this.removeChildView(child);
        this.children.remove(child);
        this.children.add(index, child);
        this.addChildView(child, index);
    }

    protected IPart createChild(Object modelChild, IPartFactory factory) {
        return factory.createPart(this, modelChild);
    }

    protected Object[] getSortedModelChildren(IViewer viewer, Object model, Object[] modelChildren) {
        ViewerComparator sorter = viewer.getComparator();
        if (sorter != null) {
            sorter.sort((Viewer)viewer, modelChildren);
        }
        return modelChildren;
    }

    protected Object[] getFilteredModelChildren(IViewer viewer, Object model, Object[] modelChildren) {
        ViewerFilter[] filters = viewer.getFilters();
        if (filters != null && filters.length > 0) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter f = viewerFilterArray[n2];
                modelChildren = f.filter((Viewer)viewer, model, modelChildren);
                ++n2;
            }
        }
        return modelChildren;
    }

    protected Object[] getModelChildren(Object model) {
        return new Object[0];
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPartSite.class) {
            return adapter.cast(this.getSite());
        }
        if (adapter == IPartStatus.class) {
            return adapter.cast(this.getStatus());
        }
        if (this.getModel() instanceof IAdaptable) {
            return (T)((IAdaptable)this.getModel()).getAdapter(adapter);
        }
        return null;
    }

    @Override
    public void addPartListener(IPartListener listener) {
        if (this.partListeners == null) {
            this.partListeners = new ArrayList<IPartListener>();
        }
        this.partListeners.add(listener);
    }

    @Override
    public void removePartListener(IPartListener listener) {
        if (this.partListeners != null) {
            this.partListeners.remove(listener);
        }
    }

    protected void fireChildAdded(IPart child, int index) {
        if (this.partListeners != null) {
            PartEvent event = new PartEvent(this, child);
            Object[] objectArray = this.partListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPartListener)listener).childAdded(event);
                ++n2;
            }
        }
    }

    protected void fireRemovingChild(IPart child, int index) {
        if (this.partListeners != null) {
            PartEvent event = new PartEvent(this, child);
            Object[] objectArray = this.partListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPartListener)listener).childRemoving(event);
                ++n2;
            }
        }
    }

    protected void fireAddingChild(IPart child, int index) {
        if (this.partListeners != null) {
            PartEvent event = new PartEvent(this, child);
            Object[] objectArray = this.partListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof IPartListener2) {
                    ((IPartListener2)listener).childAdding(event);
                }
                ++n2;
            }
        }
    }

    protected void fireChildRemoved(IPart child, int index) {
        if (this.partListeners != null) {
            PartEvent event = new PartEvent(this, child);
            Object[] objectArray = this.partListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof IPartListener2) {
                    ((IPartListener2)listener).childRemoved(event);
                }
                ++n2;
            }
        }
    }

    @Override
    public IPartSite getSite() {
        if (this.site == null) {
            this.site = this.createSite();
        }
        return this.site;
    }

    protected IPartSite createSite() {
        return new PartSite(this);
    }

    protected void setSite(IPartSite site) {
        this.site = site;
    }

    @Override
    public IPartStatus getStatus() {
        if (this.status == null) {
            this.status = new PartStatus(this);
            this.status.addStatusListener(new IStatusListener(){

                public void statusChanged(StatusEvent event) {
                    if (event.key == 1) {
                        if (event.newValue) {
                            Part.this.onActivated();
                        } else {
                            Part.this.onDeactivated();
                        }
                    } else {
                        Part.this.handleStatusChanged(event);
                    }
                }
            });
        }
        return this.status;
    }

    protected void handleStatusChanged(StatusEvent event) {
    }

    protected void onActivated() {
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((IPart)o).getStatus().activate();
            ++n2;
        }
    }

    protected void onDeactivated() {
        Object[] objectArray = this.getChildren().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            ((IPart)p).getStatus().deactivate();
            ++n2;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + this.getModel() + "}";
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public void handleRequest(Request request, String role) {
    }
}

