/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Properties;
import org.gradle.util.internal.GUtil;

final class KotlinDslVersion {
    private final String kotlin;

    static KotlinDslVersion current() {
        ClassLoader loader = KotlinDslVersion.class.getClassLoader();
        URL resource = loader.getResource("gradle-kotlin-dsl-versions.properties");
        Preconditions.checkNotNull((Object)resource, (Object)"Gradle Kotlin DSL versions manifest was not found");
        Properties versions = GUtil.loadProperties(resource);
        return new KotlinDslVersion(versions.getProperty("kotlin"));
    }

    private KotlinDslVersion(String kotlin) {
        Preconditions.checkNotNull((Object)kotlin, (Object)"Kotlin version was not found");
        this.kotlin = kotlin;
    }

    String getKotlinVersion() {
        return this.kotlin;
    }
}

