/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.api.types;

import java.util.EnumSet;
import java.util.Set;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptor;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFactory;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorType;

public enum BytecodeInterceptorFilter {
    INSTRUMENTATION_ONLY(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION)),
    ALL(EnumSet.of(BytecodeInterceptorType.INSTRUMENTATION, BytecodeInterceptorType.BYTECODE_UPGRADE));

    private final Set<BytecodeInterceptorType> instrumentationTypes;

    private BytecodeInterceptorFilter(Set<BytecodeInterceptorType> instrumentationTypes) {
        this.instrumentationTypes = instrumentationTypes;
    }

    public boolean matches(BytecodeInterceptor bytecodeInterceptor) {
        return this.instrumentationTypes.contains((Object)bytecodeInterceptor.getType());
    }

    public boolean matches(BytecodeInterceptorFactory bytecodeInterceptorFactory) {
        return this.instrumentationTypes.contains((Object)bytecodeInterceptorFactory.getType());
    }
}

