/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ProblemReport;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.plugin.devel.tasks.internal.ValidateAction;
import org.gradle.plugin.devel.tasks.internal.ValidationProblemSerialization;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ValidatePlugins
extends DefaultTask {
    public ValidatePlugins() {
        this.getEnableStricterValidation().convention((Object)false);
        this.getIgnoreFailures().convention((Object)false);
        this.getFailOnWarning().convention((Object)true);
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().findByType(JavaToolchainService.class);
        if (service != null) {
            this.getLauncher().convention(service.launcherFor(spec -> {}));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public void validateTaskClasses() throws IOException {
        this.getWorkerExecutor().processIsolation(spec -> {
            if (this.getLauncher().isPresent()) {
                spec.getForkOptions().setExecutable((Object)((JavaLauncher)this.getLauncher().get()).getExecutablePath());
            } else {
                ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Using task ValidatePlugins without applying the Java Toolchain plugin.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "validate_plugins_without_java_toolchain")).nagUser();
                spec.getForkOptions().setExecutable((Object)Jvm.current().getJavaExecutable());
            }
            spec.getClasspath().setFrom(new Object[]{this.getClasses(), this.getClasspath()});
        }).submit(ValidateAction.class, params -> {
            params.getClasses().setFrom((Iterable)this.getClasses());
            params.getOutputFile().set((Provider)this.getOutputFile());
            params.getEnableStricterValidation().set(this.getEnableStricterValidation());
        });
        this.getWorkerExecutor().await();
        List<? extends ProblemReport> problems = ValidationProblemSerialization.parseMessageList(new String(Files.readAllBytes(((RegularFile)this.getOutputFile().get()).getAsFile().toPath())));
        Stream<String> messages = ValidationProblemSerialization.toPlainMessage(problems).sorted();
        if (problems.isEmpty()) {
            this.getLogger().info("Plugin validation finished without warnings.");
            return;
        }
        if (!((Boolean)this.getFailOnWarning().get()).booleanValue() && !problems.stream().anyMatch(problem -> problem.getDefinition().getSeverity() == Severity.ERROR)) {
            this.getLogger().warn("Plugin validation finished with warnings:{}", (Object)messages.collect(Collectors.joining()));
            return;
        }
        if (((Boolean)this.getIgnoreFailures().get()).booleanValue()) {
            this.getLogger().warn("Plugin validation finished with errors. {} {}", (Object)this.annotateTaskPropertiesDoc(), (Object)messages.collect(Collectors.joining()));
            return;
        }
        this.reportProblems(problems);
        throw WorkValidationException.forProblems((Collection)((Collection)messages.collect(ImmutableList.toImmutableList()))).withSummaryForPlugin().getWithExplanation(this.annotateTaskPropertiesDoc());
    }

    private void reportProblems(List<? extends ProblemReport> problems) {
        InternalProblemReporter reporter = ((InternalProblems)this.getServices().get(InternalProblems.class)).getInternalReporter();
        problems.stream().map(ProblemReport.class::cast).map(problem -> problem.toBuilder().label(TypeValidationProblemRenderer.introductionFor((Map)problem.getContext().getAdditionalData()) + problem.getDefinition().getLabel()).build()).forEach(arg_0 -> ((InternalProblemReporter)reporter).report(arg_0));
    }

    private String annotateTaskPropertiesDoc() {
        return this.getDocumentationRegistry().getDocumentationRecommendationFor("on how to annotate task properties", "incremental_build", "sec:task_input_output_annotations");
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Nested
    @Optional
    @Incubating
    public abstract Property<JavaLauncher> getLauncher();

    @Input
    public abstract Property<Boolean> getIgnoreFailures();

    @Input
    public abstract Property<Boolean> getFailOnWarning();

    @Input
    public abstract Property<Boolean> getEnableStricterValidation();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();
}

