/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.ProblemCategory;
import org.gradle.api.problems.internal.ProblemDefinition;

@NonNullApi
public class DefaultProblemDefinition
implements Serializable,
ProblemDefinition {
    private final String label;
    private Severity severity;
    private final DocLink documentationLink;
    private final List<String> solutions;
    private final ProblemCategory problemCategory;

    DefaultProblemDefinition(String label, Severity severity, @Nullable DocLink documentationUrl, @Nullable List<String> solutions, ProblemCategory problemCategory) {
        this.label = label;
        this.severity = severity;
        this.documentationLink = documentationUrl;
        this.solutions = solutions == null ? ImmutableList.of() : ImmutableList.copyOf(solutions);
        this.problemCategory = problemCategory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public DocLink getDocumentationLink() {
        return this.documentationLink;
    }

    @Override
    public List<String> getSolutions() {
        return this.solutions;
    }

    @Override
    public ProblemCategory getCategory() {
        return this.problemCategory;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    private static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblemDefinition that = (DefaultProblemDefinition)o;
        return DefaultProblemDefinition.equals(this.label, that.label) && this.severity == that.severity && DefaultProblemDefinition.equals(this.problemCategory, that.problemCategory) && DefaultProblemDefinition.equals(this.documentationLink, that.documentationLink) && DefaultProblemDefinition.equals(this.solutions, that.solutions);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.label, this.severity, this.documentationLink, this.solutions});
    }
}

