/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.component.ResolutionFailureHandler;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class GraphVariantSelector {
    private final ResolutionFailureHandler failureProcessor;

    public GraphVariantSelector(ResolutionFailureHandler failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public ResolutionFailureHandler getFailureProcessor() {
        return this.failureProcessor;
    }

    public GraphVariantSelectionResult selectVariants(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        return this.selectVariants(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, false, AttributeMatchingExplanationBuilder.logging());
    }

    public GraphVariantSelectionResult selectVariantsLenient(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        return this.selectVariants(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, true, AttributeMatchingExplanationBuilder.logging());
    }

    private GraphVariantSelectionResult selectVariants(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts, boolean allowNoMatchingVariants, AttributeMatchingExplanationBuilder explanationBuilder) {
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        GraphSelectionCandidates candidates = targetComponentState.getCandidatesForGraphVariantSelection();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
        boolean variantAware = candidates.isUseVariants();
        if (!variantAware) {
            return this.selectDefaultConfiguration(consumerAttributes, consumerSchema, targetComponent, attributeMatcher, candidates);
        }
        List<? extends VariantGraphResolveState> allConsumableVariants = candidates.getVariants();
        ImmutableList<VariantGraphResolveState> variantsProvidingRequestedCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, allConsumableVariants, true);
        if (variantsProvidingRequestedCapabilities.isEmpty()) {
            throw this.failureProcessor.noMatchingCapabilitiesFailure(consumerSchema, attributeMatcher, consumerAttributes, targetComponent, explicitRequestedCapabilities, allConsumableVariants);
        }
        List<VariantGraphResolveState> matches = attributeMatcher.matches(variantsProvidingRequestedCapabilities, (AttributeContainerInternal)consumerAttributes, explanationBuilder);
        if (matches.size() > 1) {
            List<VariantGraphResolveState> sameClassifier;
            String classifier;
            Object strictlyMatchingCapabilities = this.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, matches, false);
            if (strictlyMatchingCapabilities.size() == 1) {
                return this.singleVariant(true, (List<VariantGraphResolveState>)strictlyMatchingCapabilities);
            }
            if (strictlyMatchingCapabilities.size() > 1 && (strictlyMatchingCapabilities = attributeMatcher.matches(strictlyMatchingCapabilities, (AttributeContainerInternal)consumerAttributes, explanationBuilder)).size() == 1) {
                return this.singleVariant(true, (List<VariantGraphResolveState>)strictlyMatchingCapabilities);
            }
            if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = this.findVariantsProvidingExactlySameClassifier(matches, classifier)) != null && sameClassifier.size() == 1) {
                return this.singleVariant(true, sameClassifier);
            }
        }
        if (matches.size() == 1) {
            return this.singleVariant(true, matches);
        }
        if (!matches.isEmpty()) {
            if (explanationBuilder instanceof TraceDiscardedConfigurations) {
                throw this.failureProcessor.ambiguousGraphVariantsFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, matches, targetComponent);
            }
            return this.selectVariants(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, allowNoMatchingVariants, new TraceDiscardedConfigurations());
        }
        if (allowNoMatchingVariants) {
            return new GraphVariantSelectionResult(Collections.emptyList(), true);
        }
        throw this.failureProcessor.noMatchingGraphVariantFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, targetComponent, candidates);
    }

    private GraphVariantSelectionResult selectDefaultConfiguration(ImmutableAttributes consumerAttributes, AttributesSchemaInternal consumerSchema, ComponentGraphResolveMetadata targetComponent, AttributeMatcher attributeMatcher, GraphSelectionCandidates candidates) {
        ConfigurationGraphResolveState fallbackConfiguration = candidates.getLegacyConfiguration();
        if (fallbackConfiguration != null && fallbackConfiguration.getMetadata().isCanBeConsumed() && attributeMatcher.isMatching((AttributeContainerInternal)fallbackConfiguration.getAttributes(), (AttributeContainerInternal)consumerAttributes)) {
            return this.singleVariant(candidates.isUseVariants(), (List<VariantGraphResolveState>)ImmutableList.of((Object)fallbackConfiguration.asVariant()));
        }
        throw this.failureProcessor.noMatchingGraphVariantFailure(consumerSchema, attributeMatcher, (AttributeContainerInternal)consumerAttributes, targetComponent, candidates);
    }

    @Nullable
    private List<VariantGraphResolveState> findVariantsProvidingExactlySameClassifier(List<VariantGraphResolveState> matches, String classifier) {
        ArrayList sameClassifier = null;
        for (VariantGraphResolveState match : matches) {
            ComponentArtifactMetadata componentArtifactMetadata;
            List<? extends ComponentArtifactMetadata> artifacts = match.resolveArtifacts().getArtifacts();
            if (artifacts.size() != 1 || !((componentArtifactMetadata = artifacts.get(0)) instanceof ModuleComponentArtifactMetadata) || !classifier.equals(componentArtifactMetadata.getName().getClassifier())) continue;
            if (sameClassifier == null) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private GraphVariantSelectionResult singleVariant(boolean variantAware, List<VariantGraphResolveState> matches) {
        assert (matches.size() == 1);
        VariantGraphResolveState match = matches.get(0);
        VariantGraphResolveMetadata matchMetadata = matches.get(0).getMetadata();
        if (matchMetadata instanceof ConfigurationGraphResolveMetadata && ((ConfigurationGraphResolveMetadata)matchMetadata).isDeprecatedForConsumption()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration((String)matchMetadata.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("declaring_dependencies", "sec:deprecated-configurations")).nagUser();
        }
        return new GraphVariantSelectionResult((List<? extends VariantGraphResolveState>)ImmutableList.of((Object)match), variantAware);
    }

    private ImmutableList<VariantGraphResolveState> filterVariantsByRequestedCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, Collection<? extends VariantGraphResolveState> consumableVariants, boolean lenient) {
        if (consumableVariants.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableVariants.size());
        boolean explicitlyRequested = !explicitRequestedCapabilities.isEmpty();
        ModuleIdentifier moduleId = targetComponent.getModuleVersionId().getModule();
        for (VariantGraphResolveState variantGraphResolveState : consumableVariants) {
            ImmutableCapabilities capabilities = variantGraphResolveState.getCapabilities();
            MatchResult result = explicitlyRequested ? this.providesAllCapabilities(targetComponent, explicitRequestedCapabilities, capabilities) : this.containsImplicitCapability(capabilities, moduleId.getGroup(), moduleId.getName());
            if (!result.matches || !lenient && result != MatchResult.EXACT_MATCH) continue;
            builder.add((Object)variantGraphResolveState);
        }
        return builder.build();
    }

    private MatchResult providesAllCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, ImmutableCapabilities providerCapabilities) {
        ImmutableSet<ImmutableCapability> providerCapabilitiesSet = providerCapabilities.asSet();
        if (providerCapabilitiesSet.isEmpty() && explicitRequestedCapabilities.size() == 1) {
            Capability requested = explicitRequestedCapabilities.iterator().next();
            ModuleVersionIdentifier moduleVersionIdentifier = targetComponent.getModuleVersionId();
            if (requested.getGroup().equals(moduleVersionIdentifier.getGroup()) && requested.getName().equals(moduleVersionIdentifier.getName())) {
                return MatchResult.EXACT_MATCH;
            }
        }
        for (Capability capability : explicitRequestedCapabilities) {
            String requestedGroup = capability.getGroup();
            String requestedName = capability.getName();
            boolean found = false;
            for (Capability provided : providerCapabilitiesSet) {
                if (!provided.getGroup().equals(requestedGroup) || !provided.getName().equals(requestedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        boolean exactMatch = explicitRequestedCapabilities.size() == providerCapabilitiesSet.size();
        return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
    }

    private MatchResult containsImplicitCapability(ImmutableCapabilities capabilities, String group, String name) {
        ImmutableSet<ImmutableCapability> capabilitiesSet = capabilities.asSet();
        if (GraphVariantSelector.fastContainsImplicitCapability(capabilitiesSet)) {
            return MatchResult.EXACT_MATCH;
        }
        for (Capability capability : capabilitiesSet) {
            if (!group.equals((capability = this.unwrap(capability)).getGroup()) || !name.equals(capability.getName())) continue;
            boolean exactMatch = capabilitiesSet.size() == 1;
            return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
        }
        return MatchResult.NO_MATCH;
    }

    private static boolean fastContainsImplicitCapability(ImmutableSet<ImmutableCapability> capabilities) {
        if (capabilities.isEmpty()) {
            return true;
        }
        return capabilities.size() == 1 && capabilities.iterator().next() instanceof ShadowedCapability;
    }

    private Capability unwrap(Capability capability) {
        if (capability instanceof ShadowedCapability) {
            return ((ShadowedCapability)capability).getShadowedCapability();
        }
        return capability;
    }

    private static class TraceDiscardedConfigurations
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = new HashSet<HasAttributes>();

        private TraceDiscardedConfigurations() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }

    private static enum MatchResult {
        NO_MATCH(false),
        MATCHES_ALL(true),
        EXACT_MATCH(true);

        private final boolean matches;

        private MatchResult(boolean match) {
            this.matches = match;
        }
    }
}

