/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;

public final class CapabilitiesDescriber {
    private CapabilitiesDescriber() {
    }

    public static String describeCapabilitiesWithTitle(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> capabilities) {
        StringBuilder sb = new StringBuilder("capabilit");
        if (capabilities.size() > 1) {
            sb.append("ies ");
            sb.append(CapabilitiesDescriber.describeCapabilities(targetComponent, capabilities));
        } else {
            sb.append("y ").append(CapabilitiesDescriber.describeCapabilities(targetComponent, capabilities));
        }
        return sb.toString();
    }

    public static String describeCapabilities(ComponentGraphResolveMetadata target, Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            ModuleVersionIdentifier mvi = target.getModuleVersionId();
            return CapabilitiesDescriber.describeCapability((Capability)new DefaultImmutableCapability(mvi.getGroup(), mvi.getName(), mvi.getVersion()));
        }
        return capabilities.stream().map(CapabilitiesDescriber::describeCapability).sorted().collect(Collectors.joining(" and "));
    }

    private static String describeCapability(Capability c) {
        String version = c.getVersion();
        if (version != null) {
            return c.getGroup() + ":" + c.getName() + ":" + c.getVersion();
        }
        return c.getGroup() + ":" + c.getName();
    }
}

