
/* AWE32 Routines                                                   */
/* January 17, 1996                                                 */
/* Coded by Vincent Vu                                              */
/* Copyright (c) 1996 Vincent Vu                                    */
/* All rights reserved.                                             */
/*                                                                  */
/* If you use these routines, you must acknowledge the author.      */
/* Do not redistribute modified versions without the permission of  */
/* the author.                                                      */

#ifndef BYTE
	#define BYTE unsigned char
#endif

#ifndef WORD
	#define WORD unsigned int
#endif

#ifndef DWORD
	#define DWORD unsigned long
#endif


/* MACRO awe32RegIndex(index)                                       */
/* In:  Index to write to EMU8000 Index Port                        */
/* Out: None                                                        */

#define awe32RegIndex(index) outport(awe32BaseAddx[2]+2, index);

/* WORD awe32BaseAddx[3]                                            */
/* Base addresses of all three ports of the EMU8000                 */

WORD awe32BaseAddx[3];


/* void awe32RegW(WORD index, WORD port, WORD data)                 */
/* In:  WORD index			Index of register                        */
/*      WORD port				Port to write								     */
/*      WORD data    		Data to write                            */
/* Out: None																		  */

void awe32RegW(WORD index, WORD port, WORD data) {

	awe32RegIndex(index);
	outport(port, data);
	return;
}


/* void awe32RegDW(WORD index, WORD port, DWORD long data)          */
/* In:  WORD index     		Index of register                        */
/*      WORD port				Port to write								     */
/*      DWORD data    		Data to write                            */
/* Out: None																		  */

void awe32RegDW(WORD index, WORD port, DWORD data) {

	awe32RegIndex(index);
	outport(port, data&0xFFFF);
	outport(port+2, data>>16);
	return;
}


/* WORD awe32RegRW(WORD index, WORD port)          				     */
/* In:  WORD index  			Index of register                        */
/*      WORD port				Port to read			    					  */
/* Out: WORD  	         	Data read from register                  */

WORD awe32RegRW(WORD index, WORD port) {

	awe32RegIndex(index);
	return	inport(port);

}


/* DWORD awe32RegRDW(WORD index, WORD port)                         */
/* In:  WORD index     		Index of register                        */
/*      WORD port				Port to read			  				        */
/* Out: DWORD					Data read from register                  */

DWORD awe32RegRDW(WORD index, WORD port) {

	awe32RegIndex(index);
	return	((DWORD) inport(port)) |
                                ((DWORD) inport((port+2))<<16);

}


/* int awe32Detect(WORD BaseAddx)                                   */
/* In:  WORD BaseAddx		Base address of EMU8000                  */
/* Out: int						Returns 0 if detected                    */
/*                     		Returns 1 if not detected                */

int awe32Detect(WORD BaseAddx) {

	awe32BaseAddx[0] = BaseAddx;
	awe32BaseAddx[1] = BaseAddx+0x400;
	awe32BaseAddx[2] = BaseAddx+0x800;


	awe32RegRW(224, awe32BaseAddx[2]);
	if(
		((awe32RegRW(224, awe32BaseAddx[2])& 0x0f) == 0x0c) &&
		((awe32RegRW(61,  awe32BaseAddx[1])& 0x7e) == 0x58) &&
		((awe32RegRW(62,  awe32BaseAddx[1])& 0x03) == 0x03)
	)
		return	0;

	awe32BaseAddx[0] = BaseAddx+4;
	awe32BaseAddx[1] = BaseAddx+8;
	awe32BaseAddx[2] = BaseAddx+12;

	awe32RegRW(224, awe32BaseAddx[2]);
	if(
		((awe32RegRW(224, awe32BaseAddx[2])& 0x0f) == 0x0c) &&
		((awe32RegRW(61,  awe32BaseAddx[1])& 0x7e) == 0x58) &&
		((awe32RegRW(62,  awe32BaseAddx[1])& 0x03) == 0x03)
	)
		return	0;

	return		1;
}


/* void awe32SetVolume(BYTE oscillator, WORD volume)                */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE volume        The volume (0-65535)                     */
/* Out: None                                                        */

void awe32SetVolume(BYTE oscillator, WORD volume) {

	asm {
		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 96
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x802
		in		ax, dx
		out	dx, ax
		add	dx, 2
		mov	ax, word ptr volume
		out	dx, ax
	}
	return;
}


/* void awe32SetFilter(BYTE oscillator, WORD filter)                */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE filter        The filter cutoff frequency (0-65535)    */
/* Out: None                                                        */

void awe32SetFilter(BYTE oscillator, WORD filter) {

	asm {
		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 96
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x802
		in		ax, dx
		mov	ax, word ptr filter
		out	dx, ax
		add	dx, 2
		in		ax, dx
		out	dx, ax
	}
	return;
}


/* void awe32SetFilterQ(BYTE oscillator, BYTE filterq)              */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE filterq       The FilterQ (0-15)                       */
/* Out: None                                                        */

void awe32SetFilterQ(BYTE oscillator, BYTE filterq) {

	asm {
		xor	ch, ch
		mov	ch, filterq
		shl	ch, 4

		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 0
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x402
		in		ax, dx
		out	dx, ax
		add	dx, 2
		in		ax, dx
		mov	ah, ch
		out	dx, ax
	}
	return;
}


/* void awe32SetPan(BYTE oscillator, BYTE pan)                      */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE pan           The pan level (0-255)                    */
/* Out: None                                                        */

void awe32SetPan(BYTE oscillator, BYTE pan) {

	asm {
		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 192
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x802
		in		ax, dx
		out	dx, ax
		add	dx, 2
		in		ax, dx
		mov	ah, pan
		out	dx, ax
	}
	return;
}


/* void awe32SetReverb(BYTE oscillator, BYTE reverb)                */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE reverb        The reverb send level (0-255)            */
/* Out: None                                                        */

void awe32SetReverb(BYTE oscillator, BYTE reverb) {

	asm {
		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 32
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x802
		in		ax, dx
		mov	ah, reverb
		out	dx, ax
		add	dx, 2
		in		ax, dx
		out	dx, ax
	}
	return;
}


/* void awe32SetChorus(BYTE oscillator, BYTE chorus)                */
/* In:  BYTE oscillator		The oscillator number (0-31)				  */
/*      BYTE chorus        The chorus send level (0-255)            */
/* Out: None                                                        */

void awe32SetChorus(BYTE oscillator, BYTE chorus) {

	asm {
		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 224
		or		al, oscillator
		out	dx, ax

		sub	dx, 0x802
		in		ax, dx
		out	dx, ax
		add	dx, 2
		in		ax, dx
		mov	ah, chorus
		out	dx, ax
	}
	return;
}


/* void awe32EnableEG(void)                                         */
/* In:  None                                                        */
/* Out: None                                                        */

void awe32EnableEG(void) {

	BYTE i;

	for(i=0; i<32; i++)
		awe32RegW(160|i, awe32BaseAddx[1], 0x807F);

	return;
}


/* void awe32DisableEG(void)                                        */
/* In:  None                                                        */
/* Out: None                                                        */

void awe32DisableEG(void) {

	BYTE i;

	for(i=0; i<32; i++)
		awe32RegW(160|i, awe32BaseAddx[1], 0x0080);

	return;
}


/* void awe32EnableFM(void)                                         */
/* In:  None                                                        */
/* Out: None                                                        */

void awe32EnableFM(void) {

	awe32RegW(160|30, awe32BaseAddx[1], 0x0080);
	awe32RegDW(192|30, awe32BaseAddx[0], 0xFFFFFFE0);
	awe32RegDW(224|30, awe32BaseAddx[0], 0x00FFFFE8);
	awe32RegDW( 32|30, awe32BaseAddx[0], 0x00000000);
	awe32RegDW(  0|30, awe32BaseAddx[0], 0x00000000);
	awe32RegDW(  0|30, awe32BaseAddx[1], 0x00FFFFE3);

	awe32RegW(160|31, awe32BaseAddx[1], 0x0080);
	awe32RegDW(192|31, awe32BaseAddx[0], 0x00FFFFF0);
	awe32RegDW(224|31, awe32BaseAddx[0], 0x00FFFFF8);
	awe32RegDW( 32|31, awe32BaseAddx[0], 0x000000FF);
	awe32RegDW(  0|31, awe32BaseAddx[0], 0x00008000);
	awe32RegDW(  0|31, awe32BaseAddx[1], 0x00FFFFF3);

	awe32RegIndex(32|30);
	outport(awe32BaseAddx[0], 0x0000);

	while(!(inport(awe32BaseAddx[2]+2)&0x1000));
	while( (inport(awe32BaseAddx[2]+2)&0x1000));

	outport(awe32BaseAddx[0]+2, 0x4828);

	awe32RegW( 32|28, awe32BaseAddx[1], 0x0000);
	awe32RegDW( 96|30, awe32BaseAddx[0], 0xFFFFFFFF);
	awe32RegDW( 96|31, awe32BaseAddx[0], 0xFFFFFFFF);

	return;
}


/* void awe32DisableFM(void)                                        */
/* In:  None                                                        */
/* Out: None                                                        */

void awe32DisableFM(void) {

	awe32RegW(160|30, awe32BaseAddx[1], 0x807F);
	awe32RegW(160|31, awe32BaseAddx[1], 0x807F);

	return;
}

