/***************************************************
* RFX.C  -- This is quite a mess of code.          *
*           I was not into "good" coding practices *
*           when this was written.                 *
*           Not very portable, and will only       *
*           compile under Borland C and Turbo C.   *
*                                                  *
*           BTW the included executable, was not   *
*           compiled from this source.  However    *
*           the only thing changed is the closing  *
*           message.                               *
*                                                  *
*           Vince Vu (vincev@uclink4.berkeley.edu) *
*                     Formerly: jdredd@netcom.com  *
***************************************************/

#define RFXVERSION ".50b"

#define SB16FREQ 44100
#define AWE32FREQ 0x4000*SB16FREQ/44100

#define AWEBUFLEN 131072

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <process.h>
#include "awe32.h"
#include "sb16.h"
#include "rfxgui.c"
#include "rfxmsg.c"

unsigned delaylen=1024;
int far *buffer;
unsigned boff=0, start=0;
unsigned long woffset=0x200000;

int p_sample=0;

void interrupt (*oldsbhandler)();
void interrupt sbhandler() {

	unsigned i;

	asm {
	/* Disable Interrupts */
		cli;
	/* Acknowledge DSP */
		mov	dx, word ptr sb16BaseAddx
		or		dx, 0xf
		in		al, dx
	}

	for(i=0; i<delaylen; i++) {
		if(distortion)
			buffer[i+boff] += p_sample*distortion;
		p_sample = buffer[i+boff];
	}

	/* Check if end of buffer */
	/* If so, add 3 redundant samples */
	if(woffset >= (AWEBUFLEN+0x200000)) {
		asm {
			push	ds

			mov	dx, word ptr awe32BaseAddx+4
			add	dx, 2
			mov	ax, 58
			out	dx, ax
			sub	dx, 0x402
			mov	cx, 3

			mov	ax, boff
			shl	ax, 1
			add	ax, word ptr buffer
			mov	si, ax
			mov	ax, word ptr buffer+2
			mov	ds, ax

			cld
			repe	outsw
			pop	ds

			add	dx, 0x402
			mov	ax, 54
			out	dx, ax
			sub	dx, 0x402
			xor	ax, ax
			out	dx, ax
			mov	ax, 0x20
			add	dx, 2
			out	dx, ax
			mov	word ptr woffset, 0x0000
			mov	word ptr woffset+2, 0x20
		}
	}

	/* Stream buffer */
	asm {
		push	ds

		mov	dx, word ptr awe32BaseAddx+4
		add	dx, 2
		mov	ax, 58
		out	dx, ax
		sub	dx, 0x402
		mov	cx, word ptr delaylen

		mov	ax, boff
		shl	ax, 1
		add	ax, word ptr buffer
		mov	si, ax
		mov	ax, word ptr buffer+2
		mov	ds, ax

		cld
		repe	outsw
		pop	ds

	}
	woffset += delaylen;

	/* Check delay */
	if(!start) {
		asm {
			mov	dx, word ptr awe32BaseAddx+4
			add	dx, 2
			mov	ax, 32
			out	dx, ax
			sub	dx, 0x802
			in		ax, dx
			out	dx, ax
			add	dx, 2
			mov	ax, AWE32FREQ
			out	dx, ax
		}
					 start = 1;
	}

	/* Check buffer offset */
	asm {
		and	word ptr boff, 0xFFFF
		jnz	NZBuffer
		mov	ax, word ptr delaylen
		mov	word ptr boff, ax
		jmp	NZBufferSkip
	}
	NZBuffer:
	asm {
		mov	word ptr boff, 0x0000
	}
	NZBufferSkip:

	/* Acknowledge PIC */
	asm {
		mov	al, 0x20
		out	0x20, al
		cmp	word ptr sb16IRQ, 7
		jz		HiPICSkip
		out	0xa0, al
	}
	HiPICSkip:

	/* Enable Interrupts */
	asm {
		sti;
	}

	return;
}

void InitAWE32Stream(void) {

	unsigned i;

	/* Init DRAM Write */
	for(i=1; i<32; i++) {

		awe32RegW(160+i, awe32BaseAddx[1], 0x80);		//Disable EG
		awe32RegDW(96+i, awe32BaseAddx[0], 0x00);		//Full off
		awe32RegDW(64+i, awe32BaseAddx[0], 0x00);
		awe32RegDW(192+i, awe32BaseAddx[0], 0x00);
		awe32RegDW(224+i, awe32BaseAddx[0], 0x00);
		awe32RegDW(32+i, awe32BaseAddx[0], 0x40000000);
		awe32RegDW(i, awe32BaseAddx[0], 0x40000000);
		awe32RegDW(i, awe32BaseAddx[1], 0x6000000);	//Write mode
	}
	awe32RegDW(54, awe32BaseAddx[1], 0x200000);	//Write offset

	/* Init Playback */
	awe32RegDW(0, awe32BaseAddx[0], 0x00000000);
	awe32RegW(160, awe32BaseAddx[1], 0x80);         //Disable EG
	awe32RegDW(0,  awe32BaseAddx[1], 0x00200000);   //Sample offset
	awe32RegDW(32, awe32BaseAddx[0], 0x0000FF80);   //Set Freq|Reverb|Pan
	awe32RegDW(192, awe32BaseAddx[0], 0x80200000);  //Pan|Loop Start
	awe32RegDW(224, awe32BaseAddx[0], 0xFF200000+AWEBUFLEN);

	awe32SetReverb(0, reverb);
	awe32SetChorus(0, chorus);
	awe32SetPan(0, pan);
	awe32SetFilterQ(0, filterq);
	awe32SetFilter(0, filterc);
	awe32SetVolume(0, volume);

	return;
}

void DeInitAWE32Stream(void) {

	unsigned i;

	for(i=0; i<32; i++)
		awe32RegW(160+i, awe32BaseAddx[1], 0x807F);
	return;
}

void InitStream(void) {

	unsigned off, page, poff;
	unsigned long seg, padd;

	seg = FP_SEG(buffer);
	off = FP_OFF(buffer);
	seg <<=4;
	padd = seg+off;
	page = padd>>16;
	poff = ((padd/2)%65536);

	sb16ResetDSP();

	oldsbhandler = getvect(sb16IRQ+8);			//Get old interrupt handler
	setvect(sb16IRQ+8, sbhandler);				//Install new handler

	if(sb16IRQ<8)
		outportb(0x21, inportb(0x21)&(~(1<<sb16IRQ)));
	else
		outportb(0xa1, inportb(0xa1)&(~(1<<(sb16IRQ-8))));

	sb16WriteDSP(0xd3);								//Disable DAC speaker

	disable();										//Disable interrupts

	outportb(0xd4, 0x04 | (sb16HiDMA&3));	//Disable DMA channel
	outportb(0xd8, 0x00);						//Clear byte pointer
	outportb(0xd6, 0x54 | (sb16HiDMA&3));	//Set auto-init record

	outportb(0xc0+((sb16HiDMA&3)*4), poff&0xFF);	//Low address offset
	outportb(0xc0+((sb16HiDMA&3)*4), poff>>8);		//High address offset

	outportb(0xc2+((sb16HiDMA&3)*4), (((delaylen*2)-1))&0xFF);  //Low count offset
	outportb(0xc2+((sb16HiDMA&3)*4), (((delaylen*2)-1))>>8);            //High count offset

	outportb(0x90-sb16HiDMA, page);			//Write page
	outportb(0xd4, 0x00 | (sb16HiDMA&3));	//Enable DMA channel

	enable();					//Enable interrupts

	sb16WriteDSP(0x42);		//Set record frequency
	sb16WriteDSP(SB16FREQ>>8);		//Set MSB 44.1kHz
	sb16WriteDSP(SB16FREQ&0xFF);	//Set LSB 44.1kHz

	sb16WriteDSP(0xbe);		//Auto-init record
	sb16WriteDSP(0x10);		//Signed, mono mode
	sb16WriteDSP((delaylen-1)&0xFF);          //Low count offset
	sb16WriteDSP((delaylen-1)>>8);            //High count offset

	return;
}

void DeInitStream(void) {

	sb16WriteDSP(0xd5);								//Stop recording
	sb16WriteDSP(0xd3);								//Disable DAC speaker

	if(sb16IRQ<8)
		outportb(0x21, inportb(0x21)|(1<<sb16IRQ));
	else
		outportb(0xa1, inportb(0xa1)|(1<<(sb16IRQ-8)));

	setvect(sb16IRQ+8, oldsbhandler);				//Restore old handler

	sb16ResetDSP();
	return;
}

void main(int argc, char *argv[]) {

	if(argc>1) {

		if(!sscanf(argv[1], "%u", &delaylen)) {
			printf("Usage: rfx [delay]\n");
			printf("           [delay] must be within 1 and 16383\n");
			printf("\n");
			printf("ERROR: Invald option: %s\n", argv[1]);
			return;
		}
		if((delaylen>16383)||(!delaylen)) {
			printf("Usage: rfx [delay]\n");
			printf("           [delay] must be within 1 and 16383\n");
			printf("\n");
			printf("ERROR: Option outside of range: %s\n", argv[1]);
			return;
		}
	}

	if(sb16GetEnv()) {
		printf("ERROR: Unable to retrieve BLASTER environment variable!\n");
		return;
	}

	if(sb16Detect(sb16BaseAddx)) {
		printf("ERROR: Unable to detect SB16\n", sb16BaseAddx);
		return;
	}

	if(awe32Detect(0x620)&&
		awe32Detect(0x630)&&
		awe32Detect(0x640)&&
		awe32Detect(0x660)&&
		awe32Detect(0x680)
	) {
		printf("ERROR: Unable to detect AWE32!\n");
		return;
	}
	printf("Sound Blaster 32/AWE32 detected!\n");

	if((buffer = (int far *) farmalloc(delaylen*4+1)) == NULL) {
		printf("ERROR: Unable to allocate memory!\n");
		return;
	}
	if((*buffer)&1)
		(*buffer)++;

	clrscr();
	InitAWE32Stream();
	InitStream();

	RFXGui();

	DeInitStream();
	DeInitAWE32Stream();
	farfree(buffer);

	printf("RFX Beta v%s\n", RFXVERSION);
	printf("Compiled on %s at %s\n", __DATE__, __TIME__);
	printf("Coded by Vince Vu (vincev@uclink4.berkeley.edu formerly:jdredd@netcom.com)\n");
	printf("\n");
	return;
}
