#define MAXCW 1024
#define MAXCB 4

unsigned char keybyte, keyavail=0;
unsigned char shiftflag=0;
unsigned char reverb=0x20, chorus=0x20, pan=0x80, filterq=0;
unsigned filterc=0XFFFF, volume=0XFFFF, distortion=0;

void interrupt (*oldkbhandler)();
void interrupt kbhandler() {

	keybyte = inportb(0x60);

	/* Check if shift was pressed */
	if((keybyte == 42)||(keybyte == 54)) {
		shiftflag = 1;
		keyavail = 0;
	}
	/* Check if shift was released */
	else if((keybyte == 170)||(keybyte == 182)) {
		shiftflag = 0;
		keyavail = 0;
	}
	else {
		keyavail = 1;
	}

	/* Acknowledge PIC */
	asm {
		mov	al, 0x20
		out	0x20, al
	}
	return;
}

void RFXGui(void) {

	oldkbhandler = getvect(0x9);
	setvect(0x9, kbhandler);

init_display:

	
	_setcursortype(_NOCURSOR);
	clrscr();
	gotoxy(20,7);
	cprintf("RFX - Realtime FX Processor - v%s", RFXVERSION);

	gotoxy(20,9);
	cprintf("F1  F2    Volume Level :");
	gotoxy(20,10);
	cprintf("F3  F4    Filter Cutoff:");
	gotoxy(20,11);
	cprintf("F5  F6    Filter Q     :");

	gotoxy(20,13);
	cprintf("F7  F8    Reverb Send  :");
	gotoxy(20,14);
	cprintf("F9  F10   Chorus Send  :");
	gotoxy(20,15);
	cprintf("F11 F12   Pan Level    :");

	gotoxy(20,17);
	cprintf("[   ]     Distortion   :");

	gotoxy(20,19);
	cprintf("[Shift]    Hold down to accelerate");
	gotoxy(20,20);
	cprintf("[D]        Shell to DOS");

update_display:

	gotoxy(46,9);
	cprintf("%05u", volume);
	gotoxy(46,10);
	cprintf("%05u", filterc);
	gotoxy(46,11);
	cprintf("%02u", filterq);

	gotoxy(46,13);
	cprintf("%03u", reverb);
	gotoxy(46,14);
	cprintf("%03u", chorus);
	gotoxy(46,15);
	cprintf("%03u", pan);


	gotoxy(46,17);
	cprintf("%03u", distortion);

	gotoxy(1,1);
waitkey:

	cprintf("\r ");
	if(!keyavail)
	goto waitkey;
	keyavail=0;
	cprintf("\r*");

	/* Parse key */
	switch(keybyte) {

		/* Press d */
		case 32:
			_setcursortype(_NORMALCURSOR);
			setvect(0x9, oldkbhandler);
			clrscr();
			spawnlp(P_WAIT, "C:\\COMMAND.COM", "C:\\COMMAND.COM");
			setvect(0x9, kbhandler);
			goto init_display;

		/* Press F1 */
		case 59:
			if(shiftflag) {
				if(volume<MAXCW)
					volume=0;
				else
					volume-=MAXCW;
			}
			else {
				if(volume>0)
					volume--;
			}
			awe32SetVolume(0, volume);
			break;

		/* Press F2 */
		case 60:
			if(shiftflag) {
				if(volume>(65535-MAXCW))
					volume=65535;
				else
					volume+=MAXCW;
			}
			else {
				if(volume<65535)
					volume++;
			}
			awe32SetVolume(0, volume);
			break;

		/* Press F3 */
		case 61:
			if(shiftflag) {
				if(filterc<MAXCW)
					filterc=0;
				else
					filterc-=MAXCW;
			}
			else {
				if(filterc>0)
					filterc--;
			}
			awe32SetFilter(0, filterc);
			break;

		/* Press F4 */
		case 62:
			if(shiftflag) {
				if(filterc>(65535-MAXCW))
					filterc=65535;
				else
					filterc+=MAXCW;
			}
			else {
				if(filterc<65535)
					filterc++;
			}
			awe32SetFilter(0, filterc);
			break;

		/* Press F5 */
		case 63:
			if(filterq>0)
				filterq--;
			awe32SetFilterQ(0, filterq);
			break;

		/* Press F6 */
		case 64:
			if(filterq<15)
				filterq++;
			awe32SetFilterQ(0, filterq);
			break;

		/* Press F7 */
		case 65:
			if(shiftflag) {
				if(reverb<MAXCB)
					reverb=0;
				else
					reverb-=MAXCB;
			}
			else {
				if(reverb>0)
					reverb--;
			}
			awe32SetReverb(0, reverb);
			break;

		/* Press F8 */
		case 66:
			if(shiftflag) {
				if(reverb>(255-MAXCB))
					reverb=255;
				else
					reverb+=MAXCB;
			}
			else {
				if(reverb<255)
					reverb++;
			}
			awe32SetReverb(0, reverb);
			break;

		/* Press F9 */
		case 67:
			if(shiftflag) {
				if(chorus<MAXCB)
					chorus=0;
				else
					chorus-=MAXCB;
			}
			else {
				if(chorus>0)
					chorus--;
			}
			awe32SetChorus(0, chorus);
			break;

		/* Press F10 */
		case 68:
			if(shiftflag) {
				if(chorus>(255-MAXCB))
					chorus=255;
				else
					chorus+=MAXCB;
			}
			else {
				if(chorus<255)
					chorus++;
			}
			awe32SetChorus(0, chorus);
			break;


		/* Press F11 */
		case 87:
			if(shiftflag) {
				if(pan<MAXCB)
					pan=0;
				else
					pan-=MAXCB;
			}
			else {
				if(pan>0)
					pan--;
			}
			awe32SetPan(0, pan);
			break;

		/* Press F12 */
		case 88:
			if(shiftflag) {
				if(pan>(255-MAXCB))
					pan=255;
				else
					pan+=MAXCB;
			}
			else {
				if(pan<255)
					pan++;
			}
			awe32SetPan(0, pan);
			break;

		/* Press [ */
		case 26:
			if(shiftflag) {
				if(distortion<MAXCB)
					distortion=0;
				else
					distortion-=MAXCB;
			}
			else {
				if(distortion>0)
					distortion--;
			}
			break;

		/* Press ] */
		case 27:
			if(shiftflag) {
				if(distortion>(255-MAXCB))
					distortion=255;
				else
					distortion+=MAXCB;
			}
			else {
				if(distortion<255)
					distortion++;
			}
			break;

		/* Press ESC */
		case 1:
			goto exitgui;

		/* Default */
		default:
			goto waitkey;

	}
	goto update_display;

exitgui:

	_setcursortype(_NORMALCURSOR);
	setvect(0x9, oldkbhandler);
	clrscr();
	return;
}
