/* SB16 Routines                                                   */
/* January 26, 1996                                                 */
/* Coded by Vincent Vu                                              */
/* Copyright (c) 1996 Vincent Vu                                    */
/* All rights reserved.                                             */
/*                                                                  */
/* If you use these routines, you must acknowledge the author.      */
/* Do not redistribute modified versions without the permission of  */
/* the author.                                                      */

#ifndef BYTE
	#define BYTE unsigned char
#endif

#ifndef WORD
	#define WORD unsigned int
#endif

#ifndef DWORD
	#define DWORD unsigned long
#endif

WORD sb16BaseAddx, sb16IRQ, sb16LoDMA, sb16HiDMA, sb16Type, sb16Midi;

int sb16GetEnv(void) {

	char *blastervar;

	if((blastervar = getenv("BLASTER")) == NULL)
		return 1;

	sscanf(blastervar, "A%X I%X D%X H%X T%X E%X P%X",
		&sb16BaseAddx,
		&sb16IRQ,
		&sb16LoDMA,
		&sb16HiDMA,
		&sb16Type,
		&awe32BaseAddx[0],
		&sb16Midi);

	return 0;
}

BYTE sb16ReadDSP(void) {

	while((inportb(sb16BaseAddx|0xe)&0x80));
	return inportb(sb16BaseAddx|0xa);
}

void sb16WriteDSP(BYTE data) {

	while((inportb(sb16BaseAddx|0xc)&0x80));
	outportb(sb16BaseAddx|0xc, data);
	return;
}

int sb16ResetDSP(void) {

	outportb(sb16BaseAddx|0x6, 1);
	delay(10);
	outportb(sb16BaseAddx|0x6, 0);
	delay(10);
	if(
		(inportb(sb16BaseAddx|0xe)& 0x80) &&
		(inportb(sb16BaseAddx|0xa) == 0xaa)
	)
		return 0;
	else
		return 1;
}

int sb16Detect(WORD BaseAddx) {

	sb16BaseAddx = BaseAddx;
	return sb16ResetDSP();

}
