#include <windows.h>

static HANDLE hInst;

int far pascal LibMain(HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
  hInst = hInstance;
  if (wHeapSize > 0) UnlockData(0);
  return 1;
}

static LPSTR findArgLong(LPSTR args, long *l)
{
  BOOL neg;

  while(*args == ' ') args++;
  *l  = 0;
  neg = FALSE;
  if (*args == '-')
  {
    neg = TRUE;
    args++;
  }
  while(*args >= '0' && *args <= '9')
  {
    *l = (*l) * 10 + (*args) - '0';
    args++;
  }
  if (neg) *l = -(*l);
  return args;   
}

static LPSTR findArgHandle(LPSTR args, HANDLE *h)
{
  LPSTR p;
  long  l;

  p  = findArgLong(args, &l);
  *h = (HANDLE) (WORD) l;
  return p;
}

int far pascal __export reverse(LPSTR args)
{
  HANDLE m;
  long   from, to;
  int    huge *sp, huge *ep;
  char   huge *p;
  int    c;

  if (!(args = findArgHandle(args, &m))) return 0;
  if (!(args = findArgLong(args, &from))) return 0;
  if (!(args = findArgLong(args, &to))) return 0;
  if (!m) return 0;

  p = (char huge *) GlobalLock(m);
  if (!p) return 0;
  sp = (int huge *) (p + from);
  ep = (int huge *) (p + to - 1);

  while(sp < ep)
  {
    c   = *sp;
    *sp = *ep;
    *ep = c;
    sp++;
    ep--;
  }
  GlobalUnlock(m);

  return 0;
}

