/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveHandlerImpl;
import freenet.client.ArchiveKey;
import freenet.client.ArchiveRestartException;
import freenet.client.ArchiveStoreContext;
import freenet.client.ArchiveStoreItem;
import freenet.client.ErrorArchiveStoreItem;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.RealArchiveStoreItem;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.support.ExceptionWrapper;
import freenet.support.LRUMap;
import freenet.support.Logger;
import freenet.support.MutableBoolean;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.contrapunctus.lzma.LzmaInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class ArchiveManager {
    public static final String METADATA_NAME = ".metadata";
    private static boolean logMINOR;
    final long maxArchivedFileSize;
    final int maxArchiveHandlers;
    private final LRUMap<FreenetURI, ArchiveStoreContext> archiveHandlers;
    final int maxCachedElements;
    final long maxCachedData;
    private long cachedData;
    private final LRUMap<ArchiveKey, ArchiveStoreItem> storedData;
    private final BucketFactory tempBucketFactory;

    public ArchiveManager(int maxHandlers, long maxCachedData, long maxArchivedFileSize, int maxCachedElements, BucketFactory tempBucketFactory) {
        this.maxArchiveHandlers = maxHandlers;
        this.archiveHandlers = LRUMap.createSafeMap(FreenetURI.FAST_COMPARATOR);
        this.maxCachedElements = maxCachedElements;
        this.maxCachedData = maxCachedData;
        this.storedData = new LRUMap();
        this.maxArchivedFileSize = maxArchivedFileSize;
        this.tempBucketFactory = tempBucketFactory;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    private synchronized void putCached(FreenetURI key, ArchiveStoreContext zip) {
        if (logMINOR) {
            Logger.minor(this, "Put cached AH for " + key + " : " + zip);
        }
        this.archiveHandlers.push(key, zip);
        while (this.archiveHandlers.size() > this.maxArchiveHandlers) {
            this.archiveHandlers.popKey();
        }
    }

    ArchiveStoreContext getCached(FreenetURI key) {
        ArchiveStoreContext handler;
        if (logMINOR) {
            Logger.minor(this, "Get cached AH for " + key);
        }
        if ((handler = this.archiveHandlers.get(key)) == null) {
            return null;
        }
        this.archiveHandlers.push(key, handler);
        return handler;
    }

    synchronized ArchiveStoreContext makeContext(FreenetURI key, ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE ctype, boolean returnNullIfNotFound) {
        ArchiveStoreContext handler = null;
        handler = this.getCached(key);
        if (handler != null) {
            return handler;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        handler = new ArchiveStoreContext(key, archiveType);
        this.putCached(key, handler);
        return handler;
    }

    public ArchiveHandler makeHandler(FreenetURI key, ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE ctype, boolean forceRefetch, boolean persistent) {
        return new ArchiveHandlerImpl(persistent ? key.clone() : key, archiveType, ctype, forceRefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket getCached(FreenetURI key, String filename) throws ArchiveFailureException {
        if (logMINOR) {
            Logger.minor(this, "Fetch cached: " + key + ' ' + filename);
        }
        ArchiveKey k = new ArchiveKey(key, filename);
        ArchiveStoreItem asi = null;
        ArchiveManager archiveManager = this;
        synchronized (archiveManager) {
            asi = this.storedData.get(k);
            if (asi == null) {
                return null;
            }
            this.storedData.push(k, asi);
        }
        if (logMINOR) {
            Logger.minor(this, "Found data");
        }
        return asi.getReaderBucket();
    }

    synchronized void removeCachedItem(ArchiveStoreItem item) {
        long size = item.spaceUsed();
        this.storedData.removeKey(item.key);
        this.cachedData -= size;
        if (logMINOR) {
            Logger.minor(this, "removeCachedItem: " + item);
        }
        item.close();
    }

    public void extractToCache(FreenetURI key, ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE ctype, final Bucket data, ArchiveContext archiveContext, ArchiveStoreContext ctx, String element, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) throws ArchiveFailureException, ArchiveRestartException {
        byte[] expectedHash;
        MutableBoolean gotElement;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        MutableBoolean mutableBoolean = gotElement = element != null ? new MutableBoolean() : null;
        if (logMINOR) {
            Logger.minor(this, "Extracting " + key);
        }
        ctx.removeAllCachedItems(this);
        final long expectedSize = ctx.getLastSize();
        long archiveSize = data.size();
        boolean throwAtExit = false;
        if (expectedSize != -1L && archiveSize != expectedSize) {
            throwAtExit = true;
            ctx.setLastSize(archiveSize);
        }
        if ((expectedHash = ctx.getLastHash()) != null) {
            byte[] realHash;
            try {
                realHash = BucketTools.hash(data);
            }
            catch (IOException e) {
                throw new ArchiveFailureException("Error reading archive data: " + e, e);
            }
            if (!Arrays.equals(realHash, expectedHash)) {
                throwAtExit = true;
            }
            ctx.setLastHash(realHash);
        }
        if (archiveSize > archiveContext.maxArchiveSize) {
            throw new ArchiveFailureException("Archive too big (" + archiveSize + " > " + archiveContext.maxArchiveSize + ")!");
        }
        if (archiveSize <= 0L) {
            throw new ArchiveFailureException("Archive too small! (" + archiveSize + ')');
        }
        if (logMINOR) {
            Logger.minor(this, "Container size (possibly compressed): " + archiveSize + " for " + data);
        }
        InputStream is = null;
        try {
            Exception e;
            ExceptionWrapper wrapper;
            if (ctype == null || ARCHIVE_TYPE.ZIP == archiveType) {
                if (logMINOR) {
                    Logger.minor(this, "No compression");
                }
                is = data.getInputStream();
                wrapper = null;
            } else if (ctype == Compressor.COMPRESSOR_TYPE.BZIP2) {
                if (logMINOR) {
                    Logger.minor(this, "dealing with BZIP2");
                }
                is = new BZip2CompressorInputStream(data.getInputStream());
                wrapper = null;
            } else if (ctype == Compressor.COMPRESSOR_TYPE.GZIP) {
                if (logMINOR) {
                    Logger.minor(this, "dealing with GZIP");
                }
                is = new GZIPInputStream(data.getInputStream());
                wrapper = null;
            } else if (ctype == Compressor.COMPRESSOR_TYPE.LZMA_NEW) {
                PipedInputStream pis = new PipedInputStream();
                final PipedOutputStream pos = new PipedOutputStream();
                pis.connect(pos);
                wrapper = new ExceptionWrapper();
                context.mainExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        InputStream is = null;
                        try {
                            is = data.getInputStream();
                            Compressor.COMPRESSOR_TYPE.LZMA_NEW.decompress(is, pos, data.size(), expectedSize);
                        }
                        catch (CompressionOutputSizeException e) {
                            Logger.error(this, "Failed to decompress archive: " + e, (Throwable)e);
                            wrapper.set(e);
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to decompress archive: " + e, (Throwable)e);
                            wrapper.set(e);
                        }
                        finally {
                            try {
                                pos.close();
                            }
                            catch (IOException e) {
                                Logger.error(this, "Failed to close PipedOutputStream: " + e, (Throwable)e);
                            }
                            Closer.close(is);
                        }
                    }
                });
                is = pis;
            } else if (ctype == Compressor.COMPRESSOR_TYPE.LZMA) {
                if (logMINOR) {
                    Logger.minor(this, "dealing with LZMA");
                }
                is = new LzmaInputStream(data.getInputStream());
                wrapper = null;
            } else {
                wrapper = null;
            }
            if (ARCHIVE_TYPE.ZIP == archiveType) {
                this.handleZIPArchive(ctx, key, is, element, callback, gotElement, throwAtExit, container, context);
            } else if (ARCHIVE_TYPE.TAR == archiveType) {
                this.handleTARArchive(ctx, key, is, element, callback, gotElement, throwAtExit, container, context);
            } else {
                throw new ArchiveFailureException("Unknown or unsupported archive algorithm " + (Object)((Object)archiveType));
            }
            if (wrapper != null && (e = wrapper.get()) != null) {
                throw new ArchiveFailureException("An exception occured decompressing: " + e.getMessage(), e);
            }
        }
        catch (IOException ioe) {
            try {
                throw new ArchiveFailureException("An IOE occured: " + ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                Closer.close(is);
                throw throwable;
            }
        }
        Closer.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTARArchive(ArchiveStoreContext ctx, FreenetURI key, InputStream data, String element, ArchiveExtractCallback callback, MutableBoolean gotElement, boolean throwAtExit, ObjectContainer container, ClientContext context) throws ArchiveFailureException, ArchiveRestartException {
        if (logMINOR) {
            Logger.minor(this, "Handling a TAR Archive");
        }
        TarArchiveInputStream tarIS = null;
        try {
            tarIS = new TarArchiveInputStream(data);
            byte[] buf = new byte[32768];
            HashSet<String> names = new HashSet<String>();
            boolean gotMetadata = false;
            block9: while (true) {
                ArchiveEntry entry;
                try {
                    entry = tarIS.getNextEntry();
                }
                catch (IllegalArgumentException e) {
                    throw new ArchiveFailureException("Error reading archive: " + e.getMessage(), e);
                }
                if (entry == null) break;
                if (entry.isDirectory()) continue;
                String name = this.stripLeadingSlashes(entry.getName());
                if (names.contains(name)) {
                    Logger.error(this, "Duplicate key " + name + " in archive " + key);
                    continue;
                }
                long size = entry.getSize();
                if (name.equals(METADATA_NAME)) {
                    gotMetadata = true;
                }
                if (size > this.maxArchivedFileSize && !name.equals(element)) {
                    this.addErrorElement(ctx, key, name, "File too big: " + size + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
                    continue;
                }
                long realLen = 0L;
                Bucket output = this.tempBucketFactory.makeBucket(size);
                OutputStream out = output.getOutputStream();
                try {
                    int readBytes;
                    while ((readBytes = tarIS.read(buf)) > 0) {
                        out.write(buf, 0, readBytes);
                        if ((long)(readBytes = (int)((long)readBytes + realLen)) <= this.maxArchivedFileSize) continue;
                        this.addErrorElement(ctx, key, name, "File too big: " + this.maxArchivedFileSize + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
                        out.close();
                        out = null;
                        output.free();
                        continue block9;
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                    continue;
                }
                if (size <= this.maxArchivedFileSize) {
                    this.addStoreElement(ctx, key, name, output, gotElement, element, callback, container, context);
                    names.add(name);
                    this.trimStoredData();
                    continue;
                }
                callback.gotBucket(output, container, context);
                gotElement.value = true;
                this.addErrorElement(ctx, key, name, "File too big: " + size + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
            }
            if (!gotMetadata) {
                this.generateMetadata(ctx, key, names, gotElement, element, callback, container, context);
                this.trimStoredData();
            }
            if (throwAtExit) {
                throw new ArchiveRestartException("Archive changed on re-fetch");
            }
            if (!gotElement.value && element != null) {
                callback.notInArchive(container, context);
            }
        }
        catch (IOException e) {
            try {
                throw new ArchiveFailureException("Error reading archive: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Closer.close(tarIS);
                throw throwable;
            }
        }
        Closer.close((Closeable)tarIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleZIPArchive(ArchiveStoreContext ctx, FreenetURI key, InputStream data, String element, ArchiveExtractCallback callback, MutableBoolean gotElement, boolean throwAtExit, ObjectContainer container, ClientContext context) throws ArchiveFailureException, ArchiveRestartException {
        if (logMINOR) {
            Logger.minor(this, "Handling a ZIP Archive");
        }
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(data);
            byte[] buf = new byte[32768];
            HashSet<String> names = new HashSet<String>();
            boolean gotMetadata = false;
            block12: while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = this.stripLeadingSlashes(entry.getName());
                if (names.contains(name)) {
                    Logger.error(this, "Duplicate key " + name + " in archive " + key);
                    continue;
                }
                long size = entry.getSize();
                if (name.equals(METADATA_NAME)) {
                    gotMetadata = true;
                }
                if (size > this.maxArchivedFileSize && !name.equals(element)) {
                    this.addErrorElement(ctx, key, name, "File too big: " + this.maxArchivedFileSize + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
                    continue;
                }
                long realLen = 0L;
                Bucket output = this.tempBucketFactory.makeBucket(size);
                OutputStream out = output.getOutputStream();
                try {
                    int readBytes;
                    while ((readBytes = zis.read(buf)) > 0) {
                        out.write(buf, 0, readBytes);
                        if ((long)(readBytes = (int)((long)readBytes + realLen)) <= this.maxArchivedFileSize) continue;
                        this.addErrorElement(ctx, key, name, "File too big: " + this.maxArchivedFileSize + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
                        out.close();
                        out = null;
                        output.free();
                        continue block12;
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                    continue;
                }
                if (size <= this.maxArchivedFileSize) {
                    this.addStoreElement(ctx, key, name, output, gotElement, element, callback, container, context);
                    names.add(name);
                    this.trimStoredData();
                    continue;
                }
                callback.gotBucket(output, container, context);
                gotElement.value = true;
                this.addErrorElement(ctx, key, name, "File too big: " + size + " greater than current archived file size limit " + this.maxArchivedFileSize, true);
            }
            if (!gotMetadata) {
                this.generateMetadata(ctx, key, names, gotElement, element, callback, container, context);
                this.trimStoredData();
            }
            if (throwAtExit) {
                throw new ArchiveRestartException("Archive changed on re-fetch");
            }
            if (!gotElement.value && element != null) {
                callback.notInArchive(container, context);
            }
        }
        catch (IOException e) {
            throw new ArchiveFailureException("Error reading archive: " + e.getMessage(), e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    Logger.error(this, "Failed to close stream: " + e, (Throwable)e);
                }
            }
        }
    }

    private String stripLeadingSlashes(String name) {
        while (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private ArchiveStoreItem generateMetadata(ArchiveStoreContext ctx, FreenetURI key, Set<String> names, MutableBoolean gotElement, String element2, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) throws ArchiveFailureException {
        dir = new HashMap<String, Object>();
        for (String name : names) {
            this.addToDirectory(dir, name, "");
        }
        metadata = new Metadata(dir, "");
        x = 0;
        bucket = null;
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                bucket = BucketTools.makeImmutableBucket(this.tempBucketFactory, metadata.writeToByteArray());
                return this.addStoreElement(ctx, key, ".metadata", bucket, gotElement, element2, callback, container, context);
            }
            catch (MetadataUnresolvedException e) {
                try {
                    x = this.resolve(e, x, bucket, ctx, key, gotElement, element2, callback, container, context);
                    continue;
                }
                catch (IOException e1) {
                    throw new ArchiveFailureException("Failed to create metadata: " + e1, e1);
                }
            }
            ** while (true)
            catch (IOException e1) {
                Logger.error(this, "Failed to create metadata: " + e1, (Throwable)e1);
                throw new ArchiveFailureException("Failed to create metadata: " + e1, e1);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolve(MetadataUnresolvedException e, int x, Bucket bucket, ArchiveStoreContext ctx, FreenetURI key, MutableBoolean gotElement, String element2, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) throws IOException, ArchiveFailureException {
        for (Metadata m : e.mustResolve) {
            byte[] buf;
            try {
                buf = m.writeToByteArray();
            }
            catch (MetadataUnresolvedException e1) {
                x = this.resolve(e, x, bucket, ctx, key, gotElement, element2, callback, container, context);
                continue;
            }
            OutputStream os = bucket.getOutputStream();
            try {
                os.write(buf);
            }
            finally {
                os.close();
            }
            this.addStoreElement(ctx, key, ".metadata-" + x++, bucket, gotElement, element2, callback, container, context);
        }
        return x;
    }

    private void addToDirectory(HashMap<String, Object> dir, String name, String prefix) throws ArchiveFailureException {
        int x = name.indexOf(47);
        if (x < 0) {
            if (dir.containsKey(name)) {
                throw new ArchiveFailureException("Invalid archive: contains " + prefix + name + " twice");
            }
            dir.put(name, name);
        } else {
            String before = name.substring(0, x);
            String after = x == name.length() - 1 ? "" : name.substring(x + 1, name.length());
            HashMap o = dir.get(before);
            if (o == null) {
                o = new HashMap();
                dir.put(before, o);
            } else if (o instanceof String) {
                throw new ArchiveFailureException("Invalid archive: contains " + name + " as both file and dir");
            }
            this.addToDirectory(Metadata.forceMap(o), after, prefix + before + '/');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addErrorElement(ArchiveStoreContext ctx, FreenetURI key, String name, String error, boolean tooBig) {
        ErrorArchiveStoreItem element = new ErrorArchiveStoreItem(ctx, key, name, error, tooBig);
        if (logMINOR) {
            Logger.minor(this, "Adding error element: " + element + " for " + key + ' ' + name);
        }
        ArchiveManager archiveManager = this;
        synchronized (archiveManager) {
            ArchiveStoreItem oldItem = this.storedData.get(element.key);
            this.storedData.push(element.key, element);
            if (oldItem != null) {
                oldItem.close();
                this.cachedData -= oldItem.spaceUsed();
                if (logMINOR) {
                    Logger.minor(this, "Dropping old store element from archive cache: " + oldItem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveStoreItem addStoreElement(ArchiveStoreContext ctx, FreenetURI key, String name, Bucket temp, MutableBoolean gotElement, String callbackName, ArchiveExtractCallback callback, ObjectContainer container, ClientContext context) throws ArchiveFailureException {
        RealArchiveStoreItem element = new RealArchiveStoreItem(ctx, key, name, temp);
        if (logMINOR) {
            Logger.minor(this, "Adding store element: " + element + " ( " + key + ' ' + name + " size " + element.spaceUsed() + " )");
        }
        Bucket matchBucket = null;
        if (!gotElement.value && name.equals(callbackName)) {
            matchBucket = element.getReaderBucket();
        }
        ArchiveManager archiveManager = this;
        synchronized (archiveManager) {
            ArchiveStoreItem oldItem = this.storedData.get(element.key);
            this.storedData.push(element.key, element);
            this.cachedData += element.spaceUsed();
            if (oldItem != null) {
                this.cachedData -= oldItem.spaceUsed();
                if (logMINOR) {
                    Logger.minor(this, "Dropping old store element from archive cache: " + oldItem);
                }
                oldItem.close();
            }
        }
        if (matchBucket != null) {
            callback.gotBucket(matchBucket, container, context);
            gotElement.value = true;
        }
        return element;
    }

    private void trimStoredData() {
        ArchiveManager archiveManager = this;
        synchronized (archiveManager) {
            while (true) {
                if (this.cachedData <= this.maxCachedData && this.storedData.size() <= this.maxCachedElements) {
                    return;
                }
                if (this.storedData.isEmpty()) {
                    Logger.error(this, "storedData is empty but still over limit: cachedData=" + this.cachedData + " / " + this.maxCachedData);
                    return;
                }
                ArchiveStoreItem item = this.storedData.popValue();
                long space = item.spaceUsed();
                this.cachedData -= space;
                if (logMINOR) {
                    Logger.minor(this, "Dropping " + item + " : cachedData=" + this.cachedData + " of " + this.maxCachedData + " stored items : " + this.storedData.size() + " of " + this.maxCachedElements);
                }
                item.close();
            }
        }
    }

    public static void init(ObjectContainer container, ClientContext context, long nodeDBHandle) {
        ArchiveHandlerImpl.init(container, context, nodeDBHandle);
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ArchiveManager in database", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanUpdate(ObjectContainer container) {
        Logger.error(this, "Trying to store an ArchiveManager!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanActivate(ObjectContainer container) {
        Logger.error(this, "Trying to store an ArchiveManager!", (Throwable)new Exception("error"));
        return false;
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        Logger.error(this, "Trying to store an ArchiveManager!", (Throwable)new Exception("error"));
        return false;
    }

    public static enum ARCHIVE_TYPE {
        ZIP(0, new String[]{"application/zip", "application/x-zip"}),
        TAR(1, new String[]{"application/x-tar"});

        public final short metadataID;
        public final String[] mimeTypes;
        private static final ARCHIVE_TYPE[] values;

        private ARCHIVE_TYPE(short metadataID, String[] mimeTypes) {
            this.metadataID = metadataID;
            this.mimeTypes = mimeTypes;
        }

        public static boolean isValidMetadataID(short id) {
            for (ARCHIVE_TYPE current : values) {
                if (id != current.metadataID) continue;
                return true;
            }
            return false;
        }

        public static boolean isUsableArchiveType(String type) {
            for (ARCHIVE_TYPE current : values) {
                for (String ctype : current.mimeTypes) {
                    if (!ctype.equalsIgnoreCase(type)) continue;
                    return true;
                }
            }
            return false;
        }

        public static ARCHIVE_TYPE getArchiveType(String type) {
            for (ARCHIVE_TYPE current : values) {
                for (String ctype : current.mimeTypes) {
                    if (!ctype.equalsIgnoreCase(type)) continue;
                    return current;
                }
            }
            return null;
        }

        public static ARCHIVE_TYPE getArchiveType(short type) {
            for (ARCHIVE_TYPE current : values) {
                if (current.metadataID != type) continue;
                return current;
            }
            return null;
        }

        public static ARCHIVE_TYPE getDefault() {
            return TAR;
        }

        static {
            values = ARCHIVE_TYPE.values();
        }
    }
}

