/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;

public class ClientMetadata
implements Cloneable {
    private String mimeType;

    public ClientMetadata() {
        this.mimeType = null;
    }

    public ClientMetadata(String mime) {
        this.mimeType = mime == null ? null : mime.intern();
    }

    public String getMIMEType() {
        if (this.mimeType == null || this.mimeType.length() == 0) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    public void mergeNoOverwrite(ClientMetadata clientMetadata) {
        if (this.mimeType == null || this.mimeType.equals("")) {
            this.mimeType = clientMetadata.mimeType;
        }
    }

    public boolean isTrivial() {
        return this.mimeType == null || this.mimeType.equals("");
    }

    public ClientMetadata clone() {
        try {
            return (ClientMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.getMIMEType();
    }

    public void clear() {
        this.mimeType = null;
    }

    public String getMIMETypeNoParams() {
        String s = this.mimeType;
        if (s == null) {
            return null;
        }
        int i = s.indexOf(59);
        if (i > -1) {
            s = s.substring(i);
        }
        return s;
    }

    public void removeFrom(ObjectContainer container) {
        container.delete((Object)this);
    }
}

