/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.client.FECCodec;
import freenet.client.FECJob;
import freenet.client.StandardOnionFECCodec;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.io.NativeThread;
import java.util.LinkedList;
import java.util.ListIterator;

public class FECQueue
implements OOMHook {
    private transient LinkedList<FECJob>[] transientQueue;
    private transient LinkedList<FECJob>[] persistentQueueCache;
    private transient int maxPersistentQueueCacheSize;
    private transient int priorities;
    private transient DBJobRunner databaseJobRunner;
    private transient Executor executor;
    private transient ClientContext clientContext;
    private transient int runningFECThreads;
    private transient int fecPoolCounter;
    private transient PrioRunnable runner;
    private transient DBJob cacheFillerJob;
    private long nodeDBHandle;
    private transient FECQueue proxy;
    private transient FECQueue proxiedFor;
    private static volatile boolean logMINOR;
    private int maxRunningFECThreads = -1;

    public static FECQueue create(final long nodeDBHandle, ObjectContainer container, FECQueue transientQueue) {
        ObjectSet result = container.query((Predicate)new Predicate<FECQueue>(){

            public boolean match(FECQueue queue) {
                return queue.nodeDBHandle == nodeDBHandle;
            }
        });
        if (result.hasNext()) {
            FECQueue queue = (FECQueue)result.next();
            container.activate((Object)queue, 1);
            if (transientQueue != null) {
                queue.proxyInit(transientQueue, nodeDBHandle);
            }
            return queue;
        }
        FECQueue queue = new FECQueue(nodeDBHandle);
        container.store((Object)queue);
        if (transientQueue != null) {
            queue.proxyInit(transientQueue, nodeDBHandle);
        }
        return queue;
    }

    public FECQueue(long nodeDBHandle) {
        this.nodeDBHandle = nodeDBHandle;
    }

    public synchronized void proxyInit(FECQueue oldQueue, long dbHandle) {
        this.proxy = oldQueue;
        oldQueue.persistentInit(dbHandle, this);
    }

    private void persistentInit(long dbHandle, FECQueue fromDB) {
        this.nodeDBHandle = dbHandle;
        this.proxiedFor = fromDB;
        this.queueCacheFiller();
    }

    public void init(int priorities, int maxCacheSize, DBJobRunner dbJobRunner, Executor exec, ClientContext clientContext) {
        this.priorities = priorities;
        this.maxPersistentQueueCacheSize = maxCacheSize;
        this.databaseJobRunner = dbJobRunner;
        this.executor = exec;
        this.clientContext = clientContext;
        this.transientQueue = new LinkedList[priorities];
        this.persistentQueueCache = new LinkedList[priorities];
        for (int i = 0; i < priorities; ++i) {
            this.transientQueue[i] = new LinkedList();
            this.persistentQueueCache[i] = new LinkedList();
        }
        this.maxRunningFECThreads = this.getMaxRunningFECThreads();
        OOMHandler.addOOMHook(this);
        this.initRunner();
        this.initCacheFillerJob();
        this.queueCacheFiller();
    }

    private void queueCacheFiller() {
        try {
            this.databaseJobRunner.queue(this.cacheFillerJob, NativeThread.NORM_PRIORITY, true);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(FECJob job, FECCodec codec, ObjectContainer container) {
        FECQueue fECQueue = this;
        synchronized (fECQueue) {
            if (this.proxy != null) {
                this.proxy.addToQueue(job, codec, container);
                return;
            }
        }
        boolean logMINOR = FECQueue.logMINOR;
        if (logMINOR) {
            Logger.minor(StandardOnionFECCodec.class, "Adding a new job to the queue: " + job + ".");
        }
        int maxThreads = this.getMaxRunningFECThreads();
        if (job.persistent) {
            job.activateForExecution(container);
            container.store((Object)job);
        }
        FECQueue fECQueue2 = this;
        synchronized (fECQueue2) {
            if (!job.persistent) {
                this.transientQueue[job.priority].addLast(job);
            } else {
                int totalAbove = 0;
                for (int i = 0; i < job.priority; ++i) {
                    totalAbove += this.persistentQueueCache[i].size();
                }
                if (totalAbove >= this.maxPersistentQueueCacheSize) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding persistent job to in-RAM cache, too many above it");
                    }
                } else if (totalAbove + this.persistentQueueCache[job.priority].size() >= this.maxPersistentQueueCacheSize) {
                    if (logMINOR) {
                        Logger.minor(this, "Not adding persistent job to in-RAM cache, too many at same priority");
                    }
                } else {
                    this.persistentQueueCache[job.priority].addLast(job);
                    int total = totalAbove + this.persistentQueueCache[job.priority].size();
                    for (int i = job.priority + 1; i < this.priorities; ++i) {
                        total += this.persistentQueueCache[i].size();
                        while (total >= this.maxPersistentQueueCacheSize && !this.persistentQueueCache[i].isEmpty()) {
                            if (logMINOR) {
                                Logger.minor(this, "Removing low priority job from cache, total now " + total);
                            }
                            this.persistentQueueCache[i].removeLast();
                            --total;
                        }
                    }
                }
            }
            if (this.runningFECThreads < maxThreads) {
                this.executor.execute(this.runner, "FEC Pool(" + this.fecPoolCounter++ + ")");
                ++this.runningFECThreads;
            }
            this.notifyAll();
        }
    }

    private void initRunner() {
        this.runner = new PrioRunnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[UNCONDITIONALDOLOOP]], but top level block is 10[MONITOR]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            public int getPriority() {
                return NativeThread.LOW_PRIORITY;
            }
        };
    }

    private void initCacheFillerJob() {
        this.cacheFillerJob = new DBJob(){

            public String toString() {
                return "FECQueueCacheFiller";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                if (logMINOR) {
                    Logger.minor(this, "Running FEC cache filler job");
                }
                while (true) {
                    boolean addedAny = false;
                    int totalCached = 0;
                    for (short prio = 0; prio < FECQueue.this.priorities; prio = (short)(prio + 1)) {
                        int grab = 0;
                        FECQueue fECQueue = FECQueue.this;
                        synchronized (fECQueue) {
                            int newCached = totalCached + FECQueue.this.persistentQueueCache[prio].size();
                            if (newCached >= FECQueue.this.maxPersistentQueueCacheSize) {
                                return false;
                            }
                            grab = FECQueue.this.maxPersistentQueueCacheSize - newCached;
                            totalCached = newCached;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Grabbing up to " + grab + " jobs at priority " + prio);
                        }
                        Query query = container.query();
                        query.constrain(FECJob.class);
                        Constraint con = query.descend("priority").constrain((Object)prio);
                        if (FECQueue.this.proxiedFor != null) {
                            con.and(query.descend("queue").constrain((Object)FECQueue.this.proxiedFor).identity());
                        } else {
                            con.and(query.descend("queue").constrain((Object)FECQueue.this).identity());
                        }
                        query.descend("addedTime").orderAscending();
                        ObjectSet results = query.execute();
                        if (!results.hasNext()) continue;
                        for (int j = 0; j < grab && results.hasNext(); ++j) {
                            FECJob job = (FECJob)results.next();
                            FECQueue fECQueue2 = FECQueue.this;
                            synchronized (fECQueue2) {
                                if (job.running) {
                                    --j;
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding, already running (1): " + job);
                                    }
                                    continue;
                                }
                            }
                            if (!job.activateForExecution(container)) {
                                if (job.callback == null) continue;
                                container.activate((Object)job.callback, 1);
                                try {
                                    job.callback.onFailed(new NullPointerException("Not all data blocks present"), container, context);
                                }
                                catch (Throwable t) {
                                    try {
                                        Logger.error(this, "Caught " + t + " while calling failure callback on " + job, t);
                                    }
                                    catch (Throwable t1) {
                                        // empty catch block
                                    }
                                }
                                container.delete((Object)job);
                                continue;
                            }
                            if (job.isCancelled(container)) {
                                container.delete((Object)job);
                                continue;
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Maybe adding " + job);
                            }
                            fECQueue2 = FECQueue.this;
                            synchronized (fECQueue2) {
                                if (job.running) {
                                    --j;
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding, already running (2): " + job);
                                    }
                                    continue;
                                }
                                if (FECQueue.this.persistentQueueCache[prio].contains(job)) {
                                    --j;
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding as on persistent queue cache for " + prio + " : " + job);
                                    }
                                    continue;
                                }
                                boolean added = false;
                                ListIterator<FECJob> it = FECQueue.this.persistentQueueCache[prio].listIterator();
                                while (it.hasNext()) {
                                    FECJob cmp = (FECJob)it.next();
                                    if (cmp.addedTime < job.addedTime) continue;
                                    it.previous();
                                    it.add(job);
                                    added = true;
                                    if (!logMINOR) break;
                                    Logger.minor(this, "Adding " + job + " before " + it);
                                    break;
                                }
                                if (!added) {
                                    FECQueue.this.persistentQueueCache[prio].addLast(job);
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Added " + job);
                                }
                                addedAny = true;
                                continue;
                            }
                        }
                    }
                    if (!addedAny) {
                        if (logMINOR) {
                            Logger.minor(this, "No more jobs to add");
                        }
                        return false;
                    }
                    FECQueue fECQueue = FECQueue.this;
                    synchronized (fECQueue) {
                        int maxRunningThreads = FECQueue.this.maxRunningFECThreads;
                        if (FECQueue.this.runningFECThreads < maxRunningThreads) {
                            int queueSize = 0;
                            for (int i = 0; i < FECQueue.this.priorities && (queueSize += FECQueue.this.persistentQueueCache[i].size()) + FECQueue.this.runningFECThreads <= maxRunningThreads; ++i) {
                            }
                            if (queueSize + FECQueue.this.runningFECThreads < maxRunningThreads) {
                                maxRunningThreads = queueSize + FECQueue.this.runningFECThreads;
                            }
                            while (FECQueue.this.runningFECThreads < maxRunningThreads) {
                                FECQueue.this.executor.execute(FECQueue.this.runner, "FEC Pool " + FECQueue.this.fecPoolCounter++);
                                FECQueue.this.runningFECThreads++;
                            }
                        }
                        FECQueue.this.notifyAll();
                    }
                }
            }
        };
    }

    private synchronized int getMaxRunningFECThreads() {
        if (this.maxRunningFECThreads != -1) {
            return this.maxRunningFECThreads;
        }
        String osName = System.getProperty("os.name");
        if (!(osName.indexOf("Windows") != -1 || osName.toLowerCase().indexOf("mac os x") <= 0 && NativeThread.usingNativeCode())) {
            this.maxRunningFECThreads = 1;
        } else {
            Runtime r = Runtime.getRuntime();
            int max = r.availableProcessors();
            long maxMemory = r.maxMemory();
            max = maxMemory < 0x10000000L ? 1 : Math.min(3, Math.min(max, (int)Math.min(Integer.MAX_VALUE, maxMemory / 0x8000000L)));
            this.maxRunningFECThreads = max;
        }
        Logger.minor(FECCodec.class, "Maximum FEC threads: " + this.maxRunningFECThreads);
        return this.maxRunningFECThreads;
    }

    protected synchronized FECJob getFECJobBlockingNoDBAccess() {
        while (this.runningFECThreads <= this.getMaxRunningFECThreads()) {
            for (int i = 0; i < this.priorities; ++i) {
                if (!this.transientQueue[i].isEmpty()) {
                    return this.transientQueue[i].removeFirst();
                }
                if (this.persistentQueueCache[i].isEmpty()) continue;
                return this.persistentQueueCache[i].removeFirst();
            }
            this.queueCacheFiller();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return null;
    }

    @Override
    public synchronized void handleLowMemory() throws Exception {
        this.maxRunningFECThreads = Math.max(1, this.maxRunningFECThreads - 1);
        this.notify();
    }

    @Override
    public synchronized void handleOutOfMemory() throws Exception {
        this.maxRunningFECThreads = 1;
        this.notifyAll();
    }

    public void objectOnDeactivate(ObjectContainer container) {
        Logger.error(this, "Attempting to deactivate FECQueue!", (Throwable)new Exception("debug"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(FECJob job, ObjectContainer container, ClientContext context) {
        Object object = this;
        synchronized (object) {
            if (this.proxy != null) {
                return this.proxy.cancel(job, container, context);
            }
            for (int i = 0; i < this.priorities; ++i) {
                this.transientQueue[i].remove(job);
                this.persistentQueueCache[i].remove(job);
            }
        }
        object = job;
        synchronized (object) {
            if (job.running) {
                return false;
            }
        }
        if (job.persistent) {
            container.delete((Object)job);
        }
        return true;
    }

    public static void dump(ObjectContainer container, int priorities) {
        ObjectSet queues = container.query(FECQueue.class);
        System.out.println("Queues: " + queues.size());
        for (short prio = 0; prio < priorities; prio = (short)(prio + 1)) {
            Query query = container.query();
            query.constrain(FECJob.class);
            query.descend("priority").constrain((Object)prio);
            ObjectSet results = query.execute();
            System.err.println("FEC jobs at priority " + prio + " : " + results.size());
        }
    }

    static /* synthetic */ DBJobRunner access$200(FECQueue x0) {
        return x0.databaseJobRunner;
    }

    static /* synthetic */ int access$410(FECQueue x0) {
        return x0.runningFECThreads--;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

