/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.InsertException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FailureCodeTracker
implements Cloneable {
    public final boolean insert;
    private int total;
    private HashMap<Integer, Item> map;

    public FailureCodeTracker(boolean insert) {
        this.insert = insert;
    }

    public FailureCodeTracker(boolean isInsert, SimpleFieldSet fs) {
        this.insert = isInsert;
        Iterator<String> i = fs.directSubsetNameIterator();
        while (i.hasNext()) {
            String name = i.next();
            SimpleFieldSet f = fs.subset(name);
            int num = Integer.parseInt(name);
            int count = Integer.parseInt(f.get("Count"));
            if (count < 0) {
                throw new IllegalArgumentException("Count < 0");
            }
            this.map.put(num, new Item(count));
            this.total += count;
        }
    }

    public synchronized void inc(int k) {
        Integer key;
        Item i;
        if (k == 0) {
            Logger.error(this, "Can't increment 0, not a valid failure mode", (Throwable)new Exception("error"));
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((i = this.map.get(key = Integer.valueOf(k))) == null) {
            i = new Item();
            this.map.put(key, i);
        }
        ++i.x;
        ++this.total;
    }

    public synchronized void inc(Integer k, int val) {
        Integer key;
        Item i;
        if (k == 0) {
            Logger.error(this, "Can't increment 0, not a valid failure mode", (Throwable)new Exception("error"));
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((i = this.map.get(key = k)) == null) {
            i = new Item();
            this.map.put(key, i);
        }
        i.x += val;
        this.total += val;
    }

    public synchronized String toVerboseString() {
        if (this.map == null) {
            return super.toString() + ":empty";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Item> e : this.map.entrySet()) {
            Integer x = e.getKey();
            Item val = e.getValue();
            String s = this.insert ? InsertException.getMessage(x) : FetchException.getMessage(x);
            sb.append(val.x);
            sb.append('\t');
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public synchronized String toString() {
        if (this.map == null) {
            return super.toString() + ":empty";
        }
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(':');
        if (this.map.size() == 0) {
            sb.append("empty");
        } else if (this.map.size() == 1) {
            sb.append("one:");
            Integer code = (Integer)this.map.keySet().toArray()[0];
            sb.append(code);
            sb.append('=');
            sb.append(this.map.get((Object)code).x);
        } else if (this.map.size() < 10) {
            boolean needComma = false;
            for (Map.Entry<Integer, Item> entry : this.map.entrySet()) {
                if (needComma) {
                    sb.append(',');
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue().x);
                needComma = true;
            }
        } else {
            sb.append(this.map.size());
        }
        return sb.toString();
    }

    public synchronized FailureCodeTracker merge(FailureCodeTracker source) {
        if (source.map == null) {
            return this;
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        for (Map.Entry<Integer, Item> e : source.map.entrySet()) {
            Integer k = e.getKey();
            Item item = e.getValue();
            this.inc(k, item.x);
        }
        return this;
    }

    public void merge(FetchException e) {
        if (this.insert) {
            throw new IllegalStateException("Merging a FetchException in an insert!");
        }
        if (e.errorCodes != null) {
            this.merge(e.errorCodes);
        }
        this.inc(e.mode);
    }

    public synchronized int totalCount() {
        return this.total;
    }

    public synchronized SimpleFieldSet toFieldSet(boolean verbose) {
        SimpleFieldSet sfs = new SimpleFieldSet(false);
        if (this.map != null) {
            for (Map.Entry<Integer, Item> e : this.map.entrySet()) {
                Integer k = e.getKey();
                Item item = e.getValue();
                int code = k;
                if (verbose) {
                    sfs.putSingle(Integer.toString(code) + ".Description", this.insert ? InsertException.getMessage(code) : FetchException.getMessage(code));
                }
                sfs.put(Integer.toString(code) + ".Count", item.x);
            }
        }
        return sfs;
    }

    public synchronized boolean isOneCodeOnly() {
        return this.map.size() == 1;
    }

    public synchronized int getFirstCode() {
        return (Integer)this.map.keySet().toArray()[0];
    }

    public synchronized boolean isFatal(boolean insert) {
        if (this.map == null) {
            return false;
        }
        for (Map.Entry<Integer, Item> e : this.map.entrySet()) {
            Integer code = e.getKey();
            if (e.getValue().x == 0 || !(insert ? InsertException.isFatal(code) : FetchException.isFatal(code))) continue;
            return true;
        }
        return false;
    }

    public void merge(InsertException e) {
        if (!this.insert) {
            throw new IllegalArgumentException("This is not an insert yet merge(" + e + ") called!");
        }
        if (e.errorCodes != null) {
            this.merge(e.errorCodes);
        }
        this.inc(e.getMode());
    }

    public synchronized boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(ObjectContainer container) {
        Integer[] ints;
        Item[] items;
        FailureCodeTracker failureCodeTracker = this;
        synchronized (failureCodeTracker) {
            items = this.map == null ? null : this.map.values().toArray(new Item[this.map.size()]);
            Integer[] integerArray = ints = this.map == null ? null : this.map.keySet().toArray(new Integer[this.map.size()]);
            if (this.map != null) {
                this.map.clear();
            }
        }
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                container.delete((Object)items[i]);
                container.delete((Object)ints[i]);
            }
        }
        if (this.map != null) {
            container.activate(this.map, 5);
            container.delete(this.map);
        }
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        if (this.map != null) {
            container.activate(this.map, 5);
        }
    }

    public FailureCodeTracker clone() {
        FailureCodeTracker tracker = new FailureCodeTracker(this.insert);
        tracker.merge(this);
        return tracker;
    }

    public void storeTo(ObjectContainer container) {
        container.ext().store((Object)this, 5);
    }

    public synchronized boolean isDataFound() {
        for (Map.Entry<Integer, Item> entry : this.map.entrySet()) {
            if (entry.getValue().x <= 0 || !FetchException.isDataFound(entry.getKey(), null)) continue;
            return true;
        }
        return false;
    }

    private static class Item {
        int x;

        Item(int count) {
            this.x = count;
        }

        Item() {
            this.x = 0;
        }
    }
}

