/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.ContainerInserter;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.ManifestElement;
import freenet.client.async.ManifestPutter;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.async.TooManyFilesInsertException;
import freenet.client.events.SplitfileProgressEvent;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public abstract class BaseManifestPutter
extends ManifestPutter {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static final String[] defaultDefaultNames;
    private boolean containerMode = false;
    private boolean freeformMode = false;
    private HashSet<PutHandler> putHandlerWaitingForBlockSets;
    private HashSet<PutHandler> putHandlersWaitingForFetchable;
    private HashSet<PutHandler> runningPutHandlers;
    private ContainerBuilder rootContainerBuilder;
    private ContainerPutHandler rootContainerPutHandler;
    private HashSet<PutHandler> containerPutHandlers;
    private HashMap<PutHandler, HashSet<PutHandler>> perContainerPutHandlersWaitingForMetadata;
    private HashMap<PutHandler, HashMap<String, Object>> putHandlersTransformMap;
    private HashMap<ArchivePutHandler, Vector<PutHandler>> putHandlersArchiveTransformMap;
    private FreeFormBuilder rootBuilder;
    private MetaPutHandler rootMetaPutHandler;
    private HashMap<String, Object> rootDir;
    private HashSet<PutHandler> putHandlersWaitingForMetadata;
    private FreenetURI finalURI;
    private final FreenetURI targetURI;
    private boolean finished;
    private final InsertContext ctx;
    final ClientPutCallback cb;
    private final boolean getCHKOnly;
    private int numberOfFiles;
    private long totalSize;
    private Metadata baseMetadata;
    private boolean hasResolvedBase;
    private boolean fetchable;
    private final boolean earlyEncode;
    final byte[] forceCryptoKey;
    final byte cryptoAlgorithm;
    private final DBJob runGotAllMetadata = new DBJob(){

        @Override
        public boolean run(ObjectContainer container, ClientContext context) {
            try {
                context.jobRunner.removeRestartJob(this, NativeThread.NORM_PRIORITY, container);
            }
            catch (DatabaseDisabledException databaseDisabledException) {
                // empty catch block
            }
            container.activate((Object)BaseManifestPutter.this, 1);
            BaseManifestPutter.this.innerGotAllMetadata(container, context);
            container.deactivate((Object)BaseManifestPutter.this, 1);
            return true;
        }
    };
    protected int minSuccessFetchBlocks;

    public BaseManifestPutter(ClientPutCallback cb, HashMap<String, Object> manifestElements, short prioClass, FreenetURI target, String defaultName, InsertContext ctx, boolean getCHKOnly2, RequestClient clientContext, boolean earlyEncode, boolean randomiseCryptoKeys, byte[] forceCryptoKey, ObjectContainer container, ClientContext context) throws TooManyFilesInsertException {
        super(prioClass, clientContext);
        InsertContext.CompatibilityMode mode;
        this.targetURI = this.client.persistent() ? target.clone() : target;
        this.cb = cb;
        this.ctx = ctx;
        this.getCHKOnly = getCHKOnly2;
        this.earlyEncode = earlyEncode;
        if (randomiseCryptoKeys && forceCryptoKey == null) {
            forceCryptoKey = new byte[32];
            context.random.nextBytes(forceCryptoKey);
        }
        this.forceCryptoKey = forceCryptoKey;
        if (this.client.persistent()) {
            container.activate((Object)ctx, 1);
        }
        this.cryptoAlgorithm = (mode = ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && mode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal() ? (byte)2 : (byte)3;
        this.runningPutHandlers = new HashSet();
        this.putHandlersWaitingForMetadata = new HashSet();
        this.putHandlersWaitingForFetchable = new HashSet();
        this.putHandlerWaitingForBlockSets = new HashSet();
        this.containerPutHandlers = new HashSet();
        this.perContainerPutHandlersWaitingForMetadata = new HashMap();
        this.putHandlersTransformMap = new HashMap();
        this.putHandlersArchiveTransformMap = new HashMap();
        if (defaultName == null) {
            defaultName = this.findDefaultName(manifestElements, defaultName);
        }
        this.makePutHandlers(manifestElements, defaultName);
        this.rootBuilder = null;
        this.rootContainerBuilder = null;
    }

    private String findDefaultName(HashMap<String, Object> manifestElements, String defaultName) {
        for (String name : defaultDefaultNames) {
            Object o = manifestElements.get(name);
            if (o == null || o instanceof HashMap) continue;
            return name;
        }
        for (String name : defaultDefaultNames) {
            boolean found = false;
            for (Map.Entry<String, Object> entry : manifestElements.entrySet()) {
                Object o = entry.getValue();
                if (o == null || o instanceof HashMap || !entry.getKey().equalsIgnoreCase(name)) continue;
                found = true;
                name = entry.getKey();
                break;
            }
            if (!found) continue;
            return name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ObjectContainer container, ClientContext context) throws InsertException {
        PutHandler[] containers;
        PutHandler[] running;
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistence=" + this.persistent() + " containermode=" + this.containerMode);
        }
        if (this.persistent()) {
            container.activate(this.runningPutHandlers, 2);
            if (this.containerMode) {
                container.activate(this.putHandlerWaitingForBlockSets, 2);
            }
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
            containers = this.containerMode ? this.getContainersToStart(running.length > 0) : null;
        }
        try {
            int i;
            boolean persistent = this.persistent();
            for (i = 0; i < running.length; ++i) {
                running[i].start(container, context);
                if (persistent && !container.ext().isActive((Object)this)) {
                    container.activate((Object)this, 1);
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + i + " of " + running.length);
                }
                if (!this.isFinished()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already finished, killing start() on " + this);
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + running.length + " PutHandler's for " + this);
            }
            if (this.containerMode) {
                for (i = 0; i < containers.length; ++i) {
                    containers[i].start(container, context);
                    if (persistent && !container.ext().isActive((Object)this)) {
                        container.activate((Object)this, 1);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Started " + i + " of " + containers.length);
                    }
                    if (!this.isFinished()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Already finished, killing start() on " + this);
                    }
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Started " + containers.length + " PutHandler's (containers) for " + this);
                }
            }
            if (!this.containerMode && running.length == 0) {
                if (this.persistent()) {
                    container.store((Object)this);
                }
                this.gotAllMetadata(container, context);
            }
        }
        catch (InsertException e) {
            BaseManifestPutter baseManifestPutter2 = this;
            synchronized (baseManifestPutter2) {
                this.finished = true;
            }
            this.cancelAndFinish(container, context);
            throw e;
        }
    }

    private PutHandler[] getContainersToStart(boolean excludeRoot) {
        PutHandler[] maybeStartPH = this.containerPutHandlers.toArray(new PutHandler[this.containerPutHandlers.size()]);
        ArrayList<PutHandler> phToStart = new ArrayList<PutHandler>();
        for (PutHandler ph : maybeStartPH) {
            if (!this.perContainerPutHandlersWaitingForMetadata.get(ph).isEmpty()) continue;
            phToStart.add(ph);
        }
        if (!excludeRoot && maybeStartPH.length == 0) {
            phToStart.add(this.rootContainerPutHandler);
        }
        return phToStart.toArray(new PutHandler[phToStart.size()]);
    }

    protected abstract void makePutHandlers(HashMap<String, Object> var1, String var2) throws TooManyFilesInsertException;

    @Override
    public FreenetURI getURI() {
        return this.finalURI;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    @Override
    public byte[] getSplitfileCryptoKey() {
        return this.forceCryptoKey;
    }

    private void gotAllMetadata(ObjectContainer container, ClientContext context) {
        if (this.containerMode) {
            throw new IllegalStateException();
        }
        if (this.persistent()) {
            container.activate((Object)this.runGotAllMetadata, 1);
            try {
                context.jobRunner.queueRestartJob(this.runGotAllMetadata, NativeThread.NORM_PRIORITY, container, false);
                context.jobRunner.queue(this.runGotAllMetadata, NativeThread.NORM_PRIORITY, false);
            }
            catch (DatabaseDisabledException databaseDisabledException) {}
        } else {
            this.innerGotAllMetadata(null, context);
        }
    }

    private void innerGotAllMetadata(ObjectContainer container, ClientContext context) {
        if (this.containerMode) {
            throw new IllegalStateException();
        }
        if (logMINOR) {
            Logger.minor(this, "Got all metadata");
        }
        this.baseMetadata = this.makeMetadata(this.rootDir, container);
        if (this.persistent()) {
            container.store((Object)this.baseMetadata);
            container.store((Object)this);
        }
        this.resolveAndStartBase(container, context);
    }

    private Metadata makeMetadata(HashMap<String, Object> dir, ObjectContainer container) {
        Metadata.SimpleManifestComposer smc = new Metadata.SimpleManifestComposer();
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            Metadata m;
            String name = entry.getKey();
            Object item = entry.getValue();
            if (item == null) {
                throw new NullPointerException();
            }
            if (item instanceof HashMap) {
                if (this.persistent()) {
                    container.activate(item, 2);
                }
                if ((m = this.makeMetadata((HashMap)item, container)) == null) {
                    throw new NullPointerException("HERE!!");
                }
            } else {
                if (this.persistent()) {
                    container.activate(item, 2);
                }
                if ((m = ((PutHandler)item).metadata) == null) {
                    throw new NullPointerException("HERE!!" + item);
                }
                if (this.persistent()) {
                    container.deactivate(item, 1);
                }
            }
            smc.addItem(name, m);
        }
        return smc.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAndStartBase(ObjectContainer container, ClientContext context) {
        Bucket bucket = null;
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.hasResolvedBase) {
                return;
            }
        }
        try {
            if (this.persistent()) {
                container.activate((Object)this.baseMetadata, Integer.MAX_VALUE);
            }
            bucket = BucketTools.makeImmutableBucket(context.getBucketFactory(this.persistent()), this.baseMetadata.writeToByteArray());
            if (logMINOR) {
                Logger.minor(this, "Metadata bucket is " + bucket.size() + " bytes long");
            }
        }
        catch (IOException e) {
            this.fail(new InsertException(2, e, null), container, context);
            return;
        }
        catch (MetadataUnresolvedException e) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Main metadata needs resolving: " + e);
                }
                this.resolve(e, container, context);
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                return;
            }
            catch (IOException e1) {
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                this.fail(new InsertException(2, e, null), container, context);
                return;
            }
            catch (InsertException e2) {
                if (this.persistent()) {
                    container.deactivate((Object)this.baseMetadata, 1);
                }
                this.fail(e2, container, context);
                return;
            }
        }
        if (bucket == null) {
            return;
        }
        BaseManifestPutter e = this;
        synchronized (e) {
            if (this.hasResolvedBase) {
                return;
            }
            this.hasResolvedBase = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        InsertBlock block = new InsertBlock(bucket, null, this.persistent() ? this.targetURI.clone() : this.targetURI);
        try {
            this.rootMetaPutHandler = new MetaPutHandler(this, null, block, this.getCHKOnly, container);
            if (logMINOR) {
                Logger.minor(this, "Inserting main metadata: " + this.rootMetaPutHandler + " for " + this.baseMetadata);
            }
            if (this.persistent()) {
                container.deactivate((Object)this.baseMetadata, 1);
            }
            this.rootMetaPutHandler.start(container, context);
        }
        catch (InsertException e2) {
            this.fail(e2, container, context);
            return;
        }
        if (this.persistent()) {
            container.deactivate((Object)this.rootMetaPutHandler, 1);
        }
    }

    private void resolve(MetadataUnresolvedException e, ObjectContainer container, ClientContext context) throws InsertException, IOException {
        Metadata[] metas;
        new Error("RefactorME-resolve").printStackTrace();
        for (Metadata m : metas = e.mustResolve) {
            if (this.persistent()) {
                container.activate((Object)m, 100);
            }
            if (logMINOR) {
                Logger.minor(this, "Resolving " + m);
            }
            if (m.isResolved()) {
                Logger.error(this, "Already resolved: " + m + " in resolve() - race condition???");
                if (!this.persistent()) continue;
                container.deactivate((Object)m, 1);
                continue;
            }
            try {
                MetaPutHandler ph = new MetaPutHandler(this, null, m, this.getCHKOnly, context.getBucketFactory(this.persistent()), container);
                ph.start(container, context);
                if (!this.persistent()) continue;
                container.deactivate((Object)ph, 1);
                container.deactivate((Object)m, 1);
            }
            catch (MetadataUnresolvedException e1) {
                this.resolve(e1, container, context);
                container.deactivate((Object)m, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryComplete(ObjectContainer container, ClientContext context) {
        if (logDEBUG) {
            Logger.debug(this, "try complete", (Throwable)new Error("trace tryComplete()"));
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished || this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Already " + (this.finished ? "finished" : "cancelled"));
                }
                if (this.persistent()) {
                    container.store((Object)this);
                }
                return;
            }
            if (!this.runningPutHandlers.isEmpty()) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, runningPutHandlers not empty.");
                }
                return;
            }
            if (!this.containerPutHandlers.isEmpty()) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, containerPutHandlers not empty.");
                }
                return;
            }
            if (this.containerMode) {
                if (this.rootContainerPutHandler != null) {
                    if (logDEBUG) {
                        Logger.debug(this, "Not finished, rootContainerPutHandler not empty.");
                    }
                    return;
                }
            } else if (this.rootMetaPutHandler != null) {
                if (logDEBUG) {
                    Logger.debug(this, "Not finished, rootMetaPutHandler not empty.");
                }
                return;
            }
            this.finished = true;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.complete(container, context);
    }

    private void complete(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        boolean deactivateCB = false;
        if (this.persistent()) {
            deactivateCB = !container.ext().isActive((Object)this.cb);
            container.activate((Object)this.cb, 1);
        }
        this.cb.onSuccess(this, container);
        if (deactivateCB) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    private void fail(Exception e, ObjectContainer container, ClientContext context) {
        InsertException ie = new InsertException(3, e, null);
        this.fail(ie, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(InsertException e, ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        this.cancelAndFinish(container, context);
        if (this.persistent()) {
            this.removePutHandlers(container, context);
        }
        if (this.persistent()) {
            container.activate((Object)this.cb, 1);
        }
        this.cb.onFailure(e, this, container);
    }

    private void removePutHandlers(ObjectContainer container, ClientContext context) {
        PutHandler[] handlers;
        new Error("RefactorME").printStackTrace();
        container.activate(this.runningPutHandlers, 2);
        container.activate(this.putHandlersWaitingForMetadata, 2);
        container.activate(this.putHandlerWaitingForBlockSets, 2);
        container.activate(this.putHandlersWaitingForFetchable, 2);
        if (!this.runningPutHandlers.isEmpty()) {
            Logger.error(this, "Running put handlers not part of putHandlersByName: " + this.runningPutHandlers.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still running, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.runningPutHandlers.clear();
        }
        if (!this.putHandlersWaitingForMetadata.isEmpty()) {
            Logger.error(this, "Put handlers waiting for metadata, not part of putHandlersByName: " + this.putHandlersWaitingForMetadata.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForMetadata.toArray(new PutHandler[this.putHandlersWaitingForMetadata.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for metadata, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForMetadata.clear();
        }
        if (!this.putHandlerWaitingForBlockSets.isEmpty()) {
            Logger.error(this, "Put handlers waiting for block sets, not part of putHandlersByName: " + this.putHandlerWaitingForBlockSets.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlerWaitingForBlockSets.toArray(new PutHandler[this.putHandlerWaitingForBlockSets.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for block set, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlerWaitingForBlockSets.clear();
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            Logger.error(this, "Put handlers waiting for fetchable, not part of putHandlersByName: " + this.putHandlersWaitingForFetchable.size() + " in removePutHandlers() on " + this, (Throwable)new Exception("error"));
            for (PutHandler handler : handlers = this.putHandlersWaitingForFetchable.toArray(new PutHandler[this.putHandlersWaitingForFetchable.size()])) {
                container.activate((Object)handler, 1);
                Logger.error(this, "Still waiting for fetchable, but not in putHandlersByName: " + handler);
                handler.cancel();
                handler.removeFrom(container, context);
            }
            this.putHandlersWaitingForFetchable.clear();
        }
        container.delete(this.runningPutHandlers);
        container.delete(this.putHandlersWaitingForMetadata);
        container.delete(this.putHandlerWaitingForBlockSets);
        container.delete(this.putHandlersWaitingForFetchable);
        this.runningPutHandlers = null;
        this.putHandlersWaitingForMetadata = null;
        this.putHandlerWaitingForBlockSets = null;
        this.putHandlersWaitingForFetchable = null;
        container.store((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndFinish(ObjectContainer container, ClientContext context) {
        PutHandler[] running;
        boolean persistent = this.persistent();
        if (persistent) {
            container.activate(this.runningPutHandlers, 2);
        }
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            running = this.runningPutHandlers.toArray(new PutHandler[this.runningPutHandlers.size()]);
        }
        if (logMINOR) {
            Logger.minor(this, "PutHandler's to cancel: " + running.length);
        }
        for (PutHandler putter : running) {
            boolean active = true;
            if (persistent && !(active = container.ext().isActive((Object)putter))) {
                container.activate((Object)putter, 1);
            }
            putter.cancel(container, context);
            if (!active) {
                container.deactivate((Object)putter, 1);
            }
            if (!persistent) continue;
            container.activate((Object)this, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            if (this.finished) {
                return;
            }
            if (super.cancel()) {
                return;
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.fail(new InsertException(10), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlock(ObjectContainer container) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            ++this.minSuccessFetchBlocks;
        }
        super.addBlock(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlocks(int num, ObjectContainer container) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.minSuccessFetchBlocks += num;
        }
        super.addBlocks(num, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMustSucceedBlocks(int blocks, ObjectContainer container) {
        BaseManifestPutter baseManifestPutter = this;
        synchronized (baseManifestPutter) {
            this.minSuccessFetchBlocks += blocks;
        }
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    public void addRedundantBlocks(int blocks, ObjectContainer container) {
        super.addMustSucceedBlocks(blocks, container);
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, this.minSuccessBlocks, this.minSuccessFetchBlocks, this.blockSetFinalized), container, context);
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return this.minSuccessFetchBlocks;
    }

    @Override
    public void blockSetFinalized(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.deactivate(this.putHandlerWaitingForBlockSets, 1);
        }
        super.blockSetFinalized(container, context);
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    @Override
    public int countFiles() {
        return this.numberOfFiles;
    }

    @Override
    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public void onMajorProgress(ObjectContainer container) {
        boolean deactivate = false;
        if (this.persistent()) {
            boolean bl = deactivate = !container.ext().isActive((Object)this.cb);
            if (deactivate) {
                container.activate((Object)this.cb, 1);
            }
        }
        this.cb.onMajorProgress(container);
        if (deactivate) {
            container.deactivate((Object)this.cb, 1);
        }
    }

    protected void onFetchable(PutHandler handler, ObjectContainer container) {
        if (this.persistent()) {
            container.activate(this.putHandlersWaitingForFetchable, 2);
        }
        if (this.checkFetchable(handler)) {
            if (this.persistent()) {
                container.ext().store(this.putHandlersWaitingForMetadata, 2);
                container.store((Object)this);
                container.deactivate(this.putHandlersWaitingForFetchable, 1);
                container.activate((Object)this.cb, 1);
            }
            this.cb.onFetchable(this, container);
            if (this.persistent()) {
                container.deactivate((Object)this.cb, 1);
            }
        } else if (this.persistent()) {
            container.deactivate(this.putHandlersWaitingForFetchable, 1);
        }
    }

    private synchronized boolean checkFetchable(PutHandler handler) {
        if (!this.putHandlersWaitingForFetchable.remove(handler)) {
            throw new IllegalStateException("was not in putHandlersWaitingForFetchable! : " + handler);
        }
        if (this.fetchable) {
            return false;
        }
        if (!this.putHandlersWaitingForFetchable.isEmpty()) {
            return false;
        }
        this.fetchable = true;
        return true;
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
    }

    @Override
    public void onTransition(ClientPutState from, ClientPutState to, ObjectContainer container) {
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        if (logDEBUG) {
            Logger.debug(this, "removeFrom", (Throwable)new Exception("debug"));
        }
        if (this.finalURI != null) {
            container.activate((Object)this.finalURI, 5);
            this.finalURI.removeFrom(container);
        }
        container.activate((Object)this.targetURI, 5);
        this.targetURI.removeFrom(container);
        container.activate((Object)this.ctx, 1);
        this.ctx.removeFrom(container);
        if (this.baseMetadata != null) {
            container.activate((Object)this.baseMetadata, 1);
            this.baseMetadata.removeFrom(container);
        }
        container.activate((Object)this.runGotAllMetadata, 1);
        container.delete((Object)this.runGotAllMetadata);
        super.removeFrom(container, context);
    }

    public void objectOnUpdate(ObjectContainer container) {
        if (logDEBUG) {
            Logger.debug(this, "Updating " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
        }
    }

    @Override
    public boolean objectCanNew(ObjectContainer container) {
        if (this.finished) {
            Logger.error(this, "Storing " + this + " when already finished!", (Throwable)new Exception("error"));
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
        }
        return true;
    }

    private void tryStartParentContainer(PutHandler containerHandle2, ObjectContainer container, ClientContext context) throws InsertException {
        if (containerHandle2 == null) {
            throw new NullPointerException();
        }
        if (this.perContainerPutHandlersWaitingForMetadata.get(containerHandle2).isEmpty()) {
            this.perContainerPutHandlersWaitingForMetadata.remove(containerHandle2);
            if (this.persistent()) {
                container.ext().store(this.perContainerPutHandlersWaitingForMetadata, 2);
            }
            containerHandle2.start(container, context);
        } else if (logMINOR) {
            Logger.minor(this, "(spc) waiting m:" + this.perContainerPutHandlersWaitingForMetadata.get(containerHandle2).size() + " for " + containerHandle2);
        }
    }

    protected final ClientMetadata guessMime(String name, ManifestElement me) {
        return this.guessMime(name, me.mimeOverride);
    }

    protected final ClientMetadata guessMime(String name, String mimetype) {
        String mimeType = mimetype;
        if (mimeType == null && name != null) {
            mimeType = DefaultMIMETypes.guessMIMEType(name, true);
        }
        ClientMetadata cm = mimeType == null || mimeType.equals("application/octet-stream") ? null : new ClientMetadata(mimeType);
        return cm;
    }

    public ContainerBuilder makeArchive() {
        return new ContainerBuilder(false, null, null, true);
    }

    protected ContainerBuilder getRootContainer() {
        if (this.freeformMode) {
            throw new IllegalStateException("Already in freeform mode!");
        }
        if (!this.containerMode) {
            this.containerMode = true;
            this.rootContainerBuilder = new ContainerBuilder(true);
        }
        return this.rootContainerBuilder;
    }

    protected FreeFormBuilder getRootBuilder() {
        if (this.containerMode) {
            throw new IllegalStateException("Already in container mode!");
        }
        if (!this.freeformMode) {
            this.freeformMode = true;
            this.rootBuilder = new FreeFormBuilder();
        }
        return this.rootBuilder;
    }

    static {
        Logger.registerClass(BaseManifestPutter.class);
        defaultDefaultNames = new String[]{"index.html", "index.htm", "default.html", "default.htm"};
    }

    protected final class ContainerBuilder
    extends ManifestBuilder {
        private final HashMap<String, Object> _rootDir;
        private final PutHandler selfHandle;

        private ContainerBuilder(boolean isRoot) {
            this(isRoot, null, null, false);
        }

        private ContainerBuilder(PutHandler parent, String name) {
            this(false, parent, name, false);
        }

        private ContainerBuilder(boolean isRoot, PutHandler parent, String name, boolean isArchive) {
            if (!BaseManifestPutter.this.containerMode) {
                throw new IllegalStateException("You can not add containers in free form mode!");
            }
            this._rootDir = new HashMap();
            this.selfHandle = isArchive ? new ArchivePutHandler(BaseManifestPutter.this, parent, name, this._rootDir, isRoot ? BaseManifestPutter.this.targetURI : FreenetURI.EMPTY_CHK_URI, BaseManifestPutter.this.getCHKOnly) : new ContainerPutHandler(BaseManifestPutter.this, parent, name, this._rootDir, isRoot ? BaseManifestPutter.this.targetURI : FreenetURI.EMPTY_CHK_URI, null, BaseManifestPutter.this.getCHKOnly, isRoot ? null : BaseManifestPutter.this.containerPutHandlers);
            this.currentDir = this._rootDir;
            if (isRoot) {
                BaseManifestPutter.this.rootContainerPutHandler = (ContainerPutHandler)this.selfHandle;
            } else {
                BaseManifestPutter.this.containerPutHandlers.add(this.selfHandle);
            }
            BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.put(this.selfHandle, new HashSet());
            if (isArchive) {
                BaseManifestPutter.this.putHandlersArchiveTransformMap.put((ArchivePutHandler)this.selfHandle, new Vector());
            }
        }

        public ContainerBuilder makeSubContainer(String name) {
            ContainerBuilder subCon = new ContainerBuilder(this.selfHandle, name);
            this.currentDir.put(name, subCon.selfHandle);
            BaseManifestPutter.this.putHandlersTransformMap.put(subCon.selfHandle, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(subCon.selfHandle);
            return subCon;
        }

        public void addItem(String name, String nameInArchive, ManifestElement element, boolean isDefaultDoc) {
            ManifestElement me = new ManifestElement(element, name, nameInArchive);
            this.addItem(name, me, isDefaultDoc);
        }

        private void addItem(String name, ManifestElement element, boolean isDefaultDoc) {
            this.currentDir.put(name, element);
            if (isDefaultDoc) {
                Metadata m = new Metadata(6, null, null, name, null);
                this.currentDir.put("", m);
            }
        }

        @Override
        public void addRedirect(String name, FreenetURI targetUri, ClientMetadata cm, boolean isDefaultDoc) {
            Metadata m = new Metadata(0, null, null, targetUri, cm);
            this.currentDir.put(name, m);
            if (isDefaultDoc) {
                this.currentDir.put("", m);
            }
        }

        @Override
        public void addExternal(String name, Bucket data, ClientMetadata cm, boolean isDefaultDoc) {
            ExternPutHandler ph = new ExternPutHandler(BaseManifestPutter.this, this.selfHandle, name, data, cm, BaseManifestPutter.this.getCHKOnly);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(ph);
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
            if (isDefaultDoc) {
                Metadata m = new Metadata(6, null, null, name, null);
                this.currentDir.put("", m);
            }
        }

        public void addArchiveItem(ContainerBuilder archive, String name, ManifestElement element, boolean isDefaultDoc) {
            assert (element.getData() != null);
            archive.addItem(name, element, false);
            JokerPutHandler ph = new JokerPutHandler(BaseManifestPutter.this, this.selfHandle, name, BaseManifestPutter.this.guessMime(name, element.mimeOverride));
            BaseManifestPutter.this.putHandlersTransformMap.put(ph, this.currentDir);
            ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.selfHandle)).add(ph);
            ((Vector)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(archive.selfHandle)).add(ph);
            if (isDefaultDoc) {
                Metadata m = new Metadata(6, null, null, name, null);
                this.currentDir.put("", m);
            }
        }
    }

    protected final class FreeFormBuilder
    extends ManifestBuilder {
        protected FreeFormBuilder() {
            BaseManifestPutter.this.rootDir = new HashMap();
            this.currentDir = BaseManifestPutter.this.rootDir;
        }

        @Override
        public void addExternal(String name, Bucket data, ClientMetadata cm, boolean isDefaultDoc) {
            PutHandler ph = new ExternPutHandler(BaseManifestPutter.this, null, name, data, cm, BaseManifestPutter.this.getCHKOnly);
            if (logMINOR) {
                Logger.minor(this, "Inserting separately as PutHandler: " + name + " : " + ph + " persistent=" + ph.persistent());
            }
            BaseManifestPutter.this.numberOfFiles++;
            BaseManifestPutter.this.totalSize += data.size();
            this.currentDir.put(name, ph);
            if (isDefaultDoc) {
                ph = new JokerPutHandler(BaseManifestPutter.this, null, name, name);
                this.currentDir.put("", ph);
            }
        }

        @Override
        public void addRedirect(String name, FreenetURI targetURI2, ClientMetadata cm, boolean isDefaultDoc) {
            JokerPutHandler ph = new JokerPutHandler(BaseManifestPutter.this, name, targetURI2, cm);
            this.currentDir.put(name, ph);
            if (isDefaultDoc) {
                this.currentDir.put("", ph);
            }
        }
    }

    protected abstract class ManifestBuilder {
        private final Stack<HashMap<String, Object>> dirStack = new Stack();
        protected HashMap<String, Object> currentDir;

        private ClientMetadata makeClientMetadata(String mime) {
            if (mime == null) {
                return null;
            }
            ClientMetadata cm = new ClientMetadata(mime.trim());
            if (cm.isTrivial()) {
                return null;
            }
            return cm;
        }

        ManifestBuilder() {
        }

        public void pushCurrentDir() {
            this.dirStack.push(this.currentDir);
        }

        public void popCurrentDir() {
            this.currentDir = this.dirStack.pop();
        }

        public void makeSubDirCD(String name) {
            Object dir = this.currentDir.get(name);
            this.currentDir = dir != null ? Metadata.forceMap(dir) : this.makeSubDir(this.currentDir, name);
        }

        private HashMap<String, Object> makeSubDir(HashMap<String, Object> parentDir, String name) {
            if (parentDir.containsKey(name)) {
                throw new IllegalStateException("Item '" + name + "' already exist!");
            }
            HashMap<String, Object> newDir = new HashMap<String, Object>();
            parentDir.put(name, newDir);
            return newDir;
        }

        public final void addElement(String name, ManifestElement element, boolean isDefaultDoc) {
            ClientMetadata cm = this.makeClientMetadata(element.mimeOverride);
            if (element.data != null) {
                this.addExternal(name, element.data, cm, isDefaultDoc);
                return;
            }
            if (element.targetURI != null) {
                this.addRedirect(name, element.targetURI, cm, isDefaultDoc);
                return;
            }
            throw new IllegalStateException("ME is neither a redirect nor dircet data. " + element);
        }

        public final void addExternal(String name, Bucket data, String mimeOverride, boolean isDefaultDoc) {
            assert (data != null);
            ClientMetadata cm = this.makeClientMetadata(mimeOverride);
            this.addExternal(name, data, cm, isDefaultDoc);
        }

        public final void addRedirect(String name, FreenetURI targetUri, String mimeOverride, boolean isDefaultDoc) {
            ClientMetadata cm = this.makeClientMetadata(mimeOverride);
            this.addRedirect(name, targetUri, cm, isDefaultDoc);
        }

        public abstract void addExternal(String var1, Bucket var2, ClientMetadata var3, boolean var4);

        public abstract void addRedirect(String var1, FreenetURI var2, ClientMetadata var3, boolean var4);
    }

    private abstract class PutHandler
    extends BaseClientPutter
    implements PutCompletionCallback {
        protected ClientPutState origSFI;
        private ClientPutState currentState;
        protected ClientMetadata cm;
        protected Metadata metadata;
        private String targetInArchive;
        protected final String itemName;
        protected final boolean persistent;
        protected final PutHandler parentPutHandler;
        protected int minSuccessFetchBlocks;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PutHandler(BaseManifestPutter bmp, PutHandler parent, String name, ClientMetadata cm, HashSet<PutHandler> runningMap, ObjectContainer container) {
            HashSet hashSet;
            super(bmp.priorityClass, bmp.client);
            this.persistent = bmp.persistent();
            this.cm = cm;
            this.itemName = name;
            this.metadata = null;
            this.parentPutHandler = parent;
            if (runningMap != null) {
                hashSet = runningMap;
                synchronized (hashSet) {
                    if (runningMap.contains(this)) {
                        Logger.error(this, "PutHandler already in 'runningMap': " + runningMap, (Throwable)new Error("error"));
                    } else {
                        runningMap.add(this);
                        if (container != null) {
                            container.ext().store((Object)runningMap, 2);
                        }
                    }
                }
            }
            hashSet = BaseManifestPutter.this.putHandlerWaitingForBlockSets;
            synchronized (hashSet) {
                if (BaseManifestPutter.this.putHandlerWaitingForBlockSets.contains(this)) {
                    Logger.error(this, "PutHandler already in 'waitingForBlockSets'!", (Throwable)new Error("error"));
                } else {
                    BaseManifestPutter.this.putHandlerWaitingForBlockSets.add(this);
                    if (container != null) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
                    }
                }
            }
            hashSet = BaseManifestPutter.this.putHandlersWaitingForFetchable;
            synchronized (hashSet) {
                if (BaseManifestPutter.this.putHandlersWaitingForFetchable.contains(this)) {
                    Logger.error(this, "PutHandler already in 'waitingForFetchable'!", (Throwable)new Error("error"));
                } else {
                    BaseManifestPutter.this.putHandlersWaitingForFetchable.add(this);
                    if (container != null) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 2);
                    }
                }
            }
        }

        private PutHandler(BaseManifestPutter bmp, PutHandler parent, String name, String nameInArchive, Metadata md, ClientMetadata cm) {
            super(bmp.priorityClass, bmp.client);
            this.persistent = bmp.persistent();
            this.cm = cm;
            this.itemName = name;
            this.origSFI = null;
            this.metadata = md;
            this.parentPutHandler = parent;
            this.targetInArchive = nameInArchive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ObjectContainer container, ClientContext context) throws InsertException {
            ClientPutState sfi;
            boolean ok;
            HashSet hashSet;
            if (logDEBUG) {
                Logger.debug(this, "Starting a PutHandler for '" + this.itemName + "' " + this);
            }
            if (this.origSFI == null) {
                BaseManifestPutter.this.fail(new IllegalStateException("origSFI is null on start(), impossible"), container, context);
            }
            if (!(this instanceof MetaPutHandler) && this.metadata != null) {
                BaseManifestPutter.this.fail(new IllegalStateException("metdata=" + this.metadata + " on start(), impossible"), container, context);
            }
            if (this instanceof ContainerPutHandler || this instanceof ArchivePutHandler) {
                if (this != BaseManifestPutter.this.rootContainerPutHandler) {
                    hashSet = BaseManifestPutter.this.containerPutHandlers;
                    synchronized (hashSet) {
                        ok = BaseManifestPutter.this.containerPutHandlers.contains(this);
                    }
                    if (!ok) {
                        throw new IllegalStateException("Starting a PutHandler thats not in 'containerPutHandlers'! " + this);
                    }
                }
            } else if (this != BaseManifestPutter.this.rootMetaPutHandler) {
                hashSet = BaseManifestPutter.this.runningPutHandlers;
                synchronized (hashSet) {
                    ok = BaseManifestPutter.this.runningPutHandlers.contains(this);
                }
                if (!ok) {
                    throw new IllegalStateException("Starting a PutHandler thats not in 'runningPutHandlers'! " + this);
                }
            }
            if (this.persistent && !container.ext().isActive((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets)) {
                new Error("why deactivated? putHandlerWaitingForBlockSets " + this + " [" + BaseManifestPutter.this + "]").printStackTrace();
                container.activate((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
            }
            hashSet = BaseManifestPutter.this.putHandlerWaitingForBlockSets;
            synchronized (hashSet) {
                ok = BaseManifestPutter.this.putHandlerWaitingForBlockSets.contains(this);
            }
            if (!ok) {
                Logger.error(this, "Starting a PutHandler thats not in 'waitingForBlockSets'! " + this, (Throwable)new Error("error"));
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.currentState = sfi = this.origSFI;
                this.origSFI = null;
            }
            if (this.persistent) {
                container.activate((Object)sfi, 1);
                container.store((Object)this);
            }
            sfi.schedule(container, context);
            if (this.persistent) {
                container.deactivate((Object)sfi, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
            }
            ClientPutState oldState = null;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.cancelled) {
                    return;
                }
                super.cancel();
                oldState = this.currentState;
            }
            if (this.persistent()) {
                container.store((Object)this);
                if (oldState != null) {
                    container.activate((Object)oldState, 1);
                }
            }
            if (oldState != null) {
                oldState.cancel(container, context);
            }
            this.onFailure(new InsertException(10), null, container, context);
        }

        @Override
        public FreenetURI getURI() {
            return null;
        }

        @Override
        public boolean isFinished() {
            if (logMINOR) {
                Logger.minor(this, "Finished " + this, (Throwable)new Exception("debug"));
            }
            return BaseManifestPutter.this.finished || this.cancelled || BaseManifestPutter.this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            Throwable t;
            StackTraceElement te;
            if (!(!logDEBUG || "BaseManifestPutter.java".equals((te = (t = new Throwable("DEBUG onSuccess")).getStackTrace()[1]).getFileName()) && "onSuccess".equals(te.getMethodName()))) {
                Logger.error(this, "Not called via super", t);
            }
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
                container.activate((Object)BaseManifestPutter.this.runningPutHandlers, 2);
            }
            if (BaseManifestPutter.this.putHandlersWaitingForFetchable.contains(this)) {
                BaseManifestPutter.this.onFetchable(this, container);
            }
            BaseClientPutter baseClientPutter = this;
            synchronized (baseClientPutter) {
                oldState = this.currentState;
                this.currentState = null;
            }
            baseClientPutter = BaseManifestPutter.this;
            synchronized (baseClientPutter) {
                if (this.persistent) {
                    container.store((Object)this);
                }
                BaseManifestPutter.this.runningPutHandlers.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.runningPutHandlers, 2);
                    container.activate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                }
                if (BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this)) {
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                    }
                    Logger.error(this, "PutHandler '" + this.itemName + "' was in waitingForMetadata in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 1);
                    container.activate((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
                }
                if (BaseManifestPutter.this.putHandlerWaitingForBlockSets.remove(this)) {
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
                    }
                    Logger.error(this, "PutHandler was in waitingForBlockSets in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 1);
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 1);
                    container.activate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 2);
                }
                if (BaseManifestPutter.this.putHandlersWaitingForFetchable.remove(this)) {
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 2);
                    }
                    Logger.error(this, "PutHandler was in waitingForFetchable in onSuccess() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Error("debug"));
                }
                if (this.persistent) {
                    container.deactivate((Object)BaseManifestPutter.this.putHandlersWaitingForFetchable, 1);
                }
                if (!BaseManifestPutter.this.runningPutHandlers.isEmpty() && logMINOR) {
                    Logger.minor(this, "Running put handlers: " + BaseManifestPutter.this.runningPutHandlers.size());
                    for (PutHandler o : BaseManifestPutter.this.runningPutHandlers) {
                        boolean activated = true;
                        if (this.persistent && !(activated = container.ext().isActive((Object)o))) {
                            container.activate((Object)o, 1);
                        }
                        Logger.minor(this, "Still running: " + o);
                        if (activated) continue;
                        container.deactivate((Object)o, 1);
                    }
                }
            }
            if (this.persistent) {
                if (oldState != null && oldState != state) {
                    container.activate((Object)oldState, 1);
                    oldState.removeFrom(container, context);
                } else if (state != null) {
                    state.removeFrom(container, context);
                }
            }
            BaseManifestPutter.this.tryComplete(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this.runningPutHandlers, 1);
                container.deactivate((Object)BaseManifestPutter.this, 1);
                this.removeFrom(container, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(InsertException e, ClientPutState state, ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldState = this.currentState;
                this.currentState = null;
            }
            if (oldState != null && oldState != state && this.persistent) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            } else if (state != null && this.persistent) {
                state.removeFrom(container, context);
            }
            if (logMINOR) {
                Logger.minor(this, "Failed: " + this + " - " + e, (Throwable)e);
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.fail(e, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransition(ClientPutState oldState, ClientPutState newState, ObjectContainer container) {
            if (newState == null) {
                throw new NullPointerException();
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                if (this.currentState == oldState) {
                    this.currentState = newState;
                    if (this.persistent()) {
                        container.store((Object)this);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
                    }
                    return;
                }
                Logger.error(this, "Ignoring onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState + " for " + this);
            }
        }

        @Override
        public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onMetadata(Bucket meta, ClientPutState state, ObjectContainer container, ClientContext context) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlock(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addBlock(container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                ++this.minSuccessFetchBlocks;
            }
            super.addBlock(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlocks(int num, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addBlocks(num, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += num;
            }
            super.addBlocks(num, container);
        }

        @Override
        public void completedBlock(boolean dontNotify, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.completedBlock(dontNotify, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            super.completedBlock(dontNotify, container, context);
        }

        @Override
        public void failedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.failedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            super.failedBlock(container, context);
        }

        @Override
        public void fatallyFailedBlock(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.fatallyFailedBlock(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            super.fatallyFailedBlock(container, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addMustSucceedBlocks(int blocks, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addMustSucceedBlocks(blocks, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                this.minSuccessFetchBlocks += blocks;
            }
            super.addMustSucceedBlocks(blocks, container);
        }

        @Override
        public synchronized void addRedundantBlocks(int blocks, ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.addRedundantBlocks(blocks, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
            super.addRedundantBlocks(blocks, container);
        }

        @Override
        public synchronized int getMinSuccessFetchBlocks() {
            return this.minSuccessFetchBlocks;
        }

        @Override
        public void notifyClients(ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.notifyClients(container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBlockSetFinished(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
                container.activate((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
            }
            boolean allBlockSets = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                BaseManifestPutter.this.putHandlerWaitingForBlockSets.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 2);
                }
                allBlockSets = BaseManifestPutter.this.freeformMode ? BaseManifestPutter.this.hasResolvedBase && BaseManifestPutter.this.putHandlerWaitingForBlockSets.isEmpty() : BaseManifestPutter.this.putHandlerWaitingForBlockSets.isEmpty();
            }
            if (allBlockSets) {
                BaseManifestPutter.this.blockSetFinalized(container, context);
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this.putHandlerWaitingForBlockSets, 1);
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onMajorProgress(ObjectContainer container) {
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.onMajorProgress(container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onFetchable(ClientPutState state, ObjectContainer container) {
            if (logMINOR) {
                Logger.minor(this, "onFetchable " + this, (Throwable)new Exception("debug"));
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            BaseManifestPutter.this.onFetchable(this, container);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrom(ObjectContainer container, ClientContext context) {
            ClientPutState oldState;
            ClientPutState oldSFI;
            if (logMINOR) {
                Logger.minor(this, "Removing " + this);
            }
            PutHandler putHandler = this;
            synchronized (putHandler) {
                oldSFI = this.origSFI;
                oldState = this.currentState;
                this.origSFI = null;
                this.currentState = null;
            }
            if (oldSFI != null) {
                Logger.error(this, "origSFI is set in removeFrom() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Exception("debug"));
                container.activate((Object)oldSFI, 1);
                oldSFI.cancel(container, context);
                oldSFI.removeFrom(container, context);
                if (oldState == oldSFI) {
                    oldState = null;
                }
            }
            if (oldState != null) {
                Logger.error(this, "currentState is set in removeFrom() on " + this + " for " + BaseManifestPutter.this, (Throwable)new Exception("debug"));
                container.activate((Object)oldState, 1);
                oldState.cancel(container, context);
                oldState.removeFrom(container, context);
            }
            if (this.cm != null) {
                container.activate((Object)this.cm, 5);
                this.cm.removeFrom(container);
            }
            if (this.metadata != null) {
                Logger.normal(this, "Metadata is set in removeFrom() on " + this + " for " + BaseManifestPutter.this);
                container.activate((Object)this.metadata, 1);
                this.metadata.removeFrom(container);
            }
            super.removeFrom(container, context);
        }

        @Override
        public boolean objectCanNew(ObjectContainer container) {
            if (this.cancelled) {
                Logger.error(this, "Storing " + this + " when already cancelled!", (Throwable)new Exception("error"));
                return false;
            }
            if (logDEBUG) {
                Logger.debug(this, "Storing " + this + " activated=" + container.ext().isActive((Object)this) + " stored=" + container.ext().isStored((Object)this), (Throwable)new Exception("debug"));
            }
            return true;
        }

        public String toString() {
            if (logDEBUG) {
                return super.toString() + " {" + this.itemName + '}';
            }
            return super.toString();
        }

        @Override
        protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        }
    }

    private final class JokerPutHandler
    extends PutHandler {
        public JokerPutHandler(BaseManifestPutter bmp, String name, FreenetURI targetURI2, ClientMetadata cm2) {
            Metadata m;
            super(bmp, null, name, null, (Metadata)null, cm2);
            this.metadata = m = new Metadata(0, null, null, targetURI2, cm2);
        }

        public JokerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, ClientMetadata cm2) {
            super(bmp, parent, name, name, (Metadata)null, cm2);
        }

        public JokerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, String target) {
            Metadata m;
            super(bmp, parent, name, name, (Metadata)null, null);
            this.metadata = m = new Metadata(6, null, null, target, null);
        }
    }

    private final class MetaPutHandler
    extends PutHandler {
        private MetaPutHandler(BaseManifestPutter smp, PutHandler parent, InsertBlock insertBlock, boolean getCHKOnly, ObjectContainer container) {
            super(smp, parent, null, null, null, container);
            this.origSFI = new SingleFileInserter(this, this, insertBlock, true, BaseManifestPutter.this.ctx, this.realTimeFlag, false, getCHKOnly, false, null, null, true, null, BaseManifestPutter.this.earlyEncode, true, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, null, -1L);
            if (logMINOR) {
                Logger.minor(this, "Inserting root metadata: " + this.origSFI);
            }
        }

        private MetaPutHandler(BaseManifestPutter smp, PutHandler parent, Metadata toResolve, boolean getCHKOnly, BucketFactory bf, ObjectContainer container) throws MetadataUnresolvedException, IOException {
            super(smp, parent, null, null, BaseManifestPutter.this.runningPutHandlers, container);
            Bucket b = toResolve.toBucket(bf);
            this.metadata = toResolve;
            InsertBlock ib = new InsertBlock(b, null, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, ib, true, BaseManifestPutter.this.ctx, this.realTimeFlag, false, getCHKOnly, false, toResolve, null, true, null, BaseManifestPutter.this.earlyEncode, true, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, null, -1L);
            if (logMINOR) {
                Logger.minor(this, "Inserting subsidiary metadata: " + this.origSFI + " for " + toResolve);
            }
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            if (BaseManifestPutter.this.rootMetaPutHandler == this) {
                BaseManifestPutter.this.finalURI = key.getURI();
                if (this.persistent()) {
                    container.activate((Object)BaseManifestPutter.this.cb, 1);
                }
                BaseManifestPutter.this.cb.onGeneratedURI(this.persistent() ? BaseManifestPutter.this.finalURI.clone() : BaseManifestPutter.this.finalURI, this, container);
                if (this.persistent()) {
                    container.deactivate((Object)BaseManifestPutter.this.cb, 1);
                    container.store((Object)this);
                }
                return;
            }
            this.metadata.resolve(key.getURI());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            boolean wasRoot = false;
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                if (BaseManifestPutter.this.rootMetaPutHandler == this) {
                    BaseManifestPutter.this.rootMetaPutHandler = null;
                    wasRoot = true;
                }
            }
            if (!wasRoot) {
                BaseManifestPutter.this.resolveAndStartBase(container, context);
            }
            super.onSuccess(state, container, context);
        }
    }

    private final class ExternPutHandler
    extends PutHandler {
        private ExternPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, Bucket data, ClientMetadata cm2, boolean getCHKOnly2) {
            super(bmp, parent, name, cm2, BaseManifestPutter.this.runningPutHandlers, null);
            InsertBlock block = new InsertBlock(data, this.cm, this.persistent() ? FreenetURI.EMPTY_CHK_URI.clone() : FreenetURI.EMPTY_CHK_URI);
            this.origSFI = new SingleFileInserter(this, this, block, false, BaseManifestPutter.this.ctx, this.realTimeFlag, false, getCHKOnly2, true, null, null, false, null, BaseManifestPutter.this.earlyEncode, false, this.persistent(), 0L, 0L, null, BaseManifestPutter.this.cryptoAlgorithm, BaseManifestPutter.this.forceCryptoKey, -1L);
        }

        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key + ") for " + this);
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata: " + this.metadata, (Throwable)new Exception("debug"));
            }
            if (this.persistent) {
                container.activate((Object)key, 5);
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            Metadata m = new Metadata(0, null, null, key.getURI(), this.cm);
            this.onMetadata(m, state, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadata(Metadata m, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Assigning metadata: " + m + " for '" + this.itemName + "' " + this + " from " + state + " persistent=" + this.persistent);
            }
            if (this.metadata != null) {
                Logger.error(this, "Reassigning metadata", (Throwable)new Exception("debug"));
                return;
            }
            this.metadata = m;
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            if (BaseManifestPutter.this.freeformMode) {
                boolean allMetadatas = false;
                BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
                synchronized (baseManifestPutter) {
                    BaseManifestPutter.this.putHandlersWaitingForMetadata.remove(this);
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersWaitingForMetadata, 2);
                        container.store((Object)this);
                    }
                    if (!(allMetadatas = BaseManifestPutter.this.putHandlersWaitingForMetadata.isEmpty()) && logMINOR) {
                        Logger.minor(this, "Still waiting for metadata: " + BaseManifestPutter.this.putHandlersWaitingForMetadata.size());
                    }
                }
                if (allMetadatas) {
                    BaseManifestPutter.this.gotAllMetadata(container, context);
                } else {
                    try {
                        byte[] buf = m.writeToByteArray();
                        if (buf.length > Short.MAX_VALUE) {
                            throw new MetadataUnresolvedException(new Metadata[]{m}, "Too big");
                        }
                    }
                    catch (MetadataUnresolvedException e) {
                        try {
                            BaseManifestPutter.this.resolve(e, container, context);
                        }
                        catch (IOException e1) {
                            BaseManifestPutter.this.fail(new InsertException(2, e1, null), container, context);
                            return;
                        }
                        catch (InsertException e1) {
                            BaseManifestPutter.this.fail(e1, container, context);
                        }
                    }
                }
            } else if (BaseManifestPutter.this.containerMode) {
                HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(this);
                ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.parentPutHandler)).remove(this);
                hm.put(this.itemName, m);
                if (this.persistent) {
                    container.ext().store((Object)hm, 2);
                }
                BaseManifestPutter.this.putHandlersTransformMap.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata, 2);
                    container.ext().store((Object)BaseManifestPutter.this.putHandlersTransformMap, 2);
                }
                try {
                    BaseManifestPutter.this.tryStartParentContainer(this.parentPutHandler, container, context);
                }
                catch (InsertException e) {
                    BaseManifestPutter.this.fail(e, container, context);
                    return;
                }
            } else {
                throw new RuntimeException("Neiter container nor freeform mode. Hu?");
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            super.onSuccess(state, container, context);
        }
    }

    private final class ContainerPutHandler
    extends PutHandler {
        private ContainerPutHandler(BaseManifestPutter bmp, PutHandler parent, String name, HashMap<String, Object> data, FreenetURI insertURI, Object object, boolean getCHKOnly, HashSet<PutHandler> runningMap) {
            super(bmp, parent, name, null, runningMap, null);
            this.origSFI = new ContainerInserter(this, this, data, this.persistent ? insertURI.clone() : insertURI, BaseManifestPutter.this.ctx, false, getCHKOnly, false, null, ArchiveManager.ARCHIVE_TYPE.TAR, false, BaseManifestPutter.this.earlyEncode, BaseManifestPutter.this.forceCryptoKey, BaseManifestPutter.this.cryptoAlgorithm, this.realTimeFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            if (this.persistent) {
                container.activate((Object)key, 5);
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            if (BaseManifestPutter.this.rootContainerPutHandler == this) {
                BaseManifestPutter.this.finalURI = key.getURI();
                if (this.persistent()) {
                    container.activate((Object)BaseManifestPutter.this.cb, 1);
                }
                BaseManifestPutter.this.cb.onGeneratedURI(this.persistent() ? BaseManifestPutter.this.finalURI.clone() : BaseManifestPutter.this.finalURI, this, container);
                if (this.persistent()) {
                    container.deactivate((Object)BaseManifestPutter.this.cb, 1);
                    container.store((Object)this);
                }
            } else {
                BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
                synchronized (baseManifestPutter) {
                    HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(this);
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(this.parentPutHandler)).remove(this);
                    Metadata m = new Metadata(0, null, null, key.getURI(), this.cm);
                    hm.put(this.itemName, m);
                    if (this.persistent) {
                        container.ext().store((Object)hm, 2);
                    }
                    BaseManifestPutter.this.putHandlersTransformMap.remove(this);
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersTransformMap, 2);
                    }
                    try {
                        BaseManifestPutter.this.tryStartParentContainer(this.parentPutHandler, container, context);
                    }
                    catch (InsertException e) {
                        BaseManifestPutter.this.fail(e, container, context);
                        return;
                    }
                }
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            if (BaseManifestPutter.this.rootContainerPutHandler == this) {
                if (BaseManifestPutter.this.containerPutHandlers.contains(this)) {
                    throw new IllegalStateException("was in containerPutHandlers");
                }
                BaseManifestPutter.this.rootContainerPutHandler = null;
            } else if (!BaseManifestPutter.this.containerPutHandlers.remove(this)) {
                throw new IllegalStateException("was not in containerPutHandlers");
            }
            super.onSuccess(state, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }
    }

    private final class ArchivePutHandler
    extends PutHandler {
        private ArchivePutHandler(BaseManifestPutter bmp, PutHandler parent, String name, HashMap<String, Object> data, FreenetURI insertURI, boolean getCHKOnly) {
            super(bmp, parent, name, null, BaseManifestPutter.this.containerPutHandlers, null);
            this.origSFI = new ContainerInserter(this, this, data, this.persistent ? insertURI.clone() : insertURI, BaseManifestPutter.this.ctx, false, getCHKOnly, false, null, ArchiveManager.ARCHIVE_TYPE.TAR, false, BaseManifestPutter.this.earlyEncode, BaseManifestPutter.this.forceCryptoKey, BaseManifestPutter.this.cryptoAlgorithm, this.realTimeFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEncode(BaseClientKey key, ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "onEncode(" + key.getURI().toString(false, false) + ") for " + this);
            }
            if (this.persistent) {
                container.activate((Object)key, 5);
                container.activate((Object)BaseManifestPutter.this, 2);
            }
            BaseManifestPutter baseManifestPutter = BaseManifestPutter.this;
            synchronized (baseManifestPutter) {
                Vector phv = (Vector)BaseManifestPutter.this.putHandlersArchiveTransformMap.get(this);
                for (PutHandler ph : phv) {
                    HashMap hm = (HashMap)BaseManifestPutter.this.putHandlersTransformMap.get(ph);
                    ((HashSet)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata.get(ph.parentPutHandler)).remove(ph);
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.perContainerPutHandlersWaitingForMetadata, 2);
                    }
                    if (ph.targetInArchive == null) {
                        throw new NullPointerException();
                    }
                    Metadata m = new Metadata(0, null, null, key.getURI().setMetaString(new String[]{ph.targetInArchive}), this.cm);
                    hm.put(ph.itemName, m);
                    if (this.persistent) {
                        container.ext().store((Object)hm, 2);
                    }
                    BaseManifestPutter.this.putHandlersTransformMap.remove(ph);
                    if (this.persistent) {
                        container.ext().store((Object)BaseManifestPutter.this.putHandlersTransformMap, 2);
                    }
                    try {
                        BaseManifestPutter.this.tryStartParentContainer(ph.parentPutHandler, container, context);
                    }
                    catch (InsertException e) {
                        BaseManifestPutter.this.fail(new InsertException(3, e, null), container, context);
                        return;
                    }
                }
                BaseManifestPutter.this.putHandlersArchiveTransformMap.remove(this);
                if (this.persistent) {
                    container.ext().store((Object)BaseManifestPutter.this.putHandlersArchiveTransformMap, 2);
                }
            }
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }

        @Override
        public void onSuccess(ClientPutState state, ObjectContainer container, ClientContext context) {
            if (logMINOR) {
                Logger.minor(this, "Completed '" + this.itemName + "' " + this);
            }
            if (this.persistent) {
                container.activate((Object)BaseManifestPutter.this, 1);
            }
            if (!BaseManifestPutter.this.containerPutHandlers.remove(this)) {
                throw new IllegalStateException("was not in containerPutHandlers");
            }
            super.onSuccess(state, container, context);
            if (this.persistent) {
                container.deactivate((Object)BaseManifestPutter.this, 1);
            }
        }
    }
}

