/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetState;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.SnoopBucket;
import freenet.client.async.SnoopMetadata;
import freenet.client.async.StreamGenerator;
import freenet.client.async.WantsCooldownCallback;
import freenet.client.events.EnterFiniteCooldownEvent;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.crypt.HashResult;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;

public class ClientGetter
extends BaseClientGetter
implements WantsCooldownCallback {
    private static volatile boolean logMINOR;
    final ClientGetCallback clientCallback;
    FreenetURI uri;
    final FetchContext ctx;
    final ArchiveContext actx;
    private ClientGetState currentState;
    private boolean finished;
    private int archiveRestarts;
    final Bucket returnBucket;
    private final BinaryBlobWriter binaryBlobWriter;
    private final boolean dontFinalizeBlobWriter;
    private String expectedMIME;
    private long expectedSize;
    private boolean finalizedMetadata;
    private SnoopMetadata snoopMeta;
    private SnoopBucket snoopBucket;
    private HashResult[] hashes;
    private final Bucket initialMetadata;
    final String forceCompatibleExtension;
    private int finalBlocksRequired;
    private int finalBlocksTotal;

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext) {
        this(client, uri, ctx, priorityClass, clientContext, null, null, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket) {
        this(client, uri, ctx, priorityClass, clientContext, returnBucket, null, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter) {
        this(client, uri, ctx, priorityClass, clientContext, returnBucket, binaryBlobWriter, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, Bucket initialMetadata) {
        this(client, uri, ctx, priorityClass, clientContext, returnBucket, binaryBlobWriter, false, initialMetadata);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, boolean dontFinalizeBlobWriter, Bucket initialMetadata) {
        this(client, uri, ctx, priorityClass, clientContext, returnBucket, binaryBlobWriter, dontFinalizeBlobWriter, initialMetadata, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, RequestClient clientContext, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, boolean dontFinalizeBlobWriter, Bucket initialMetadata, String forceCompatibleExtension) {
        super(priorityClass, clientContext);
        this.clientCallback = client;
        this.returnBucket = returnBucket;
        this.uri = uri.clone();
        this.ctx = ctx;
        this.finished = false;
        this.actx = new ArchiveContext(ctx.maxTempLength, ctx.maxArchiveLevels);
        this.binaryBlobWriter = binaryBlobWriter;
        this.dontFinalizeBlobWriter = dontFinalizeBlobWriter;
        this.initialMetadata = initialMetadata;
        this.archiveRestarts = 0;
        this.forceCompatibleExtension = forceCompatibleExtension;
    }

    public void start(ObjectContainer container, ClientContext context) throws FetchException {
        this.start(false, null, container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean restart, FreenetURI overrideURI, ObjectContainer container, ClientContext context) throws FetchException {
        if (this.persistent()) {
            container.activate((Object)this.uri, 5);
            container.activate((Object)this.ctx, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistent=" + this.persistent() + " for " + this.uri);
        }
        try {
            HashResult[] oldHashes = null;
            String overrideMIME = this.ctx.overrideMIME;
            ClientGetter clientGetter = this;
            synchronized (clientGetter) {
                if (restart) {
                    this.clearCountersOnRestart();
                }
                if (overrideURI != null) {
                    this.uri = overrideURI;
                }
                if (this.finished) {
                    if (!restart) {
                        return false;
                    }
                    this.currentState = null;
                    this.cancelled = false;
                    this.finished = false;
                }
                this.expectedMIME = null;
                if (overrideMIME != null) {
                    this.expectedMIME = overrideMIME;
                }
                this.expectedSize = 0L;
                oldHashes = this.hashes;
                this.hashes = null;
                this.finalBlocksRequired = 0;
                this.finalBlocksTotal = 0;
                this.resetBlocks();
                this.currentState = SingleFileFetcher.create(this, this, this.uri, this.ctx, this.actx, this.ctx.maxNonSplitfileRetries, 0, false, -1L, true, true, container, context, this.realTimeFlag, this.initialMetadata != null);
            }
            if (this.persistent() && oldHashes != null) {
                for (HashResult res : oldHashes) {
                    if (res == null) continue;
                    res.removeFrom(container);
                }
            }
            if (this.cancelled) {
                this.cancel();
            }
            if (this.persistent()) {
                container.store((Object)this.currentState);
                container.store((Object)this);
            }
            if (this.currentState != null && !this.finished) {
                if (this.initialMetadata != null && this.currentState instanceof SingleFileFetcher) {
                    if (this.persistent()) {
                        container.activate((Object)this.initialMetadata, 1);
                    }
                    ((SingleFileFetcher)this.currentState).startWithMetadata(this.initialMetadata, container, context);
                    if (this.persistent()) {
                        container.deactivate((Object)this.initialMetadata, 1);
                    }
                } else {
                    this.currentState.schedule(container, context);
                }
            }
            if (this.cancelled) {
                this.cancel();
            }
        }
        catch (MalformedURLException e) {
            throw new FetchException(20, (Throwable)e);
        }
        catch (KeyListenerConstructionException e) {
            this.onFailure(e.getFetchException(), this.currentState, container, context);
        }
        if (this.persistent()) {
            container.store((Object)this);
            container.deactivate((Object)this.currentState, 1);
        }
        return true;
    }

    @Override
    protected void clearCountersOnRestart() {
        this.archiveRestarts = 0;
        this.expectedMIME = null;
        this.expectedSize = 0L;
        this.finalBlocksRequired = 0;
        this.finalBlocksTotal = 0;
        super.clearCountersOnRestart();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ObjectContainer container, ClientContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context) {
        this.onFailure(e, state, container, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetState state, ObjectContainer container, ClientContext context, boolean force) {
        Object e12;
        boolean alreadyFinished;
        ClientGetState oldState;
        block34: {
            Object unsafe;
            if (logMINOR) {
                Logger.minor(this, "Failed from " + state + " : " + e + " on " + this, (Throwable)e);
            }
            if (this.persistent()) {
                container.activate((Object)this.uri, 5);
                container.activate((Object)this.ctx, 1);
            }
            oldState = null;
            if (this.expectedSize > 0L && (e.expectedSize <= 0L || this.finalBlocksTotal != 0)) {
                e.expectedSize = this.expectedSize;
            }
            if (e.mode == 21 && this.ctx.filterData && e.finalizedSize()) {
                String mime = e.getExpectedMimeType();
                if (this.ctx.overrideMIME != null) {
                    mime = this.ctx.overrideMIME;
                }
                if (mime != null && !"".equals(mime) && (unsafe = ContentFilter.checkMIMEType(mime)) != null) {
                    e = ((UnsafeContentTypeException)unsafe).recreateFetchException(e, mime);
                }
            }
            while (e.mode == 26) {
                int ar;
                unsafe = this;
                synchronized (unsafe) {
                    ar = ++this.archiveRestarts;
                }
                if (logMINOR) {
                    Logger.minor(this, "Archive restart on " + this + " ar=" + ar);
                }
                if (ar > this.ctx.maxArchiveRestarts) {
                    e = new FetchException(8);
                    break;
                }
                try {
                    this.start(container, context);
                }
                catch (FetchException e12) {
                    e = e12;
                    continue;
                }
                return;
            }
            alreadyFinished = false;
            e12 = this;
            synchronized (e12) {
                if (this.finished && !force) {
                    if (!this.cancelled) {
                        Logger.error(this, "Already finished - not calling callbacks on " + this, (Throwable)new Exception("error"));
                    }
                    alreadyFinished = true;
                }
                this.finished = true;
                oldState = this.currentState;
                this.currentState = null;
            }
            if (!alreadyFinished) {
                try {
                    if (this.binaryBlobWriter != null && !this.dontFinalizeBlobWriter) {
                        this.binaryBlobWriter.finalizeBucket();
                    }
                }
                catch (IOException ioe) {
                    if (e.mode != 25 && !force) {
                        e = new FetchException(12, "Failed to close binary blob stream: " + ioe);
                    }
                }
                catch (BinaryBlobWriter.BinaryBlobAlreadyClosedException ee) {
                    if (e.mode == 12 || e.mode == 25 || force) break block34;
                    e = new FetchException(12, "Failed to close binary blob stream, already closed: " + ee, ee);
                }
            }
        }
        if (e.errorCodes != null && e.errorCodes.isOneCodeOnly()) {
            e = new FetchException(e.errorCodes.getFirstCode());
        }
        if (e.mode == 13 && this.successfulBlocks > 0) {
            e = new FetchException(e, 28);
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + ", " + state + ") on " + this + " for " + this.uri, (Throwable)e);
        }
        e12 = e;
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (this.persistent()) {
            container.activate((Object)this.clientCallback, 1);
        }
        if (this.persistent()) {
            if (state != null) {
                container.activate((Object)state, 1);
                state.removeFrom(container, context);
            }
            if (oldState != state && oldState != null) {
                container.activate((Object)oldState, 1);
                oldState.removeFrom(container, context);
            }
        }
        if (!alreadyFinished) {
            this.clientCallback.onFailure((FetchException)e12, this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ObjectContainer container, ClientContext context) {
        ClientGetState state;
        ClientGetState s;
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (super.cancel()) {
                if (logMINOR) {
                    Logger.minor(this, "Already cancelled " + this);
                }
                return;
            }
            s = this.currentState;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        if (s != null) {
            if (this.persistent()) {
                container.activate((Object)s, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + s + " for " + this + " instance " + super.toString());
            }
            s.cancel(container, context);
            if (this.persistent()) {
                container.deactivate((Object)s, 1);
            }
        } else if (logMINOR) {
            Logger.minor(this, "Nothing to cancel");
        }
        ClientGetter clientGetter2 = this;
        synchronized (clientGetter2) {
            state = this.currentState;
        }
        if (state == null) {
            return;
        }
        Logger.error(this, "Cancelling " + this.currentState + " did not call onFailure(), so did not removeFrom() or call callback");
        this.onFailure(new FetchException(25), state, container, context);
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    @Override
    public FreenetURI getURI() {
        return this.uri;
    }

    @Override
    public void notifyClients(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        int total = this.totalBlocks;
        int minSuccess = this.minSuccessBlocks;
        boolean finalized = this.blockSetFinalized;
        if (this.finalBlocksRequired != 0) {
            total = this.finalBlocksTotal;
            minSuccess = this.finalBlocksRequired;
            finalized = true;
        }
        this.ctx.eventProducer.produceEvent(new SplitfileProgressEvent(total, this.successfulBlocks, this.failedBlocks, this.fatallyFailedBlocks, minSuccess, 0, finalized), container, context);
    }

    @Override
    protected void innerToNetwork(ObjectContainer container, ClientContext context) {
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), container, context);
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ObjectContainer container, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ObjectContainer container) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                if (logMINOR) {
                    Logger.minor(this, "Transition: " + oldState + " -> " + newState + " on " + this + " persistent = " + this.persistent() + " instance = " + super.toString(), (Throwable)new Exception("debug"));
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transition: " + oldState + " -> " + newState + " because current = " + this.currentState + " on " + this + " persistent = " + this.persistent(), (Throwable)new Exception("debug"));
                }
                return;
            }
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            if (logMINOR) {
                Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            }
            return false;
        }
        return true;
    }

    public boolean restart(FreenetURI redirect, boolean filterData, ObjectContainer container, ClientContext context) throws FetchException {
        this.checkForBrokenClient(container, context);
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.filterData, 1);
        }
        this.ctx.filterData = filterData;
        if (this.persistent()) {
            container.store((Object)this.ctx);
        }
        return this.start(true, redirect, container, context);
    }

    public String toString() {
        return super.toString();
    }

    protected void addKeyToBinaryBlob(ClientKeyBlock block, ObjectContainer container, ClientContext context) {
        if (this.binaryBlobWriter == null) {
            return;
        }
        if (this.persistent()) {
            container.activate((Object)this.binaryBlobWriter, 1);
        }
        if (logMINOR) {
            Logger.minor(this, "Adding key " + block.getClientKey().getURI() + " to " + this, (Throwable)new Exception("debug"));
        }
        try {
            this.binaryBlobWriter.addKey(block, context, container);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to write key to binary blob stream: " + e, (Throwable)e);
            this.onFailure(new FetchException(12, "Failed to write key to binary blob stream: " + e), null, container, context);
        }
        catch (BinaryBlobWriter.BinaryBlobAlreadyClosedException e) {
            Logger.error(this, "Failed to write key to binary blob stream (already closed??): " + e, (Throwable)e);
            this.onFailure(new FetchException(12, "Failed to write key to binary blob stream (already closed??): " + e), null, container, context);
        }
    }

    protected boolean collectingBinaryBlob() {
        return this.binaryBlobWriter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExpectedMIME(ClientMetadata clientMetadata, ObjectContainer container, ClientContext context) throws FetchException {
        if (this.finalizedMetadata) {
            return;
        }
        if (this.persistent()) {
            container.activate((Object)this.ctx, 1);
        }
        String mime = null;
        if (!clientMetadata.isTrivial()) {
            mime = clientMetadata.getMIMEType();
        }
        if (this.ctx.overrideMIME != null) {
            mime = this.ctx.overrideMIME;
        }
        if (mime == null || mime.equals("")) {
            return;
        }
        if (this.ctx.filterData) {
            UnsafeContentTypeException e = ContentFilter.checkMIMEType(mime);
            if (e != null) {
                throw e.createFetchException(mime, this.expectedSize);
            }
            if (this.forceCompatibleExtension != null) {
                this.checkCompatibleExtension(mime);
            }
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            this.expectedMIME = mime;
        }
        if (this.persistent()) {
            container.store((Object)this);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new ExpectedMIMEEvent(mime), container, context);
    }

    private void checkCompatibleExtension(String mimeType) throws FetchException {
        FilterMIMEType type = ContentFilter.getMIMEType(mimeType);
        if (type == null) {
            return;
        }
        if (!DefaultMIMETypes.isValidExt(mimeType, this.forceCompatibleExtension)) {
            throw new FetchException(36);
        }
    }

    @Override
    public void onExpectedSize(long size, ObjectContainer container, ClientContext context) {
        if (this.finalizedMetadata) {
            return;
        }
        if (this.finalBlocksRequired != 0) {
            return;
        }
        this.expectedSize = size;
        if (this.persistent()) {
            container.store((Object)this);
            container.activate((Object)this.ctx, 1);
            container.activate((Object)this.ctx.eventProducer, 1);
        }
        this.ctx.eventProducer.produceEvent(new ExpectedFileSizeEvent(size), container, context);
    }

    @Override
    public void onFinalizedMetadata(ObjectContainer container) {
        this.finalizedMetadata = true;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    public boolean finalizedMetadata() {
        return this.finalizedMetadata;
    }

    public String expectedMIME() {
        return this.expectedMIME;
    }

    public long expectedSize() {
        return this.expectedSize;
    }

    public ClientGetCallback getClientCallback() {
        return this.clientCallback;
    }

    @Override
    public void removeFrom(ObjectContainer container, ClientContext context) {
        container.activate((Object)this.uri, 5);
        this.uri.removeFrom(container);
        container.activate((Object)this.ctx, 1);
        this.ctx.removeFrom(container);
        container.activate((Object)this.actx, 5);
        this.actx.removeFrom(container);
        if (this.returnBucket != null) {
            container.activate((Object)this.returnBucket, 1);
            this.returnBucket.removeFrom(container);
        }
        super.removeFrom(container, context);
    }

    public SnoopMetadata getMetaSnoop() {
        return this.snoopMeta;
    }

    public SnoopMetadata setMetaSnoop(SnoopMetadata newSnoop) {
        SnoopMetadata old = this.snoopMeta;
        this.snoopMeta = newSnoop;
        return old;
    }

    public SnoopBucket getBucketSnoop() {
        return this.snoopBucket;
    }

    public SnoopBucket setBucketSnoop(SnoopBucket newSnoop) {
        SnoopBucket old = this.snoopBucket;
        this.snoopBucket = newSnoop;
        return old;
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ObjectContainer container, ClientContext context) {
        if (this.finalBlocksRequired != 0 || this.finalBlocksTotal != 0) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "New format metadata has top data: original size " + size + " (compressed " + compressed + ") blocks " + blocksReq + " / " + blocksTotal);
        }
        this.onExpectedSize(size, container, context);
        this.finalBlocksRequired = this.minSuccessBlocks + blocksReq;
        this.finalBlocksTotal = this.totalBlocks + blocksTotal;
        if (this.persistent()) {
            container.store((Object)this);
        }
        this.notifyClients(container, context);
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] customSplitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ObjectContainer container, ClientContext context) {
        this.ctx.eventProducer.produceEvent(new SplitfileCompatibilityModeEvent(min, max, customSplitfileKey, dontCompress, bottomLayer || definitiveAnyway), container, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHashes(HashResult[] hashes, ObjectContainer container, ClientContext context) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.hashes != null) {
                if (this.persistent()) {
                    container.activate((Object)this.hashes, Integer.MAX_VALUE);
                }
                if (!HashResult.strictEquals(hashes, this.hashes)) {
                    Logger.error(this, "Two sets of hashes?!");
                }
                return;
            }
            this.hashes = hashes;
        }
        if (this.persistent()) {
            container.store((Object)this);
        }
        HashResult[] clientHashes = hashes;
        if (this.persistent()) {
            clientHashes = HashResult.copy(hashes);
        }
        this.ctx.eventProducer.produceEvent(new ExpectedHashesEvent(clientHashes), container, context);
    }

    @Override
    public void enterCooldown(long wakeupTime, ObjectContainer container, ClientContext context) {
        if (wakeupTime != Long.MAX_VALUE) {
            if (this.persistent()) {
                container.activate((Object)this.ctx, 1);
                container.activate((Object)this.ctx.eventProducer, 1);
            }
            this.ctx.eventProducer.produceEvent(new EnterFiniteCooldownEvent(wakeupTime), container, context);
        }
    }

    @Override
    public void clearCooldown(ObjectContainer container) {
    }

    public Bucket getBlobBucket() {
        return this.binaryBlobWriter.getFinalBucket();
    }

    static {
        Logger.registerClass(ClientGetter.class);
    }
}

