/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerBase;
import freenet.crypt.RandomSource;
import freenet.node.BaseSendableGet;
import freenet.support.Logger;
import java.util.ArrayDeque;
import java.util.Deque;

class ClientRequestSchedulerNonPersistent
extends ClientRequestSchedulerBase {
    private boolean logMINOR;
    protected final Deque<BaseSendableGet> recentSuccesses;

    ClientRequestSchedulerNonPersistent(ClientRequestScheduler sched, boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random) {
        super(forInserts, forSSKs, forRT, random);
        this.sched = sched;
        this.recentSuccesses = !forInserts ? new ArrayDeque<BaseSendableGet>() : null;
        this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    @Override
    boolean persistent() {
        return false;
    }

    ObjectContainer container() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void succeeded(BaseSendableGet succeeded, ObjectContainer container) {
        if (this.isInsertScheduler) {
            return;
        }
        if (this.persistent()) {
            container.activate((Object)succeeded, 1);
        }
        if (succeeded.isCancelled(container)) {
            return;
        }
        if (this.logMINOR) {
            Logger.minor(this, "Recording successful fetch from " + succeeded);
        }
        Deque<BaseSendableGet> deque = this.recentSuccesses;
        synchronized (deque) {
            while (this.recentSuccesses.size() >= 8) {
                this.recentSuccesses.pollFirst();
            }
            this.recentSuccesses.add(succeeded);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing ClientRequestSchedulerNonPersistent in database", (Throwable)new Exception("error"));
        return false;
    }
}

